DROP TABLE IF EXISTS AreaPermissionAssignments;

CREATE TABLE IF NOT EXISTS `AreaPermissionAssignments` (
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `arHandle` varchar(255) NOT NULL,
  `pkID` int(10) unsigned NOT NULL DEFAULT '0',
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cID`,`arHandle`,`pkID`,`paID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS AreaPermissionBlockTypeAccessList;

CREATE TABLE IF NOT EXISTS `AreaPermissionBlockTypeAccessList` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `permission` varchar(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`paID`,`peID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS AreaPermissionBlockTypeAccessListCustom;

CREATE TABLE IF NOT EXISTS `AreaPermissionBlockTypeAccessListCustom` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `btID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`paID`,`peID`,`btID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS Areas;

CREATE TABLE IF NOT EXISTS `Areas` (
  `arID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `arHandle` varchar(255) NOT NULL,
  `arOverrideCollectionPermissions` tinyint(1) NOT NULL DEFAULT '0',
  `arInheritPermissionsFromAreaOnCID` int(10) unsigned NOT NULL DEFAULT '0',
  `arIsGlobal` int(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`arID`),
  KEY `arIsGlobal` (`arIsGlobal`),
  KEY `cID` (`cID`),
  KEY `arHandle` (`arHandle`)
) ENGINE=InnoDB AUTO_INCREMENT=70 DEFAULT CHARSET=utf8;

INSERT INTO Areas VALUES(1,106,'Header',0,0,0)
 ,(2,106,'Column 1',0,0,0)
 ,(3,106,'Column 2',0,0,0)
 ,(4,106,'Column 3',0,0,0)
 ,(5,106,'Column 4',0,0,0)
 ,(6,107,'Primary',0,0,0)
 ,(7,107,'Secondary 1',0,0,0)
 ,(8,107,'Secondary 2',0,0,0)
 ,(9,107,'Secondary 3',0,0,0)
 ,(10,107,'Secondary 4',0,0,0)
 ,(11,107,'Secondary 5',0,0,0)
 ,(12,1,'Header Nav',0,0,0)
 ,(13,1,'Header',0,0,0)
 ,(14,1,'Sidebar',0,0,0)
 ,(15,1,'Main',0,0,0)
 ,(16,1,'Badges',0,0,1)
 ,(17,122,'Main',0,0,0)
 ,(18,1,'Map',0,0,1)
 ,(19,123,'Main',0,0,0)
 ,(20,1,'Cottage Calendar',0,0,0)
 ,(21,1,'Slideshow',0,0,0)
 ,(22,1,'Slideshow Side Bar',0,0,0)
 ,(23,1,'Main Side Bar',0,0,0)
 ,(24,124,'Slideshow',0,0,0)
 ,(25,124,'Main',0,0,0)
 ,(26,124,'Main Side Bar',0,0,0)
 ,(27,124,'Badges',0,0,1)
 ,(28,124,'Slideshow Side Bar',0,0,0)
 ,(29,125,'Slideshow',0,0,0)
 ,(30,125,'Main',0,0,0)
 ,(31,125,'Main Side Bar',0,0,0)
 ,(32,125,'Badges',0,0,1)
 ,(33,125,'Slideshow Side Bar',0,0,0)
 ,(34,125,'Column One',0,0,0)
 ,(35,125,'Column Two',0,0,0)
 ,(36,125,'Column Three',0,0,0)
 ,(37,125,'Tariff',0,0,0)
 ,(38,125,'Booking Info',0,0,0)
 ,(39,125,'Testimonials',0,0,0)
 ,(40,126,'Slideshow',0,0,0)
 ,(41,126,'Main',0,0,0)
 ,(42,126,'Main Side Bar',0,0,0)
 ,(43,126,'Badges',0,0,1)
 ,(44,126,'Slideshow Side Bar',0,0,0)
 ,(45,126,'Column One',0,0,0)
 ,(46,126,'Column Two',0,0,0)
 ,(47,128,'Slideshow',0,0,0)
 ,(48,128,'Main',0,0,0)
 ,(49,128,'Main Side Bar',0,0,0)
 ,(50,128,'Badges',0,0,1)
 ,(51,128,'Slideshow Side Bar',0,0,0)
 ,(52,128,'Column One',0,0,0)
 ,(53,128,'Column Two',0,0,0)
 ,(54,129,'Slideshow',0,0,0)
 ,(55,129,'Main',0,0,0)
 ,(56,129,'Main Side Bar',0,0,0)
 ,(57,129,'Badges',0,0,1)
 ,(58,129,'Slideshow Side Bar',0,0,0)
 ,(59,129,'Column One',0,0,0)
 ,(60,129,'Column Two',0,0,0)
 ,(61,129,'Column Three',0,0,0)
 ,(62,130,'Slideshow',0,0,0)
 ,(63,130,'Main',0,0,0)
 ,(64,130,'Main Side Bar',0,0,0)
 ,(65,130,'Badges',0,0,1)
 ,(66,130,'Slideshow Side Bar',0,0,0)
 ,(67,130,'Column One',0,0,0)
 ,(68,130,'Column Two',0,0,0)
 ,(69,130,'Column Three',0,0,0);

DROP TABLE IF EXISTS AttributeKeyCategories;

CREATE TABLE IF NOT EXISTS `AttributeKeyCategories` (
  `akCategoryID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `akCategoryHandle` varchar(255) NOT NULL,
  `akCategoryAllowSets` smallint(4) NOT NULL DEFAULT '0',
  `pkgID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`akCategoryID`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO AttributeKeyCategories VALUES(1,'collection',1,NULL)
 ,(2,'user',1,NULL)
 ,(3,'file',1,NULL);

DROP TABLE IF EXISTS AttributeKeys;

CREATE TABLE IF NOT EXISTS `AttributeKeys` (
  `akID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `akHandle` varchar(255) NOT NULL,
  `akName` varchar(255) NOT NULL,
  `akIsSearchable` tinyint(1) NOT NULL DEFAULT '0',
  `akIsSearchableIndexed` tinyint(1) NOT NULL DEFAULT '0',
  `akIsAutoCreated` tinyint(1) NOT NULL DEFAULT '0',
  `akIsInternal` tinyint(1) NOT NULL DEFAULT '0',
  `akIsColumnHeader` tinyint(1) NOT NULL DEFAULT '0',
  `akIsEditable` tinyint(1) NOT NULL DEFAULT '0',
  `atID` int(10) unsigned DEFAULT NULL,
  `akCategoryID` int(10) unsigned DEFAULT NULL,
  `pkgID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`akID`),
  UNIQUE KEY `akHandle` (`akHandle`,`akCategoryID`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8;

INSERT INTO AttributeKeys VALUES(1,'meta_title','Meta Title',1,1,0,0,0,1,1,1,0)
 ,(2,'meta_description','Meta Description',1,1,0,0,0,1,2,1,0)
 ,(3,'meta_keywords','Meta Keywords',1,1,0,0,0,1,2,1,0)
 ,(4,'icon_dashboard','Dashboard Icon',1,1,0,1,0,1,2,1,0)
 ,(5,'exclude_nav','Exclude From Nav',1,1,0,0,0,1,3,1,0)
 ,(6,'exclude_page_list','Exclude From Page List',1,1,0,0,0,1,3,1,0)
 ,(7,'header_extra_content','Header Extra Content',1,1,0,0,0,1,2,1,0)
 ,(8,'exclude_search_index','Exclude From Search Index',1,1,0,0,0,1,3,1,0)
 ,(9,'exclude_sitemapxml','Exclude From sitemap.xml',1,1,0,0,0,1,3,1,0)
 ,(10,'profile_private_messages_enabled','I would like to receive private messages.',1,1,0,0,0,1,3,2,0)
 ,(11,'profile_private_messages_notification_enabled','Send me email notifications when I receive a private message.',1,1,0,0,0,1,3,2,0)
 ,(12,'width','Width',1,1,0,0,0,1,6,3,0)
 ,(13,'height','Height',1,1,0,0,0,1,6,3,0)
 ,(14,'duration','Duration',1,1,0,0,0,1,6,3,0)
 ,(15,'body_class','Body Class',1,0,0,0,0,1,1,1,0);

DROP TABLE IF EXISTS AttributeSetKeys;

CREATE TABLE IF NOT EXISTS `AttributeSetKeys` (
  `akID` int(10) unsigned NOT NULL DEFAULT '0',
  `asID` int(10) unsigned NOT NULL DEFAULT '0',
  `displayOrder` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`akID`,`asID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO AttributeSetKeys VALUES(1,1,1)
 ,(2,1,2)
 ,(3,1,3)
 ,(5,2,1)
 ,(6,2,2)
 ,(7,1,4)
 ,(8,2,3)
 ,(9,2,4)
 ,(15,1,5);

DROP TABLE IF EXISTS AttributeSets;

CREATE TABLE IF NOT EXISTS `AttributeSets` (
  `asID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `asName` varchar(255) DEFAULT NULL,
  `asHandle` varchar(255) NOT NULL,
  `akCategoryID` int(10) unsigned NOT NULL DEFAULT '0',
  `pkgID` int(10) unsigned NOT NULL DEFAULT '0',
  `asIsLocked` int(1) NOT NULL DEFAULT '1',
  `asDisplayOrder` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`asID`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO AttributeSets VALUES(1,'Page Header','page_header',1,0,0,0)
 ,(2,'Navigation and Indexing','navigation',1,0,0,1);

DROP TABLE IF EXISTS AttributeTypeCategories;

CREATE TABLE IF NOT EXISTS `AttributeTypeCategories` (
  `atID` int(10) unsigned NOT NULL DEFAULT '0',
  `akCategoryID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`atID`,`akCategoryID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO AttributeTypeCategories VALUES(1,1)
 ,(1,2)
 ,(1,3)
 ,(2,1)
 ,(2,2)
 ,(2,3)
 ,(3,1)
 ,(3,2)
 ,(3,3)
 ,(4,1)
 ,(4,2)
 ,(4,3)
 ,(5,1)
 ,(6,1)
 ,(6,2)
 ,(6,3)
 ,(7,1)
 ,(7,3)
 ,(8,1)
 ,(8,2)
 ,(8,3)
 ,(9,2);

DROP TABLE IF EXISTS AttributeTypes;

CREATE TABLE IF NOT EXISTS `AttributeTypes` (
  `atID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `atHandle` varchar(255) NOT NULL,
  `atName` varchar(255) NOT NULL,
  `pkgID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`atID`),
  UNIQUE KEY `atHandle` (`atHandle`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

INSERT INTO AttributeTypes VALUES(1,'text','Text',0)
 ,(2,'textarea','Text Area',0)
 ,(3,'boolean','Checkbox',0)
 ,(4,'date_time','Date/Time',0)
 ,(5,'image_file','Image/File',0)
 ,(6,'number','Number',0)
 ,(7,'rating','Rating',0)
 ,(8,'select','Select',0)
 ,(9,'address','Address',0);

DROP TABLE IF EXISTS AttributeValues;

CREATE TABLE IF NOT EXISTS `AttributeValues` (
  `avID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `akID` int(10) unsigned DEFAULT NULL,
  `avDateAdded` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `uID` int(10) unsigned DEFAULT NULL,
  `atID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`avID`)
) ENGINE=InnoDB AUTO_INCREMENT=138 DEFAULT CHARSET=utf8;

INSERT INTO AttributeValues VALUES(1,3,'2016-05-21 13:53:32',1,2)
 ,(2,4,'2016-05-21 13:53:32',1,2)
 ,(3,3,'2016-05-21 13:53:32',1,2)
 ,(4,4,'2016-05-21 13:53:32',1,2)
 ,(5,3,'2016-05-21 13:53:32',1,2)
 ,(6,4,'2016-05-21 13:53:32',1,2)
 ,(7,3,'2016-05-21 13:53:32',1,2)
 ,(8,3,'2016-05-21 13:53:32',1,2)
 ,(9,4,'2016-05-21 13:53:32',1,2)
 ,(10,3,'2016-05-21 13:53:32',1,2)
 ,(11,4,'2016-05-21 13:53:32',1,2)
 ,(12,3,'2016-05-21 13:53:32',1,2)
 ,(13,4,'2016-05-21 13:53:32',1,2)
 ,(14,3,'2016-05-21 13:53:32',1,2)
 ,(15,4,'2016-05-21 13:53:32',1,2)
 ,(16,3,'2016-05-21 13:53:32',1,2)
 ,(17,4,'2016-05-21 13:53:32',1,2)
 ,(18,3,'2016-05-21 13:53:32',1,2)
 ,(19,4,'2016-05-21 13:53:32',1,2)
 ,(20,5,'2016-05-21 13:53:32',1,3)
 ,(21,3,'2016-05-21 13:53:32',1,2)
 ,(22,4,'2016-05-21 13:53:32',1,2)
 ,(23,3,'2016-05-21 13:53:32',1,2)
 ,(24,3,'2016-05-21 13:53:32',1,2)
 ,(25,4,'2016-05-21 13:53:32',1,2)
 ,(26,3,'2016-05-21 13:53:32',1,2)
 ,(27,4,'2016-05-21 13:53:32',1,2)
 ,(28,3,'2016-05-21 13:53:32',1,2)
 ,(29,4,'2016-05-21 13:53:32',1,2)
 ,(30,3,'2016-05-21 13:53:32',1,2)
 ,(31,5,'2016-05-21 13:53:32',1,3)
 ,(32,4,'2016-05-21 13:53:32',1,2)
 ,(33,3,'2016-05-21 13:53:32',1,2)
 ,(34,5,'2016-05-21 13:53:32',1,3)
 ,(35,4,'2016-05-21 13:53:32',1,2)
 ,(36,3,'2016-05-21 13:53:32',1,2)
 ,(37,4,'2016-05-21 13:53:32',1,2)
 ,(38,3,'2016-05-21 13:53:32',1,2)
 ,(39,3,'2016-05-21 13:53:32',1,2)
 ,(40,4,'2016-05-21 13:53:32',1,2)
 ,(41,3,'2016-05-21 13:53:32',1,2)
 ,(42,4,'2016-05-21 13:53:32',1,2)
 ,(43,3,'2016-05-21 13:53:32',1,2)
 ,(44,4,'2016-05-21 13:53:32',1,2)
 ,(45,3,'2016-05-21 13:53:32',1,2)
 ,(46,4,'2016-05-21 13:53:32',1,2)
 ,(47,3,'2016-05-21 13:53:32',1,2)
 ,(48,4,'2016-05-21 13:53:32',1,2)
 ,(49,3,'2016-05-21 13:53:32',1,2)
 ,(50,3,'2016-05-21 13:53:32',1,2)
 ,(51,3,'2016-05-21 13:53:32',1,2)
 ,(52,3,'2016-05-21 13:53:32',1,2)
 ,(53,4,'2016-05-21 13:53:32',1,2)
 ,(54,3,'2016-05-21 13:53:32',1,2)
 ,(55,4,'2016-05-21 13:53:32',1,2)
 ,(56,3,'2016-05-21 13:53:32',1,2)
 ,(57,4,'2016-05-21 13:53:32',1,2)
 ,(58,3,'2016-05-21 13:53:32',1,2)
 ,(59,4,'2016-05-21 13:53:32',1,2)
 ,(60,4,'2016-05-21 13:53:32',1,2)
 ,(61,3,'2016-05-21 13:53:32',1,2)
 ,(62,4,'2016-05-21 13:53:32',1,2)
 ,(63,4,'2016-05-21 13:53:32',1,2)
 ,(64,5,'2016-05-21 13:53:32',1,3)
 ,(65,8,'2016-05-21 13:53:32',1,3)
 ,(66,3,'2016-05-21 13:53:33',1,2)
 ,(67,4,'2016-05-21 13:53:33',1,2)
 ,(68,5,'2016-05-21 13:53:33',1,3)
 ,(69,5,'2016-05-21 13:53:33',1,3)
 ,(70,3,'2016-05-21 13:53:33',1,2)
 ,(71,3,'2016-05-21 13:53:33',1,2)
 ,(72,3,'2016-05-21 13:53:33',1,2)
 ,(73,3,'2016-05-21 13:53:33',1,2)
 ,(74,3,'2016-05-21 13:53:33',1,2)
 ,(75,5,'2016-05-21 13:53:33',1,3)
 ,(76,3,'2016-05-21 13:53:33',1,2)
 ,(77,3,'2016-05-21 13:53:33',1,2)
 ,(78,3,'2016-05-21 13:53:33',1,2)
 ,(79,3,'2016-05-21 13:53:33',1,2)
 ,(80,3,'2016-05-21 13:53:33',1,2)
 ,(81,3,'2016-05-21 13:53:33',1,2)
 ,(82,3,'2016-05-21 13:53:33',1,2)
 ,(83,3,'2016-05-21 13:53:33',1,2)
 ,(84,3,'2016-05-21 13:53:33',1,2)
 ,(85,3,'2016-05-21 13:53:33',1,2)
 ,(86,3,'2016-05-21 13:53:33',1,2)
 ,(87,3,'2016-05-21 13:53:33',1,2)
 ,(88,3,'2016-05-21 13:53:33',1,2)
 ,(89,3,'2016-05-21 13:53:33',1,2)
 ,(90,3,'2016-05-21 13:53:33',1,2)
 ,(91,3,'2016-05-21 13:53:33',1,2)
 ,(92,3,'2016-05-21 13:53:33',1,2)
 ,(93,3,'2016-05-21 13:53:33',1,2)
 ,(94,3,'2016-05-21 13:53:33',1,2)
 ,(95,3,'2016-05-21 13:53:33',1,2)
 ,(96,3,'2016-05-21 13:53:33',1,2)
 ,(97,3,'2016-05-21 13:53:33',1,2)
 ,(98,3,'2016-05-21 13:53:33',1,2)
 ,(99,3,'2016-05-21 13:53:33',1,2)
 ,(100,3,'2016-05-21 13:53:33',1,2)
 ,(101,3,'2016-05-21 13:53:33',1,2)
 ,(102,3,'2016-05-21 13:53:33',1,2)
 ,(103,3,'2016-05-21 13:53:33',1,2)
 ,(104,3,'2016-05-21 13:53:33',1,2)
 ,(105,3,'2016-05-21 13:53:33',1,2)
 ,(106,3,'2016-05-21 13:53:33',1,2)
 ,(107,3,'2016-05-21 13:53:33',1,2)
 ,(108,3,'2016-05-21 13:53:33',1,2)
 ,(109,8,'2016-05-21 13:53:33',1,3)
 ,(110,3,'2016-05-21 13:53:33',1,2)
 ,(111,3,'2016-05-21 13:53:33',1,2)
 ,(112,3,'2016-05-21 13:53:33',1,2)
 ,(113,3,'2016-05-21 13:53:33',1,2)
 ,(114,3,'2016-05-21 13:53:33',1,2)
 ,(115,3,'2016-05-21 13:53:33',1,2)
 ,(116,3,'2016-05-21 13:53:33',1,2)
 ,(117,3,'2016-05-21 13:53:33',1,2)
 ,(118,5,'2016-05-21 13:53:34',1,3)
 ,(119,5,'2016-05-21 13:53:34',1,3)
 ,(120,8,'2016-05-21 13:53:34',1,3)
 ,(121,12,'2016-05-30 13:59:39',1,6)
 ,(122,13,'2016-05-30 13:59:39',1,6)
 ,(123,12,'2016-05-30 13:59:39',1,6)
 ,(124,13,'2016-05-30 13:59:39',1,6)
 ,(125,12,'2016-05-30 13:59:40',1,6)
 ,(126,13,'2016-05-30 13:59:40',1,6)
 ,(127,15,'2016-06-04 14:57:39',1,1)
 ,(128,12,'2016-06-04 15:47:09',1,6)
 ,(129,13,'2016-06-04 15:47:09',1,6)
 ,(130,12,'2016-06-04 15:47:09',1,6)
 ,(131,13,'2016-06-04 15:47:09',1,6)
 ,(132,12,'2016-06-04 15:47:09',1,6)
 ,(133,13,'2016-06-04 15:47:09',1,6)
 ,(134,12,'2016-06-04 15:47:10',1,6)
 ,(135,13,'2016-06-04 15:47:10',1,6)
 ,(136,12,'2016-06-04 15:47:10',1,6)
 ,(137,13,'2016-06-04 15:47:10',1,6);

DROP TABLE IF EXISTS BasicWorkflowPermissionAssignments;

CREATE TABLE IF NOT EXISTS `BasicWorkflowPermissionAssignments` (
  `wfID` int(10) unsigned NOT NULL DEFAULT '0',
  `pkID` int(10) unsigned NOT NULL DEFAULT '0',
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`wfID`,`pkID`,`paID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS BasicWorkflowProgressData;

CREATE TABLE IF NOT EXISTS `BasicWorkflowProgressData` (
  `wpID` int(10) unsigned NOT NULL DEFAULT '0',
  `uIDStarted` int(10) unsigned NOT NULL DEFAULT '0',
  `uIDCompleted` int(10) unsigned NOT NULL DEFAULT '0',
  `wpDateCompleted` datetime DEFAULT NULL,
  PRIMARY KEY (`wpID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS BlockPermissionAssignments;

CREATE TABLE IF NOT EXISTS `BlockPermissionAssignments` (
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `cvID` int(10) unsigned NOT NULL DEFAULT '0',
  `bID` int(10) unsigned NOT NULL DEFAULT '0',
  `pkID` int(10) unsigned NOT NULL DEFAULT '0',
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cID`,`cvID`,`bID`,`pkID`,`paID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS BlockRelations;

CREATE TABLE IF NOT EXISTS `BlockRelations` (
  `brID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bID` int(10) unsigned NOT NULL DEFAULT '0',
  `originalBID` int(10) unsigned NOT NULL DEFAULT '0',
  `relationType` varchar(50) NOT NULL,
  PRIMARY KEY (`brID`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO BlockRelations VALUES(1,16,15,'DUPLICATE')
 ,(2,33,32,'DUPLICATE')
 ,(3,61,60,'DUPLICATE');

DROP TABLE IF EXISTS BlockTypePermissionBlockTypeAccessList;

CREATE TABLE IF NOT EXISTS `BlockTypePermissionBlockTypeAccessList` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `permission` varchar(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`paID`,`peID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS BlockTypePermissionBlockTypeAccessListCustom;

CREATE TABLE IF NOT EXISTS `BlockTypePermissionBlockTypeAccessListCustom` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `btID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`paID`,`peID`,`btID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS BlockTypes;

CREATE TABLE IF NOT EXISTS `BlockTypes` (
  `btID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `btHandle` varchar(32) NOT NULL,
  `btName` varchar(128) NOT NULL,
  `btDescription` text,
  `btActiveWhenAdded` tinyint(1) NOT NULL DEFAULT '1',
  `btCopyWhenPropagate` tinyint(1) NOT NULL DEFAULT '0',
  `btIncludeAll` tinyint(1) NOT NULL DEFAULT '0',
  `btIsInternal` tinyint(1) NOT NULL DEFAULT '0',
  `btDisplayOrder` int(10) unsigned NOT NULL DEFAULT '0',
  `btInterfaceWidth` int(10) unsigned NOT NULL DEFAULT '400',
  `btInterfaceHeight` int(10) unsigned NOT NULL DEFAULT '400',
  `pkgID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`btID`),
  UNIQUE KEY `btHandle` (`btHandle`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8;

INSERT INTO BlockTypes VALUES(1,'core_scrapbook_display','Scrapbook Display (Core)','Proxy block for blocks pasted through the scrapbook.',1,0,0,1,0,400,400,0)
 ,(2,'core_stack_display','Stack Display (Core)','Proxy block for stacks added through the UI.',1,0,0,1,0,400,400,0)
 ,(3,'dashboard_featured_addon','Dashboard Featured Add-On','Features an add-on from concrete5.org.',1,0,0,1,0,300,100,0)
 ,(4,'dashboard_featured_theme','Dashboard Featured Theme','Features a theme from concrete5.org.',1,0,0,1,0,300,100,0)
 ,(5,'dashboard_newsflow_latest','Dashboard Newsflow Latest','Grabs the latest newsflow data from concrete5.org.',1,0,0,1,0,400,400,0)
 ,(6,'dashboard_app_status','Dashboard App Status','Displays update and welcome back information on your dashboard.',1,0,0,1,0,400,400,0)
 ,(7,'dashboard_site_activity','Dashboard Site Activity','Displays a summary of website activity.',1,0,0,1,0,400,400,0)
 ,(8,'autonav','Auto-Nav','Creates navigation trees and sitemaps.',1,0,0,0,1,500,350,0)
 ,(9,'content','Content','HTML/WYSIWYG Editor Content.',1,0,0,0,2,600,465,0)
 ,(10,'date_nav','Date Navigation','A collapsible date based navigation tree',1,0,0,0,3,500,350,0)
 ,(11,'external_form','External Form','Include external forms in the filesystem and place them on pages.',1,0,0,0,4,370,100,0)
 ,(12,'file','File','Link to files stored in the asset library.',1,0,0,0,5,300,250,0)
 ,(13,'flash_content','Flash Content','Embeds SWF files, including flash detection.',1,0,0,0,6,380,200,0)
 ,(14,'form','Form','Build simple forms and surveys.',1,0,0,0,7,420,430,0)
 ,(15,'google_map','Google Map','Enter an address and a Google Map of that location will be placed in your page.',1,0,0,0,8,750,460,0)
 ,(16,'guestbook','Guestbook / Comments','Adds blog-style comments (a guestbook) to your page.',1,0,1,0,9,370,480,0)
 ,(17,'html','HTML','For adding HTML by hand.',1,0,0,0,10,600,465,0)
 ,(18,'image','Image','Adds images and onstates from the library to pages.',1,0,0,0,12,400,550,0)
 ,(19,'next_previous','Next & Previous Nav','Navigate through sibling pages.',1,0,0,0,13,430,400,0)
 ,(20,'page_list','Page List','List pages based on type, area.',1,0,0,0,14,500,350,0)
 ,(21,'rss_displayer','RSS Displayer','Fetch, parse and display the contents of an RSS or Atom feed.',1,0,0,0,15,400,330,0)
 ,(22,'search','Search','Add a search box to your site.',1,0,0,0,16,400,240,0)
 ,(23,'slideshow','Slideshow','Display a running loop of images.',1,0,0,0,17,550,400,0)
 ,(24,'survey','Survey','Provide a simple survey, along with results in a pie chart format.',1,0,0,0,18,420,300,0)
 ,(25,'tags','Tags','List pages based on type, area.',1,0,0,0,19,450,260,0)
 ,(26,'video','Video Player','Embeds uploaded video into a web page. Supports AVI, WMV, Quicktime/MPEG4 and FLV formats.',1,0,0,0,20,320,220,0)
 ,(27,'youtube','YouTube Video','Embeds a YouTube Video in your web page.',1,0,0,0,21,400,210,0)
 ,(28,'flex_slider','Flexslider 2','Fully responsive slideshow',1,0,0,0,22,450,450,1)
 ,(29,'responsive_image','Responsive Image','Adds images and onstates from the library to pages.',1,0,0,0,11,400,550,0);

DROP TABLE IF EXISTS Blocks;

CREATE TABLE IF NOT EXISTS `Blocks` (
  `bID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bName` varchar(60) DEFAULT NULL,
  `bDateAdded` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `bDateModified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `bFilename` varchar(255) DEFAULT NULL,
  `bIsActive` varchar(1) NOT NULL DEFAULT '1',
  `btID` int(10) unsigned NOT NULL DEFAULT '0',
  `uID` int(10) unsigned DEFAULT NULL,
  `btCachedBlockRecord` longtext,
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB AUTO_INCREMENT=67 DEFAULT CHARSET=utf8;

INSERT INTO Blocks VALUES(1,'','2016-05-21 13:53:33','2016-05-21 13:53:33',NULL,'1',9,1,NULL)
 ,(2,'','2016-05-21 13:53:33','2016-05-21 13:53:33',NULL,'1',9,1,NULL)
 ,(3,'','2016-05-21 13:53:33','2016-05-21 13:53:34',NULL,'1',9,1,NULL)
 ,(4,'','2016-05-21 13:53:34','2016-05-21 13:53:34',NULL,'1',9,1,NULL)
 ,(5,'','2016-05-21 13:53:34','2016-05-21 13:53:34',NULL,'1',9,1,NULL)
 ,(6,'','2016-05-21 13:53:34','2016-05-21 13:53:34',NULL,'1',6,1,NULL)
 ,(7,'','2016-05-21 13:53:34','2016-05-21 13:53:34',NULL,'1',7,1,NULL)
 ,(8,'','2016-05-21 13:53:34','2016-05-21 13:53:34',NULL,'1',5,1,NULL)
 ,(9,'','2016-05-21 13:53:34','2016-05-21 13:53:34',NULL,'1',5,1,NULL)
 ,(10,'','2016-05-21 13:53:34','2016-05-21 13:53:34',NULL,'1',4,1,NULL)
 ,(11,'','2016-05-21 13:53:34','2016-05-21 13:53:34',NULL,'1',3,1,NULL)
 ,(12,'','2016-05-21 13:53:34','2016-05-21 13:53:34',NULL,'1',5,1,NULL)
 ,(13,NULL,'2016-05-30 14:00:17','2016-05-30 14:00:17',NULL,'1',28,1,NULL)
 ,(14,NULL,'2016-05-30 14:45:28','2016-05-30 14:45:28',NULL,'1',9,1,'O:11:\"BlockRecord\":11:{s:5:\"_dbat\";i:1;s:6:\"_table\";s:14:\"btContentLocal\";s:8:\"_tableat\";s:14:\"btContentLocal\";s:6:\"_where\";s:6:\"bID=14\";s:6:\"_saved\";b:1;s:8:\"_lasterr\";b:0;s:9:\"_original\";a:2:{i:0;s:2:\"14\";i:1;s:1282:\"<h1>Woodland Bed &amp; Breakfast with tea garden</h1>\r\n<p>Lowther House is set at the end of a tree lined drive in a clearing in Pickering Woods. It has a real country feel about it yet is just a ten minute walk down a tree-lined avenue into Pickering Town Centre.</p>\r\n<p>The house is bordered on two sides by Pickering Beck and is part of the Duchy of Lancaster Estate. The North York Moors Railway station is just five minutes away and the track runs past the garden. It’s a lovely sight to see when the steam trains go past – especially if you’re having cake and tea in the garden at the same time!!</p>\r\n<p>The house sits between the North York Moors National Park - which you can walk into from our gate - and the Yorkshire Wolds to the south, making it the perfect location for exploring some of the most spectacular scenery around. Excellent walks and cycle tracks are right outside our door,</p>\r\n<blockquote>“We moved into Lowther House in September 2015 after running a pub and bed and breakfast in the Yorkshire Dales. We knew the first time we saw Lowther House that we wanted to live here, the house are gardens are beautiful and have a real sense of calm about them. We hope you will enjoy the comfort, charm and warm welcome at Lowther House.”</blockquote>\";}s:11:\"foreignName\";s:11:\"blockrecord\";s:8:\"lockMode\";s:12:\" for update \";s:3:\"bID\";s:2:\"14\";s:7:\"content\";s:1282:\"<h1>Woodland Bed &amp; Breakfast with tea garden</h1>\r\n<p>Lowther House is set at the end of a tree lined drive in a clearing in Pickering Woods. It has a real country feel about it yet is just a ten minute walk down a tree-lined avenue into Pickering Town Centre.</p>\r\n<p>The house is bordered on two sides by Pickering Beck and is part of the Duchy of Lancaster Estate. The North York Moors Railway station is just five minutes away and the track runs past the garden. It’s a lovely sight to see when the steam trains go past – especially if you’re having cake and tea in the garden at the same time!!</p>\r\n<p>The house sits between the North York Moors National Park - which you can walk into from our gate - and the Yorkshire Wolds to the south, making it the perfect location for exploring some of the most spectacular scenery around. Excellent walks and cycle tracks are right outside our door,</p>\r\n<blockquote>“We moved into Lowther House in September 2015 after running a pub and bed and breakfast in the Yorkshire Dales. We knew the first time we saw Lowther House that we wanted to live here, the house are gardens are beautiful and have a real sense of calm about them. We hope you will enjoy the comfort, charm and warm welcome at Lowther House.”</blockquote>\";}')
 ,(15,NULL,'2016-05-30 17:15:28','2016-05-30 17:15:28',NULL,'1',9,1,NULL)
 ,(16,NULL,'2016-05-30 17:18:06','2016-05-30 17:18:06',NULL,'1',9,1,'O:11:\"BlockRecord\":11:{s:5:\"_dbat\";i:1;s:6:\"_table\";s:14:\"btContentLocal\";s:8:\"_tableat\";s:14:\"btContentLocal\";s:6:\"_where\";s:6:\"bID=16\";s:6:\"_saved\";b:1;s:8:\"_lasterr\";b:0;s:9:\"_original\";a:2:{i:0;s:2:\"16\";i:1;s:252:\"<h1>Latest News &amp; Info</h1>\r\n<h4>Winter warmer<br />bed &amp; breakfast<br />special offer</h4>\r\n<p>Available Nov - Feb inclusive.</p>\r\n<p>Book one night and get (consecutive) night free.</p>\r\n<p>Subject to availabliity<br />Room price is £80.</p>\";}s:11:\"foreignName\";s:11:\"blockrecord\";s:8:\"lockMode\";s:12:\" for update \";s:3:\"bID\";s:2:\"16\";s:7:\"content\";s:252:\"<h1>Latest News &amp; Info</h1>\r\n<h4>Winter warmer<br />bed &amp; breakfast<br />special offer</h4>\r\n<p>Available Nov - Feb inclusive.</p>\r\n<p>Book one night and get (consecutive) night free.</p>\r\n<p>Subject to availabliity<br />Room price is £80.</p>\";}')
 ,(17,NULL,'2016-05-30 17:43:17','2016-05-30 17:43:17',NULL,'1',28,1,NULL)
 ,(18,NULL,'2016-05-30 17:44:49','2016-05-30 17:44:49',NULL,'1',9,1,NULL)
 ,(19,NULL,'2016-05-30 17:45:30','2016-05-30 17:45:30',NULL,'1',9,1,NULL)
 ,(20,NULL,'2016-05-30 17:48:08','2016-05-30 17:48:08',NULL,'1',28,1,NULL)
 ,(21,NULL,'2016-05-30 17:48:36','2016-05-30 17:48:47',NULL,'1',9,1,'O:11:\"BlockRecord\":11:{s:5:\"_dbat\";i:1;s:6:\"_table\";s:14:\"btContentLocal\";s:8:\"_tableat\";s:14:\"btContentLocal\";s:6:\"_where\";s:6:\"bID=21\";s:6:\"_saved\";b:1;s:8:\"_lasterr\";b:0;s:9:\"_original\";a:2:{i:0;s:2:\"21\";i:1;s:29:\"<h1>Booking Enquiry Form</h1>\";}s:11:\"foreignName\";s:11:\"blockrecord\";s:8:\"lockMode\";s:12:\" for update \";s:3:\"bID\";s:2:\"21\";s:7:\"content\";s:29:\"<h1>Booking Enquiry Form</h1>\";}')
 ,(22,NULL,'2016-05-30 17:59:32','2016-05-30 17:59:32',NULL,'1',9,1,'O:11:\"BlockRecord\":11:{s:5:\"_dbat\";i:1;s:6:\"_table\";s:14:\"btContentLocal\";s:8:\"_tableat\";s:14:\"btContentLocal\";s:6:\"_where\";s:6:\"bID=22\";s:6:\"_saved\";b:1;s:8:\"_lasterr\";b:0;s:9:\"_original\";a:2:{i:0;s:2:\"22\";i:1;s:718:\"<h1>Bedrooms at Lowther House</h1>\r\n<p>We have two first floor rooms - so we can offer excellent service. Fresh flowers greet you, in hospitality corner there is a silent running fridge for your use for beverages, wine etc. - just ask for ice and glasses. Also, there are a selection of Twinings teas and Fresh Rombouts Coffees - yours for the making, plus biscuits to nibble, an insulated carafe of chilled filtered water is also provided. A radio-controlled alarm clock with a very useful weather feature is by the bed.</p>\r\n<p>There is a Freesat TV with DVD player a selection of DVD\'s/CD\'s is available on the landing. In the closet you\'ll find shower robes, hair dryer, shaver adaptor, fan, extra bedding etc.</p>\";}s:11:\"foreignName\";s:11:\"blockrecord\";s:8:\"lockMode\";s:12:\" for update \";s:3:\"bID\";s:2:\"22\";s:7:\"content\";s:718:\"<h1>Bedrooms at Lowther House</h1>\r\n<p>We have two first floor rooms - so we can offer excellent service. Fresh flowers greet you, in hospitality corner there is a silent running fridge for your use for beverages, wine etc. - just ask for ice and glasses. Also, there are a selection of Twinings teas and Fresh Rombouts Coffees - yours for the making, plus biscuits to nibble, an insulated carafe of chilled filtered water is also provided. A radio-controlled alarm clock with a very useful weather feature is by the bed.</p>\r\n<p>There is a Freesat TV with DVD player a selection of DVD\'s/CD\'s is available on the landing. In the closet you\'ll find shower robes, hair dryer, shaver adaptor, fan, extra bedding etc.</p>\";}')
 ,(23,NULL,'2016-05-30 18:01:27','2016-05-30 18:01:27',NULL,'1',9,1,'O:11:\"BlockRecord\":11:{s:5:\"_dbat\";i:1;s:6:\"_table\";s:14:\"btContentLocal\";s:8:\"_tableat\";s:14:\"btContentLocal\";s:6:\"_where\";s:6:\"bID=23\";s:6:\"_saved\";b:1;s:8:\"_lasterr\";b:0;s:9:\"_original\";a:2:{i:0;s:2:\"23\";i:1;s:18:\"<h1>Beck Room</h1>\";}s:11:\"foreignName\";s:11:\"blockrecord\";s:8:\"lockMode\";s:12:\" for update \";s:3:\"bID\";s:2:\"23\";s:7:\"content\";s:18:\"<h1>Beck Room</h1>\";}')
 ,(24,NULL,'2016-05-30 18:01:50','2016-05-30 18:01:58',NULL,'1',9,1,'O:11:\"BlockRecord\":11:{s:5:\"_dbat\";i:1;s:6:\"_table\";s:14:\"btContentLocal\";s:8:\"_tableat\";s:14:\"btContentLocal\";s:6:\"_where\";s:6:\"bID=24\";s:6:\"_saved\";b:1;s:8:\"_lasterr\";b:0;s:9:\"_original\";a:2:{i:0;s:2:\"24\";i:1;s:21:\"<h1>Orchard Room</h1>\";}s:11:\"foreignName\";s:11:\"blockrecord\";s:8:\"lockMode\";s:12:\" for update \";s:3:\"bID\";s:2:\"24\";s:7:\"content\";s:21:\"<h1>Orchard Room</h1>\";}')
 ,(25,NULL,'2016-05-30 18:02:14','2016-05-30 18:02:14',NULL,'1',9,1,'O:11:\"BlockRecord\":11:{s:5:\"_dbat\";i:1;s:6:\"_table\";s:14:\"btContentLocal\";s:8:\"_tableat\";s:14:\"btContentLocal\";s:6:\"_where\";s:6:\"bID=25\";s:6:\"_saved\";b:1;s:8:\"_lasterr\";b:0;s:9:\"_original\";a:2:{i:0;s:2:\"25\";i:1;s:20:\"<h1>Garden Room</h1>\";}s:11:\"foreignName\";s:11:\"blockrecord\";s:8:\"lockMode\";s:12:\" for update \";s:3:\"bID\";s:2:\"25\";s:7:\"content\";s:20:\"<h1>Garden Room</h1>\";}')
 ,(26,NULL,'2016-05-30 18:28:25','2016-05-30 18:28:25',NULL,'1',29,1,'O:11:\"BlockRecord\":18:{s:5:\"_dbat\";i:1;s:6:\"_table\";s:24:\"btContentResponsiveImage\";s:8:\"_tableat\";s:24:\"btContentResponsiveImage\";s:6:\"_where\";s:6:\"bID=26\";s:6:\"_saved\";b:1;s:8:\"_lasterr\";b:0;s:9:\"_original\";a:9:{i:0;s:2:\"26\";i:1;s:1:\"3\";i:2;s:1:\"0\";i:3;s:1:\"0\";i:4;s:1:\"0\";i:5;s:0:\"\";i:6;s:1:\"0\";i:7;s:1:\"1\";i:8;s:0:\"\";}s:11:\"foreignName\";s:11:\"blockrecord\";s:8:\"lockMode\";s:12:\" for update \";s:3:\"bID\";s:2:\"26\";s:3:\"fID\";s:1:\"3\";s:10:\"fOnstateID\";s:1:\"0\";s:8:\"maxWidth\";s:1:\"0\";s:9:\"maxHeight\";s:1:\"0\";s:12:\"externalLink\";s:0:\"\";s:15:\"internalLinkCID\";s:1:\"0\";s:27:\"forceImageToMatchDimensions\";s:1:\"1\";s:7:\"altText\";s:0:\"\";}')
 ,(27,NULL,'2016-05-30 18:28:35','2016-05-30 18:28:35',NULL,'1',29,1,'O:11:\"BlockRecord\":18:{s:5:\"_dbat\";i:1;s:6:\"_table\";s:24:\"btContentResponsiveImage\";s:8:\"_tableat\";s:24:\"btContentResponsiveImage\";s:6:\"_where\";s:6:\"bID=27\";s:6:\"_saved\";b:1;s:8:\"_lasterr\";b:0;s:9:\"_original\";a:9:{i:0;s:2:\"27\";i:1;s:1:\"3\";i:2;s:1:\"0\";i:3;s:1:\"0\";i:4;s:1:\"0\";i:5;s:0:\"\";i:6;s:1:\"0\";i:7;s:1:\"1\";i:8;s:0:\"\";}s:11:\"foreignName\";s:11:\"blockrecord\";s:8:\"lockMode\";s:12:\" for update \";s:3:\"bID\";s:2:\"27\";s:3:\"fID\";s:1:\"3\";s:10:\"fOnstateID\";s:1:\"0\";s:8:\"maxWidth\";s:1:\"0\";s:9:\"maxHeight\";s:1:\"0\";s:12:\"externalLink\";s:0:\"\";s:15:\"internalLinkCID\";s:1:\"0\";s:27:\"forceImageToMatchDimensions\";s:1:\"1\";s:7:\"altText\";s:0:\"\";}')
 ,(28,NULL,'2016-05-30 18:28:45','2016-05-30 18:28:45',NULL,'1',29,1,'O:11:\"BlockRecord\":18:{s:5:\"_dbat\";i:1;s:6:\"_table\";s:24:\"btContentResponsiveImage\";s:8:\"_tableat\";s:24:\"btContentResponsiveImage\";s:6:\"_where\";s:6:\"bID=28\";s:6:\"_saved\";b:1;s:8:\"_lasterr\";b:0;s:9:\"_original\";a:9:{i:0;s:2:\"28\";i:1;s:1:\"3\";i:2;s:1:\"0\";i:3;s:1:\"0\";i:4;s:1:\"0\";i:5;s:0:\"\";i:6;s:1:\"0\";i:7;s:1:\"1\";i:8;s:0:\"\";}s:11:\"foreignName\";s:11:\"blockrecord\";s:8:\"lockMode\";s:12:\" for update \";s:3:\"bID\";s:2:\"28\";s:3:\"fID\";s:1:\"3\";s:10:\"fOnstateID\";s:1:\"0\";s:8:\"maxWidth\";s:1:\"0\";s:9:\"maxHeight\";s:1:\"0\";s:12:\"externalLink\";s:0:\"\";s:15:\"internalLinkCID\";s:1:\"0\";s:27:\"forceImageToMatchDimensions\";s:1:\"1\";s:7:\"altText\";s:0:\"\";}')
 ,(29,NULL,'2016-05-30 18:29:28','2016-05-30 18:29:28',NULL,'1',9,1,'O:11:\"BlockRecord\":11:{s:5:\"_dbat\";i:1;s:6:\"_table\";s:14:\"btContentLocal\";s:8:\"_tableat\";s:14:\"btContentLocal\";s:6:\"_where\";s:6:\"bID=29\";s:6:\"_saved\";b:1;s:8:\"_lasterr\";b:0;s:9:\"_original\";a:2:{i:0;s:2:\"29\";i:1;s:597:\"<p>BECK ROOM Available as a twin-bedded room. Double aspect, with lovely views of the Beck and the garden across to the Butts river meadow. With the added fun of watching the steam trains of the North York\'s Moors Railway as they chug up the dale to Whitby!</p>\r\n<p>Drift off to sleep with the sounds of the beck trickling by your window, interrupted only by the hoots of owls on their night-time hunting trips.</p>\r\n<p>For a romantic treat we are happy to serve breakfast in the room - just let us know ahead of time! The private wet-room with key access for exclusive use is across the hall</p>\";}s:11:\"foreignName\";s:11:\"blockrecord\";s:8:\"lockMode\";s:12:\" for update \";s:3:\"bID\";s:2:\"29\";s:7:\"content\";s:597:\"<p>BECK ROOM Available as a twin-bedded room. Double aspect, with lovely views of the Beck and the garden across to the Butts river meadow. With the added fun of watching the steam trains of the North York\'s Moors Railway as they chug up the dale to Whitby!</p>\r\n<p>Drift off to sleep with the sounds of the beck trickling by your window, interrupted only by the hoots of owls on their night-time hunting trips.</p>\r\n<p>For a romantic treat we are happy to serve breakfast in the room - just let us know ahead of time! The private wet-room with key access for exclusive use is across the hall</p>\";}')
 ,(30,NULL,'2016-05-30 18:29:55','2016-05-30 18:29:55',NULL,'1',9,1,'O:11:\"BlockRecord\":11:{s:5:\"_dbat\";i:1;s:6:\"_table\";s:14:\"btContentLocal\";s:8:\"_tableat\";s:14:\"btContentLocal\";s:6:\"_where\";s:6:\"bID=30\";s:6:\"_saved\";b:1;s:8:\"_lasterr\";b:0;s:9:\"_original\";a:2:{i:0;s:2:\"30\";i:1;s:468:\"<p>ORCHARD ROOM A king-size bed (5\') with en-suite wet-room. Wake to gorgeous views over the garden orchard and Pickering Woods, maybe you\'ll see a deer or two as well!</p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam sodales vehicula risus, et facilisis massa lacinia eget. Pellentesque auctor bibendum urna sed tempus. Pellentesque elementum, tellus quis tristique maximus, eros arcu malesuada augue, nec consectetur purus sem quis velit.</p>\";}s:11:\"foreignName\";s:11:\"blockrecord\";s:8:\"lockMode\";s:12:\" for update \";s:3:\"bID\";s:2:\"30\";s:7:\"content\";s:468:\"<p>ORCHARD ROOM A king-size bed (5\') with en-suite wet-room. Wake to gorgeous views over the garden orchard and Pickering Woods, maybe you\'ll see a deer or two as well!</p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam sodales vehicula risus, et facilisis massa lacinia eget. Pellentesque auctor bibendum urna sed tempus. Pellentesque elementum, tellus quis tristique maximus, eros arcu malesuada augue, nec consectetur purus sem quis velit.</p>\";}')
 ,(31,NULL,'2016-05-30 18:30:21','2016-05-30 18:30:21',NULL,'1',9,1,'O:11:\"BlockRecord\":11:{s:5:\"_dbat\";i:1;s:6:\"_table\";s:14:\"btContentLocal\";s:8:\"_tableat\";s:14:\"btContentLocal\";s:6:\"_where\";s:6:\"bID=31\";s:6:\"_saved\";b:1;s:8:\"_lasterr\";b:0;s:9:\"_original\";a:2:{i:0;s:2:\"31\";i:1;s:583:\"<p>GARDEN ROOM Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam sodales vehicula risus, et facilisis massa lacinia eget. Pellentesque auctor bibendum urna sed tempus. Pellentesque elementum, tellus quis tristique maximus, eros arcu malesuada augue, nec consectetur purus sem quis velit.</p>\r\n<p>Curabitur molestie nisl nisl, a eleifend tortor congue ut. Morbi eleifend sapien vel felis consequat, tincidunt convallis eros malesuada. Sed mollis aliquet nisi, lobortis aliquam nibh tristique vel. Nulla accumsan ipsum felis. Nunc eget diam nunc. Pvarius magna eget.</p>\";}s:11:\"foreignName\";s:11:\"blockrecord\";s:8:\"lockMode\";s:12:\" for update \";s:3:\"bID\";s:2:\"31\";s:7:\"content\";s:583:\"<p>GARDEN ROOM Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam sodales vehicula risus, et facilisis massa lacinia eget. Pellentesque auctor bibendum urna sed tempus. Pellentesque elementum, tellus quis tristique maximus, eros arcu malesuada augue, nec consectetur purus sem quis velit.</p>\r\n<p>Curabitur molestie nisl nisl, a eleifend tortor congue ut. Morbi eleifend sapien vel felis consequat, tincidunt convallis eros malesuada. Sed mollis aliquet nisi, lobortis aliquam nibh tristique vel. Nulla accumsan ipsum felis. Nunc eget diam nunc. Pvarius magna eget.</p>\";}')
 ,(32,NULL,'2016-06-01 22:18:39','2016-06-01 22:18:39',NULL,'1',9,1,NULL)
 ,(33,NULL,'2016-06-01 22:19:40','2016-06-01 22:19:40',NULL,'1',9,1,'O:11:\"BlockRecord\":11:{s:5:\"_dbat\";i:1;s:6:\"_table\";s:14:\"btContentLocal\";s:8:\"_tableat\";s:14:\"btContentLocal\";s:6:\"_where\";s:6:\"bID=33\";s:6:\"_saved\";b:1;s:8:\"_lasterr\";b:0;s:9:\"_original\";a:2:{i:0;s:2:\"33\";i:1;s:587:\"<h1>Bed &amp; Breakfast tariff for 2016</h1>\r\n<p>Lowther House Tariff below is for direct bookings only</p>\r\n<table>\r\n<tbody>\r\n<tr><th>Rooms</th><th>1 Night</th><th>2-4 Nights</th><th>5+ Nights</th></tr>\r\n<tr>\r\n<td><strong>Orchard</strong><br />En-suite, King</td>\r\n<td>£75</td>\r\n<td>£70</td>\r\n<td>£65</td>\r\n</tr>\r\n<tr>\r\n<td><strong>Beckside</strong><br />Separate Bathroom Twin or Super King</td>\r\n<td>£70</td>\r\n<td>£65</td>\r\n<td>£60</td>\r\n</tr>\r\n<tr>\r\n<td><strong>Garden</strong><br />Separate Bathroom</td>\r\n<td>£70</td>\r\n<td>£65</td>\r\n<td>£60</td>\r\n</tr>\r\n</tbody>\r\n</table>\";}s:11:\"foreignName\";s:11:\"blockrecord\";s:8:\"lockMode\";s:12:\" for update \";s:3:\"bID\";s:2:\"33\";s:7:\"content\";s:587:\"<h1>Bed &amp; Breakfast tariff for 2016</h1>\r\n<p>Lowther House Tariff below is for direct bookings only</p>\r\n<table>\r\n<tbody>\r\n<tr><th>Rooms</th><th>1 Night</th><th>2-4 Nights</th><th>5+ Nights</th></tr>\r\n<tr>\r\n<td><strong>Orchard</strong><br />En-suite, King</td>\r\n<td>£75</td>\r\n<td>£70</td>\r\n<td>£65</td>\r\n</tr>\r\n<tr>\r\n<td><strong>Beckside</strong><br />Separate Bathroom Twin or Super King</td>\r\n<td>£70</td>\r\n<td>£65</td>\r\n<td>£60</td>\r\n</tr>\r\n<tr>\r\n<td><strong>Garden</strong><br />Separate Bathroom</td>\r\n<td>£70</td>\r\n<td>£65</td>\r\n<td>£60</td>\r\n</tr>\r\n</tbody>\r\n</table>\";}')
 ,(34,NULL,'2016-06-02 21:36:43','2016-06-02 21:36:43',NULL,'1',9,1,'O:11:\"BlockRecord\":11:{s:5:\"_dbat\";i:1;s:6:\"_table\";s:14:\"btContentLocal\";s:8:\"_tableat\";s:14:\"btContentLocal\";s:6:\"_where\";s:6:\"bID=34\";s:6:\"_saved\";b:1;s:8:\"_lasterr\";b:0;s:9:\"_original\";a:2:{i:0;s:2:\"34\";i:1;s:318:\"<blockquote>“Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam sodales vehicula risus, et facilisis massa lacinia eget. Pellentesque auctor bibendum urna sed tempus. Pellentesque elementum, tellus quis tristique maximus, eros arcu malesuada augue, nec consectetur purus sem quis velit.”</blockquote>\";}s:11:\"foreignName\";s:11:\"blockrecord\";s:8:\"lockMode\";s:12:\" for update \";s:3:\"bID\";s:2:\"34\";s:7:\"content\";s:318:\"<blockquote>“Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam sodales vehicula risus, et facilisis massa lacinia eget. Pellentesque auctor bibendum urna sed tempus. Pellentesque elementum, tellus quis tristique maximus, eros arcu malesuada augue, nec consectetur purus sem quis velit.”</blockquote>\";}')
 ,(35,NULL,'2016-06-02 21:37:35','2016-06-02 21:37:51',NULL,'1',9,1,'O:11:\"BlockRecord\":11:{s:5:\"_dbat\";i:1;s:6:\"_table\";s:14:\"btContentLocal\";s:8:\"_tableat\";s:14:\"btContentLocal\";s:6:\"_where\";s:6:\"bID=35\";s:6:\"_saved\";b:1;s:8:\"_lasterr\";b:0;s:9:\"_original\";a:2:{i:0;s:2:\"35\";i:1;s:216:\"<blockquote>Eu epicurei suscipiantur mea. Ius eu wisi suscipit, pri tollit vocibus id. Percipit tacimates id eum. Vel et alia nominavi laboramus, vel ex tritani prodesset, ut duo modo volutpat aliquando.</blockquote>\";}s:11:\"foreignName\";s:11:\"blockrecord\";s:8:\"lockMode\";s:12:\" for update \";s:3:\"bID\";s:2:\"35\";s:7:\"content\";s:216:\"<blockquote>Eu epicurei suscipiantur mea. Ius eu wisi suscipit, pri tollit vocibus id. Percipit tacimates id eum. Vel et alia nominavi laboramus, vel ex tritani prodesset, ut duo modo volutpat aliquando.</blockquote>\";}')
 ,(36,NULL,'2016-06-02 21:38:28','2016-06-02 21:38:28',NULL,'1',9,1,'O:11:\"BlockRecord\":11:{s:5:\"_dbat\";i:1;s:6:\"_table\";s:14:\"btContentLocal\";s:8:\"_tableat\";s:14:\"btContentLocal\";s:6:\"_where\";s:6:\"bID=36\";s:6:\"_saved\";b:1;s:8:\"_lasterr\";b:0;s:9:\"_original\";a:2:{i:0;s:2:\"36\";i:1;s:309:\"<blockquote>Mutat essent ut sea, est solum mucius te. Qui veniam consetetur definiebas an. Dicam intellegam definitiones vis ut, perfecto tincidunt incorrupte sit ex. Vis graece virtute inimicus no, nec ad efficiendi definitionem, at aeque abhorreant omittantur mei. Persius signiferumque eum ne.</blockquote>\";}s:11:\"foreignName\";s:11:\"blockrecord\";s:8:\"lockMode\";s:12:\" for update \";s:3:\"bID\";s:2:\"36\";s:7:\"content\";s:309:\"<blockquote>Mutat essent ut sea, est solum mucius te. Qui veniam consetetur definiebas an. Dicam intellegam definitiones vis ut, perfecto tincidunt incorrupte sit ex. Vis graece virtute inimicus no, nec ad efficiendi definitionem, at aeque abhorreant omittantur mei. Persius signiferumque eum ne.</blockquote>\";}')
 ,(37,NULL,'2016-06-02 21:58:41','2016-06-02 21:58:41',NULL,'1',9,1,'O:11:\"BlockRecord\":11:{s:5:\"_dbat\";i:1;s:6:\"_table\";s:14:\"btContentLocal\";s:8:\"_tableat\";s:14:\"btContentLocal\";s:6:\"_where\";s:6:\"bID=37\";s:6:\"_saved\";b:1;s:8:\"_lasterr\";b:0;s:9:\"_original\";a:2:{i:0;s:2:\"37\";i:1;s:669:\"<h1>Booking Information</h1>\r\n<p>Single occupancy rates are £10.00 less per room.</p>\r\n<p>Prices are inclusive of breakfast.</p>\r\n<p>We accept well behaved dogs at a one off charge of £10 per dog.</p>\r\n<p>Bookings through third parties may be charged at a higher tariff</p>\r\n<p>We accept most British and International Debit, Credit and Commercial Cards, for deposits and payments, except Diners and Amex. If you need further information please give us a call on 01751 477 568 or email <a href=\"mailto:info@lowtherhouse.co.uk\">info@lowtherhouse.co.uk</a></p>\r\n<h6>DOWNLOADS</h6>\r\n<p>Booking Terms &amp; Conditions <br />Accesibility Statement <br />B&amp;B Tariff</p>\";}s:11:\"foreignName\";s:11:\"blockrecord\";s:8:\"lockMode\";s:12:\" for update \";s:3:\"bID\";s:2:\"37\";s:7:\"content\";s:669:\"<h1>Booking Information</h1>\r\n<p>Single occupancy rates are £10.00 less per room.</p>\r\n<p>Prices are inclusive of breakfast.</p>\r\n<p>We accept well behaved dogs at a one off charge of £10 per dog.</p>\r\n<p>Bookings through third parties may be charged at a higher tariff</p>\r\n<p>We accept most British and International Debit, Credit and Commercial Cards, for deposits and payments, except Diners and Amex. If you need further information please give us a call on 01751 477 568 or email <a href=\"mailto:info@lowtherhouse.co.uk\">info@lowtherhouse.co.uk</a></p>\r\n<h6>DOWNLOADS</h6>\r\n<p>Booking Terms &amp; Conditions <br />Accesibility Statement <br />B&amp;B Tariff</p>\";}')
 ,(38,NULL,'2016-06-04 15:13:29','2016-06-04 15:13:29',NULL,'1',28,1,NULL)
 ,(39,NULL,'2016-06-04 15:14:00','2016-06-04 15:14:00',NULL,'1',9,1,'O:11:\"BlockRecord\":11:{s:5:\"_dbat\";i:1;s:6:\"_table\";s:14:\"btContentLocal\";s:8:\"_tableat\";s:14:\"btContentLocal\";s:6:\"_where\";N;s:6:\"_saved\";b:1;s:8:\"_lasterr\";b:0;s:9:\"_original\";a:2:{i:0;s:2:\"39\";i:1;s:454:\"<h1>Eating With Us</h1>\r\n<p>Lorem ipsum dolor sit amet, quo doctus ponderum eu. Ad doming molestiae conclusionemque cum. Assum mandamus ne eum, at nulla oratio his. Eam dolore vivendum ad. An impetus appareat tincidunt has, id sed option liberavisse.</p>\r\n<p>Eu epicurei suscipiantur mea. Ius eu wisi suscipit, pri tollit vocibus id. Percipit tacimates id eum. Vel et alia nominavi laboramus, vel ex tritani prodesset, ut duo modo volutpat aliquando.</p>\";}s:11:\"foreignName\";s:11:\"blockrecord\";s:8:\"lockMode\";s:12:\" for update \";s:3:\"bID\";s:2:\"39\";s:7:\"content\";s:454:\"<h1>Eating With Us</h1>\r\n<p>Lorem ipsum dolor sit amet, quo doctus ponderum eu. Ad doming molestiae conclusionemque cum. Assum mandamus ne eum, at nulla oratio his. Eam dolore vivendum ad. An impetus appareat tincidunt has, id sed option liberavisse.</p>\r\n<p>Eu epicurei suscipiantur mea. Ius eu wisi suscipit, pri tollit vocibus id. Percipit tacimates id eum. Vel et alia nominavi laboramus, vel ex tritani prodesset, ut duo modo volutpat aliquando.</p>\";}')
 ,(40,NULL,'2016-06-04 15:14:51','2016-06-04 15:14:51',NULL,'1',9,1,'O:11:\"BlockRecord\":11:{s:5:\"_dbat\";i:1;s:6:\"_table\";s:14:\"btContentLocal\";s:8:\"_tableat\";s:14:\"btContentLocal\";s:6:\"_where\";N;s:6:\"_saved\";b:1;s:8:\"_lasterr\";b:0;s:9:\"_original\";a:2:{i:0;s:2:\"40\";i:1;s:335:\"<h1>Meals</h1>\r\n<p>We pride ourselves on the freshness and quality of our food, all our fresh food is purchased from local butchers, bakers, greengrocers, fishmongers and grocery stores ensuring we know when and where it grew or was made. Meals can be served in the dining room or terrace, weather permitting.</p>\r\n<h6>SAMPLE MENU</h6>\";}s:11:\"foreignName\";s:11:\"blockrecord\";s:8:\"lockMode\";s:12:\" for update \";s:3:\"bID\";s:2:\"40\";s:7:\"content\";s:335:\"<h1>Meals</h1>\r\n<p>We pride ourselves on the freshness and quality of our food, all our fresh food is purchased from local butchers, bakers, greengrocers, fishmongers and grocery stores ensuring we know when and where it grew or was made. Meals can be served in the dining room or terrace, weather permitting.</p>\r\n<h6>SAMPLE MENU</h6>\";}')
 ,(41,NULL,'2016-06-04 15:16:40','2016-06-04 15:16:40',NULL,'1',9,1,'O:11:\"BlockRecord\":11:{s:5:\"_dbat\";i:1;s:6:\"_table\";s:14:\"btContentLocal\";s:8:\"_tableat\";s:14:\"btContentLocal\";s:6:\"_where\";N;s:6:\"_saved\";b:1;s:8:\"_lasterr\";b:0;s:9:\"_original\";a:2:{i:0;s:2:\"41\";i:1;s:606:\"<h1>Breakfast</h1>\r\n<h6>SAMPLE MENU</h6>\r\n<p>100% pure fresh fruit juice</p>\r\n<p>Choice of Teas and Cafetiere coffee, or our luxury Hot Frothy Chocolate</p>\r\n<p>Choice of Cereals and Porridge</p>\r\n<p>Traditional English ­ grilled not fried</p>\r\n<p>A choice of: Bacon, Sausages, Baked Beans, Yorkshire Black Pudding (yes there are other varieties!), Mushrooms, Hash Browns, Tomatoes, Eggs cooked a variety of ways.</p>\r\n<h6>CONTINENTAL</h6>\r\n<p>A variety of meats and cheeses, fresh fruit, yoghurt, croissants, etc.</p>\r\n<p>Granary or White Toast with local Jams, Jellies and Marmalade ­ even Marmite!</p>\";}s:11:\"foreignName\";s:11:\"blockrecord\";s:8:\"lockMode\";s:12:\" for update \";s:3:\"bID\";s:2:\"41\";s:7:\"content\";s:606:\"<h1>Breakfast</h1>\r\n<h6>SAMPLE MENU</h6>\r\n<p>100% pure fresh fruit juice</p>\r\n<p>Choice of Teas and Cafetiere coffee, or our luxury Hot Frothy Chocolate</p>\r\n<p>Choice of Cereals and Porridge</p>\r\n<p>Traditional English ­ grilled not fried</p>\r\n<p>A choice of: Bacon, Sausages, Baked Beans, Yorkshire Black Pudding (yes there are other varieties!), Mushrooms, Hash Browns, Tomatoes, Eggs cooked a variety of ways.</p>\r\n<h6>CONTINENTAL</h6>\r\n<p>A variety of meats and cheeses, fresh fruit, yoghurt, croissants, etc.</p>\r\n<p>Granary or White Toast with local Jams, Jellies and Marmalade ­ even Marmite!</p>\";}')
 ,(42,NULL,'2016-06-04 15:23:27','2016-06-04 15:23:27',NULL,'1',9,1,'O:11:\"BlockRecord\":11:{s:5:\"_dbat\";i:1;s:6:\"_table\";s:14:\"btContentLocal\";s:8:\"_tableat\";s:14:\"btContentLocal\";s:6:\"_where\";N;s:6:\"_saved\";b:1;s:8:\"_lasterr\";b:0;s:9:\"_original\";a:2:{i:0;s:2:\"42\";i:1;s:451:\"<h1>Events Info</h1>\r\n<p>Lorem ipsum dolor sit amet, quo doctus ponderum eu. Ad doming molestiae conclusionemque cum. Assum mandamus ne eum, at nulla oratio his. Eam dolore vivendum ad. An impetus appareat tincidunt has, id sed option liberavisse.</p>\r\n<p>Eu epicurei suscipiantur mea. Ius eu wisi suscipit, pri tollit vocibus id. Percipit tacimates id eum. Vel et alia nominavi laboramus, vel ex tritani prodesset, ut duo modo volutpat aliquando.</p>\";}s:11:\"foreignName\";s:11:\"blockrecord\";s:8:\"lockMode\";s:12:\" for update \";s:3:\"bID\";s:2:\"42\";s:7:\"content\";s:451:\"<h1>Events Info</h1>\r\n<p>Lorem ipsum dolor sit amet, quo doctus ponderum eu. Ad doming molestiae conclusionemque cum. Assum mandamus ne eum, at nulla oratio his. Eam dolore vivendum ad. An impetus appareat tincidunt has, id sed option liberavisse.</p>\r\n<p>Eu epicurei suscipiantur mea. Ius eu wisi suscipit, pri tollit vocibus id. Percipit tacimates id eum. Vel et alia nominavi laboramus, vel ex tritani prodesset, ut duo modo volutpat aliquando.</p>\";}')
 ,(43,NULL,'2016-06-04 15:23:38','2016-06-04 15:23:38',NULL,'1',28,1,NULL)
 ,(44,NULL,'2016-06-04 15:25:23','2016-06-04 15:25:23',NULL,'1',9,1,'O:11:\"BlockRecord\":11:{s:5:\"_dbat\";i:1;s:6:\"_table\";s:14:\"btContentLocal\";s:8:\"_tableat\";s:14:\"btContentLocal\";s:6:\"_where\";N;s:6:\"_saved\";b:1;s:8:\"_lasterr\";b:0;s:9:\"_original\";a:2:{i:0;s:2:\"44\";i:1;s:770:\"<h1>Local Events</h1>\r\n<p>Flying Scotsman visits NYMR - 12th, 13th, 15th, 16th, 17th, 19th, and 20th March</p>\r\n<p>NYMR Summer services begin Mon 21st March</p>\r\n<p>Tour de Yorkshire (Stage 3) Sunday 1st May</p>\r\n<p>NYMR Steam Gala 6th - 8th and 13th - 15th May, visiting engines LNWR 58926 and Standard 80072</p>\r\n<p>Malton Food Festival 28th - 29th May</p>\r\n<p>70\'s Weekend at NMR 17th - 19th June</p>\r\n<p>Forest Live - Dalby Forest music festival 23rd - 25th June</p>\r\n<p>60\'s Weekend at NYMR 2nd - 3rd July</p>\r\n<p>Classic Car and Vehicle Rally 9th - 10th July</p>\r\n<p>4th Rydale Jazz Festival 24th - 30th July</p>\r\n<p>Pickering Traction Rall 5th, 6th and 7th August</p>\r\n<p>Autumn Steam gala 30th Sept - 2nd Oct</p>\r\n<p>Pickering War Weekend 14th - 16th October</p>\";}s:11:\"foreignName\";s:11:\"blockrecord\";s:8:\"lockMode\";s:12:\" for update \";s:3:\"bID\";s:2:\"44\";s:7:\"content\";s:770:\"<h1>Local Events</h1>\r\n<p>Flying Scotsman visits NYMR - 12th, 13th, 15th, 16th, 17th, 19th, and 20th March</p>\r\n<p>NYMR Summer services begin Mon 21st March</p>\r\n<p>Tour de Yorkshire (Stage 3) Sunday 1st May</p>\r\n<p>NYMR Steam Gala 6th - 8th and 13th - 15th May, visiting engines LNWR 58926 and Standard 80072</p>\r\n<p>Malton Food Festival 28th - 29th May</p>\r\n<p>70\'s Weekend at NMR 17th - 19th June</p>\r\n<p>Forest Live - Dalby Forest music festival 23rd - 25th June</p>\r\n<p>60\'s Weekend at NYMR 2nd - 3rd July</p>\r\n<p>Classic Car and Vehicle Rally 9th - 10th July</p>\r\n<p>4th Rydale Jazz Festival 24th - 30th July</p>\r\n<p>Pickering Traction Rall 5th, 6th and 7th August</p>\r\n<p>Autumn Steam gala 30th Sept - 2nd Oct</p>\r\n<p>Pickering War Weekend 14th - 16th October</p>\";}')
 ,(45,NULL,'2016-06-04 15:27:38','2016-06-04 15:27:38',NULL,'1',9,1,'O:11:\"BlockRecord\":11:{s:5:\"_dbat\";i:1;s:6:\"_table\";s:14:\"btContentLocal\";s:8:\"_tableat\";s:14:\"btContentLocal\";s:6:\"_where\";N;s:6:\"_saved\";b:1;s:8:\"_lasterr\";b:0;s:9:\"_original\";a:2:{i:0;s:2:\"45\";i:1;s:1470:\"<h1>2016 events a Lowther House</h1>\r\n<p>Valentines Weekend - Two night stay, £140, includes afternoon tea on arrival and a bottle of fizz in your room.</p>\r\n<p>Easter Weekend - Easter Afternoon Tea available all weekend, Easter Egg Hunt on Sunday 27th March 2pm.</p>\r\n<p>The derelict chicken hut and run are being repaired and we hope to have it for ready for the new hen residents by the end of April.</p>\r\n<p>Our new \'Herdy Hut\' will be available to hire from May, the renovated glamping pod will be newly fitted out and ready for guests.</p>\r\n<p>The \'Vintage Barn\' - new for this Summer, when you visit for an overnight stay or for a treat in the tea garden you\'ll be able to visit the vintage barn - \'upcyled furniture, vintage finds and handmade gifts\'.</p>\r\n<p>Jazz on the Lawn - share a Summers evening, a nice glass of fizz and live jazz with the Rydale Jazz Band - June date tbc Summer Gala - Sat 9th July - Great food, live music, children\'s games, gifts and produce for sale.</p>\r\n<p>Sausage and Cider Day - Sunday 31st July (Bank Holiday weekend)</p>\r\n<p>Afternoon Tea - afternoon tea with all the trimmings, vintage china, tablecloths and embroidered napkins. Available Weds - Sunday £9.95. Gift certificates for afternoon tea available to treat someone special.</p>\r\n<p>Hire our Vintage Barn for parties,small weddings,events or birthdays. Theme your event, cater yourselves or we\'ll cater for you. Use of the beautiful garden throughout your event.</p>\";}s:11:\"foreignName\";s:11:\"blockrecord\";s:8:\"lockMode\";s:12:\" for update \";s:3:\"bID\";s:2:\"45\";s:7:\"content\";s:1470:\"<h1>2016 events a Lowther House</h1>\r\n<p>Valentines Weekend - Two night stay, £140, includes afternoon tea on arrival and a bottle of fizz in your room.</p>\r\n<p>Easter Weekend - Easter Afternoon Tea available all weekend, Easter Egg Hunt on Sunday 27th March 2pm.</p>\r\n<p>The derelict chicken hut and run are being repaired and we hope to have it for ready for the new hen residents by the end of April.</p>\r\n<p>Our new \'Herdy Hut\' will be available to hire from May, the renovated glamping pod will be newly fitted out and ready for guests.</p>\r\n<p>The \'Vintage Barn\' - new for this Summer, when you visit for an overnight stay or for a treat in the tea garden you\'ll be able to visit the vintage barn - \'upcyled furniture, vintage finds and handmade gifts\'.</p>\r\n<p>Jazz on the Lawn - share a Summers evening, a nice glass of fizz and live jazz with the Rydale Jazz Band - June date tbc Summer Gala - Sat 9th July - Great food, live music, children\'s games, gifts and produce for sale.</p>\r\n<p>Sausage and Cider Day - Sunday 31st July (Bank Holiday weekend)</p>\r\n<p>Afternoon Tea - afternoon tea with all the trimmings, vintage china, tablecloths and embroidered napkins. Available Weds - Sunday £9.95. Gift certificates for afternoon tea available to treat someone special.</p>\r\n<p>Hire our Vintage Barn for parties,small weddings,events or birthdays. Theme your event, cater yourselves or we\'ll cater for you. Use of the beautiful garden throughout your event.</p>\";}')
 ,(46,NULL,'2016-06-04 15:28:32','2016-06-04 15:28:32',NULL,'1',28,1,NULL)
 ,(47,NULL,'2016-06-04 15:29:08','2016-06-04 15:29:08',NULL,'1',9,1,'O:11:\"BlockRecord\":11:{s:5:\"_dbat\";i:1;s:6:\"_table\";s:14:\"btContentLocal\";s:8:\"_tableat\";s:14:\"btContentLocal\";s:6:\"_where\";N;s:6:\"_saved\";b:1;s:8:\"_lasterr\";b:0;s:9:\"_original\";a:2:{i:0;s:2:\"47\";i:1;s:399:\"<h1>Out Location</h1>\r\n<p>The house is surrounded by the fabulously \'Tolkien\' Pickering Woods in which are secret meadows, unchanged for centuries, you could well believe you\'re in the Shire of Middle Earth! Ideal for those who like either an early morning or late evening stroll (best times to spot Hobbits!).</p>\r\n<p>We can lend you a couple of bikes if you\'d like to pedal around for the day!</p>\";}s:11:\"foreignName\";s:11:\"blockrecord\";s:8:\"lockMode\";s:12:\" for update \";s:3:\"bID\";s:2:\"47\";s:7:\"content\";s:399:\"<h1>Out Location</h1>\r\n<p>The house is surrounded by the fabulously \'Tolkien\' Pickering Woods in which are secret meadows, unchanged for centuries, you could well believe you\'re in the Shire of Middle Earth! Ideal for those who like either an early morning or late evening stroll (best times to spot Hobbits!).</p>\r\n<p>We can lend you a couple of bikes if you\'d like to pedal around for the day!</p>\";}')
 ,(48,NULL,'2016-06-04 15:29:56','2016-06-04 15:29:56',NULL,'1',9,1,'O:11:\"BlockRecord\":11:{s:5:\"_dbat\";i:1;s:6:\"_table\";s:14:\"btContentLocal\";s:8:\"_tableat\";s:14:\"btContentLocal\";s:6:\"_where\";N;s:6:\"_saved\";b:1;s:8:\"_lasterr\";b:0;s:9:\"_original\";a:2:{i:0;s:2:\"48\";i:1;s:473:\"<h1>Cut &amp; About in the local area</h1>\r\n<p>Lorem ipsum dolor sit amet, quo doctus ponderum eu. Ad doming molestiae conclusionemque cum. Assum mandamus ne eum, at nulla oratio his. Eam dolore vivendum ad. An impetus appareat tincidunt has, id sed option liberavisse.</p>\r\n<p>Eu epicurei suscipiantur mea. Ius eu wisi suscipit, pri tollit vocibus id. Percipit tacimates id eum. Vel et alia nominavi laboramus, vel ex tritani prodesset, ut duo modo volutpat aliquando.</p>\";}s:11:\"foreignName\";s:11:\"blockrecord\";s:8:\"lockMode\";s:12:\" for update \";s:3:\"bID\";s:2:\"48\";s:7:\"content\";s:473:\"<h1>Cut &amp; About in the local area</h1>\r\n<p>Lorem ipsum dolor sit amet, quo doctus ponderum eu. Ad doming molestiae conclusionemque cum. Assum mandamus ne eum, at nulla oratio his. Eam dolore vivendum ad. An impetus appareat tincidunt has, id sed option liberavisse.</p>\r\n<p>Eu epicurei suscipiantur mea. Ius eu wisi suscipit, pri tollit vocibus id. Percipit tacimates id eum. Vel et alia nominavi laboramus, vel ex tritani prodesset, ut duo modo volutpat aliquando.</p>\";}')
 ,(49,NULL,'2016-06-04 15:30:19','2016-06-04 15:30:19',NULL,'1',9,1,'O:11:\"BlockRecord\":11:{s:5:\"_dbat\";i:1;s:6:\"_table\";s:14:\"btContentLocal\";s:8:\"_tableat\";s:14:\"btContentLocal\";s:6:\"_where\";N;s:6:\"_saved\";b:1;s:8:\"_lasterr\";b:0;s:9:\"_original\";a:2:{i:0;s:2:\"49\";i:1;s:25:\"<h1>Around the moors</h1>\";}s:11:\"foreignName\";s:11:\"blockrecord\";s:8:\"lockMode\";s:12:\" for update \";s:3:\"bID\";s:2:\"49\";s:7:\"content\";s:25:\"<h1>Around the moors</h1>\";}')
 ,(50,NULL,'2016-06-04 15:31:33','2016-06-04 15:31:33',NULL,'1',29,1,'O:11:\"BlockRecord\":18:{s:5:\"_dbat\";i:1;s:6:\"_table\";s:24:\"btContentResponsiveImage\";s:8:\"_tableat\";s:24:\"btContentResponsiveImage\";s:6:\"_where\";N;s:6:\"_saved\";b:1;s:8:\"_lasterr\";b:0;s:9:\"_original\";a:9:{i:0;s:2:\"50\";i:1;s:1:\"3\";i:2;s:1:\"0\";i:3;i:0;i:4;i:0;i:5;s:0:\"\";i:6;i:0;i:7;i:1;i:8;s:0:\"\";}s:11:\"foreignName\";s:11:\"blockrecord\";s:8:\"lockMode\";s:12:\" for update \";s:3:\"bID\";s:2:\"50\";s:3:\"fID\";s:1:\"3\";s:10:\"fOnstateID\";s:1:\"0\";s:8:\"maxWidth\";i:0;s:9:\"maxHeight\";i:0;s:12:\"externalLink\";s:0:\"\";s:15:\"internalLinkCID\";i:0;s:27:\"forceImageToMatchDimensions\";i:1;s:7:\"altText\";s:0:\"\";}')
 ,(51,NULL,'2016-06-04 15:32:23','2016-06-04 15:32:23',NULL,'1',9,1,'O:11:\"BlockRecord\":11:{s:5:\"_dbat\";i:1;s:6:\"_table\";s:14:\"btContentLocal\";s:8:\"_tableat\";s:14:\"btContentLocal\";s:6:\"_where\";N;s:6:\"_saved\";b:1;s:8:\"_lasterr\";b:0;s:9:\"_original\";a:2:{i:0;s:2:\"51\";i:1;s:596:\"<p>Available as a twin-bedded room. Double aspect, with lovely views of the Beck and the garden across to the Butts river meadow. With the added fun of watching the steam trains of the North York\'s Moors Railway as they chug up the dale to Whitby!</p>\r\n<p>Drift off to sleep with the sounds of the beck trickling by your window, interrupted only by the hoots of owls on their night-time hunting trips.</p>\r\n<p>For a romantic treat we are happy to serve breakfast in the room - just let us know ahead of time!</p>\r\n<p>The private wet-room with key access for exclusive use is across the hall.</p>\";}s:11:\"foreignName\";s:11:\"blockrecord\";s:8:\"lockMode\";s:12:\" for update \";s:3:\"bID\";s:2:\"51\";s:7:\"content\";s:596:\"<p>Available as a twin-bedded room. Double aspect, with lovely views of the Beck and the garden across to the Butts river meadow. With the added fun of watching the steam trains of the North York\'s Moors Railway as they chug up the dale to Whitby!</p>\r\n<p>Drift off to sleep with the sounds of the beck trickling by your window, interrupted only by the hoots of owls on their night-time hunting trips.</p>\r\n<p>For a romantic treat we are happy to serve breakfast in the room - just let us know ahead of time!</p>\r\n<p>The private wet-room with key access for exclusive use is across the hall.</p>\";}')
 ,(52,NULL,'2016-06-04 15:32:49','2016-06-04 15:32:49',NULL,'1',9,1,'O:11:\"BlockRecord\":11:{s:5:\"_dbat\";i:1;s:6:\"_table\";s:14:\"btContentLocal\";s:8:\"_tableat\";s:14:\"btContentLocal\";s:6:\"_where\";N;s:6:\"_saved\";b:1;s:8:\"_lasterr\";b:0;s:9:\"_original\";a:2:{i:0;s:2:\"52\";i:1;s:24:\"<h1>Along the coast</h1>\";}s:11:\"foreignName\";s:11:\"blockrecord\";s:8:\"lockMode\";s:12:\" for update \";s:3:\"bID\";s:2:\"52\";s:7:\"content\";s:24:\"<h1>Along the coast</h1>\";}')
 ,(53,NULL,'2016-06-04 15:33:02','2016-06-04 15:33:02',NULL,'1',29,1,'O:11:\"BlockRecord\":18:{s:5:\"_dbat\";i:1;s:6:\"_table\";s:24:\"btContentResponsiveImage\";s:8:\"_tableat\";s:24:\"btContentResponsiveImage\";s:6:\"_where\";N;s:6:\"_saved\";b:1;s:8:\"_lasterr\";b:0;s:9:\"_original\";a:9:{i:0;s:2:\"53\";i:1;s:1:\"3\";i:2;s:1:\"0\";i:3;i:0;i:4;i:0;i:5;s:0:\"\";i:6;i:0;i:7;i:1;i:8;s:0:\"\";}s:11:\"foreignName\";s:11:\"blockrecord\";s:8:\"lockMode\";s:12:\" for update \";s:3:\"bID\";s:2:\"53\";s:3:\"fID\";s:1:\"3\";s:10:\"fOnstateID\";s:1:\"0\";s:8:\"maxWidth\";i:0;s:9:\"maxHeight\";i:0;s:12:\"externalLink\";s:0:\"\";s:15:\"internalLinkCID\";i:0;s:27:\"forceImageToMatchDimensions\";i:1;s:7:\"altText\";s:0:\"\";}')
 ,(54,NULL,'2016-06-04 15:33:25','2016-06-04 15:33:25',NULL,'1',9,1,'O:11:\"BlockRecord\":11:{s:5:\"_dbat\";i:1;s:6:\"_table\";s:14:\"btContentLocal\";s:8:\"_tableat\";s:14:\"btContentLocal\";s:6:\"_where\";N;s:6:\"_saved\";b:1;s:8:\"_lasterr\";b:0;s:9:\"_original\";a:2:{i:0;s:2:\"54\";i:1;s:159:\"<p>A king-size bed (5\') with en-suite wet-room. Wake to gorgeous views over the garden orchard and Pickering Woods, maybe you\'ll see a deer or two as well!</p>\";}s:11:\"foreignName\";s:11:\"blockrecord\";s:8:\"lockMode\";s:12:\" for update \";s:3:\"bID\";s:2:\"54\";s:7:\"content\";s:159:\"<p>A king-size bed (5\') with en-suite wet-room. Wake to gorgeous views over the garden orchard and Pickering Woods, maybe you\'ll see a deer or two as well!</p>\";}')
 ,(55,NULL,'2016-06-04 15:33:44','2016-06-04 15:33:44',NULL,'1',9,1,'O:11:\"BlockRecord\":11:{s:5:\"_dbat\";i:1;s:6:\"_table\";s:14:\"btContentLocal\";s:8:\"_tableat\";s:14:\"btContentLocal\";s:6:\"_where\";N;s:6:\"_saved\";b:1;s:8:\"_lasterr\";b:0;s:9:\"_original\";a:2:{i:0;s:2:\"55\";i:1;s:30:\"<h1>Eating &amp; Drinking</h1>\";}s:11:\"foreignName\";s:11:\"blockrecord\";s:8:\"lockMode\";s:12:\" for update \";s:3:\"bID\";s:2:\"55\";s:7:\"content\";s:30:\"<h1>Eating &amp; Drinking</h1>\";}')
 ,(56,NULL,'2016-06-04 15:33:55','2016-06-04 15:33:55',NULL,'1',29,1,'O:11:\"BlockRecord\":18:{s:5:\"_dbat\";i:1;s:6:\"_table\";s:24:\"btContentResponsiveImage\";s:8:\"_tableat\";s:24:\"btContentResponsiveImage\";s:6:\"_where\";N;s:6:\"_saved\";b:1;s:8:\"_lasterr\";b:0;s:9:\"_original\";a:9:{i:0;s:2:\"56\";i:1;s:1:\"3\";i:2;s:1:\"0\";i:3;i:0;i:4;i:0;i:5;s:0:\"\";i:6;i:0;i:7;i:1;i:8;s:0:\"\";}s:11:\"foreignName\";s:11:\"blockrecord\";s:8:\"lockMode\";s:12:\" for update \";s:3:\"bID\";s:2:\"56\";s:3:\"fID\";s:1:\"3\";s:10:\"fOnstateID\";s:1:\"0\";s:8:\"maxWidth\";i:0;s:9:\"maxHeight\";i:0;s:12:\"externalLink\";s:0:\"\";s:15:\"internalLinkCID\";i:0;s:27:\"forceImageToMatchDimensions\";i:1;s:7:\"altText\";s:0:\"\";}')
 ,(57,NULL,'2016-06-04 15:34:07','2016-06-04 15:34:07',NULL,'1',9,1,'O:11:\"BlockRecord\":11:{s:5:\"_dbat\";i:1;s:6:\"_table\";s:14:\"btContentLocal\";s:8:\"_tableat\";s:14:\"btContentLocal\";s:6:\"_where\";N;s:6:\"_saved\";b:1;s:8:\"_lasterr\";b:0;s:9:\"_original\";a:2:{i:0;s:2:\"57\";i:1;s:429:\"<p>Lorem ipsum dolor sit amet, quo doctus ponderum eu. Ad doming molestiae conclusionemque cum. Assum mandamus ne eum, at nulla oratio his. Eam dolore vivendum ad. An impetus appareat tincidunt has, id sed option liberavisse.</p>\r\n<p>Eu epicurei suscipiantur mea. Ius eu wisi suscipit, pri tollit vocibus id. Percipit tacimates id eum. Vel et alia nominavi laboramus, vel ex tritani prodesset, ut duo modo volutpat aliquando.</p>\";}s:11:\"foreignName\";s:11:\"blockrecord\";s:8:\"lockMode\";s:12:\" for update \";s:3:\"bID\";s:2:\"57\";s:7:\"content\";s:429:\"<p>Lorem ipsum dolor sit amet, quo doctus ponderum eu. Ad doming molestiae conclusionemque cum. Assum mandamus ne eum, at nulla oratio his. Eam dolore vivendum ad. An impetus appareat tincidunt has, id sed option liberavisse.</p>\r\n<p>Eu epicurei suscipiantur mea. Ius eu wisi suscipit, pri tollit vocibus id. Percipit tacimates id eum. Vel et alia nominavi laboramus, vel ex tritani prodesset, ut duo modo volutpat aliquando.</p>\";}')
 ,(58,NULL,'2016-06-04 15:39:22','2016-06-04 15:39:22',NULL,'1',9,1,'O:11:\"BlockRecord\":11:{s:5:\"_dbat\";i:1;s:6:\"_table\";s:14:\"btContentLocal\";s:8:\"_tableat\";s:14:\"btContentLocal\";s:6:\"_where\";N;s:6:\"_saved\";b:1;s:8:\"_lasterr\";b:0;s:9:\"_original\";a:2:{i:0;s:2:\"58\";i:1;s:718:\"<h1>How to find Lowther House</h1>\r\n<p>We have two first floor rooms - so we can offer excellent service. Fresh flowers greet you, in hospitality corner there is a silent running fridge for your use for beverages, wine etc. - just ask for ice and glasses. Also, there are a selection of Twinings teas and Fresh Rombouts Coffees - yours for the making, plus biscuits to nibble, an insulated carafe of chilled filtered water is also provided. A radio-controlled alarm clock with a very useful weather feature is by the bed.</p>\r\n<p>There is a Freesat TV with DVD player a selection of DVD\'s/CD\'s is available on the landing. In the closet you\'ll find shower robes, hair dryer, shaver adaptor, fan, extra bedding etc.</p>\";}s:11:\"foreignName\";s:11:\"blockrecord\";s:8:\"lockMode\";s:12:\" for update \";s:3:\"bID\";s:2:\"58\";s:7:\"content\";s:718:\"<h1>How to find Lowther House</h1>\r\n<p>We have two first floor rooms - so we can offer excellent service. Fresh flowers greet you, in hospitality corner there is a silent running fridge for your use for beverages, wine etc. - just ask for ice and glasses. Also, there are a selection of Twinings teas and Fresh Rombouts Coffees - yours for the making, plus biscuits to nibble, an insulated carafe of chilled filtered water is also provided. A radio-controlled alarm clock with a very useful weather feature is by the bed.</p>\r\n<p>There is a Freesat TV with DVD player a selection of DVD\'s/CD\'s is available on the landing. In the closet you\'ll find shower robes, hair dryer, shaver adaptor, fan, extra bedding etc.</p>\";}')
 ,(59,NULL,'2016-06-04 15:40:33','2016-06-04 15:41:57',NULL,'1',17,1,'O:11:\"BlockRecord\":11:{s:5:\"_dbat\";i:1;s:6:\"_table\";s:14:\"btContentLocal\";s:8:\"_tableat\";s:14:\"btContentLocal\";s:6:\"_where\";N;s:6:\"_saved\";b:1;s:8:\"_lasterr\";b:0;s:9:\"_original\";a:2:{i:0;s:2:\"59\";i:1;s:403:\"<iframe src=\"https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d16045.60232683728!2d-0.7812352837625243!3d54.25955757072218!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x487f26281ae4319f%3A0x8462d61287f7f084!2sBridge+Row%2C+Newbridge%2C+Pickering%2C+North+Yorkshire+YO18+8JL!5e1!3m2!1sen!2suk!4v1465047689012\" width=\"100%\" height=\"500\" frameborder=\"0\" style=\"border:0\" allowfullscreen></iframe>\";}s:11:\"foreignName\";s:11:\"blockrecord\";s:8:\"lockMode\";s:12:\" for update \";s:3:\"bID\";s:2:\"59\";s:7:\"content\";s:403:\"<iframe src=\"https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d16045.60232683728!2d-0.7812352837625243!3d54.25955757072218!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x487f26281ae4319f%3A0x8462d61287f7f084!2sBridge+Row%2C+Newbridge%2C+Pickering%2C+North+Yorkshire+YO18+8JL!5e1!3m2!1sen!2suk!4v1465047689012\" width=\"100%\" height=\"500\" frameborder=\"0\" style=\"border:0\" allowfullscreen></iframe>\";}')
 ,(60,NULL,'2016-06-04 15:43:13','2016-06-04 15:43:13',NULL,'1',9,1,'O:11:\"BlockRecord\":11:{s:5:\"_dbat\";i:1;s:6:\"_table\";s:14:\"btContentLocal\";s:8:\"_tableat\";s:14:\"btContentLocal\";s:6:\"_where\";N;s:6:\"_saved\";b:1;s:8:\"_lasterr\";b:0;s:9:\"_original\";a:2:{i:0;s:2:\"60\";i:1;s:21:\"<h1>Booking Form</h1>\";}s:11:\"foreignName\";s:11:\"blockrecord\";s:8:\"lockMode\";s:12:\" for update \";s:3:\"bID\";s:2:\"60\";s:7:\"content\";s:21:\"<h1>Booking Form</h1>\";}')
 ,(61,NULL,'2016-06-04 15:43:35','2016-06-04 15:43:35',NULL,'1',9,1,'O:11:\"BlockRecord\":11:{s:5:\"_dbat\";i:1;s:6:\"_table\";s:14:\"btContentLocal\";s:8:\"_tableat\";s:14:\"btContentLocal\";s:6:\"_where\";N;s:6:\"_saved\";b:1;s:8:\"_lasterr\";b:0;s:9:\"_original\";a:2:{i:0;s:2:\"61\";i:1;s:29:\"<h1>Booking Enquiry Form</h1>\";}s:11:\"foreignName\";s:11:\"blockrecord\";s:8:\"lockMode\";s:12:\" for update \";s:3:\"bID\";s:2:\"61\";s:7:\"content\";s:29:\"<h1>Booking Enquiry Form</h1>\";}')
 ,(62,NULL,'2016-06-04 15:47:21','2016-06-04 15:47:21',NULL,'1',18,1,'O:11:\"BlockRecord\":18:{s:5:\"_dbat\";i:1;s:6:\"_table\";s:14:\"btContentImage\";s:8:\"_tableat\";s:14:\"btContentImage\";s:6:\"_where\";N;s:6:\"_saved\";b:1;s:8:\"_lasterr\";b:0;s:9:\"_original\";a:9:{i:0;s:2:\"62\";i:1;s:1:\"7\";i:2;s:1:\"0\";i:3;i:0;i:4;i:0;i:5;s:0:\"\";i:6;i:0;i:7;i:1;i:8;s:0:\"\";}s:11:\"foreignName\";s:11:\"blockrecord\";s:8:\"lockMode\";s:12:\" for update \";s:3:\"bID\";s:2:\"62\";s:3:\"fID\";s:1:\"7\";s:10:\"fOnstateID\";s:1:\"0\";s:8:\"maxWidth\";i:0;s:9:\"maxHeight\";i:0;s:12:\"externalLink\";s:0:\"\";s:15:\"internalLinkCID\";i:0;s:27:\"forceImageToMatchDimensions\";i:1;s:7:\"altText\";s:0:\"\";}')
 ,(63,NULL,'2016-06-04 15:47:38','2016-06-04 15:47:38',NULL,'1',18,1,'O:11:\"BlockRecord\":18:{s:5:\"_dbat\";i:1;s:6:\"_table\";s:14:\"btContentImage\";s:8:\"_tableat\";s:14:\"btContentImage\";s:6:\"_where\";N;s:6:\"_saved\";b:1;s:8:\"_lasterr\";b:0;s:9:\"_original\";a:9:{i:0;s:2:\"63\";i:1;s:1:\"6\";i:2;s:1:\"0\";i:3;i:0;i:4;i:0;i:5;s:0:\"\";i:6;i:0;i:7;i:1;i:8;s:0:\"\";}s:11:\"foreignName\";s:11:\"blockrecord\";s:8:\"lockMode\";s:12:\" for update \";s:3:\"bID\";s:2:\"63\";s:3:\"fID\";s:1:\"6\";s:10:\"fOnstateID\";s:1:\"0\";s:8:\"maxWidth\";i:0;s:9:\"maxHeight\";i:0;s:12:\"externalLink\";s:0:\"\";s:15:\"internalLinkCID\";i:0;s:27:\"forceImageToMatchDimensions\";i:1;s:7:\"altText\";s:0:\"\";}')
 ,(64,NULL,'2016-06-04 15:47:49','2016-06-04 15:47:49',NULL,'1',18,1,'O:11:\"BlockRecord\":18:{s:5:\"_dbat\";i:1;s:6:\"_table\";s:14:\"btContentImage\";s:8:\"_tableat\";s:14:\"btContentImage\";s:6:\"_where\";N;s:6:\"_saved\";b:1;s:8:\"_lasterr\";b:0;s:9:\"_original\";a:9:{i:0;s:2:\"64\";i:1;s:1:\"5\";i:2;s:1:\"0\";i:3;i:0;i:4;i:0;i:5;s:0:\"\";i:6;i:0;i:7;i:1;i:8;s:0:\"\";}s:11:\"foreignName\";s:11:\"blockrecord\";s:8:\"lockMode\";s:12:\" for update \";s:3:\"bID\";s:2:\"64\";s:3:\"fID\";s:1:\"5\";s:10:\"fOnstateID\";s:1:\"0\";s:8:\"maxWidth\";i:0;s:9:\"maxHeight\";i:0;s:12:\"externalLink\";s:0:\"\";s:15:\"internalLinkCID\";i:0;s:27:\"forceImageToMatchDimensions\";i:1;s:7:\"altText\";s:0:\"\";}')
 ,(65,NULL,'2016-06-04 15:48:00','2016-06-04 15:48:00',NULL,'1',18,1,'O:11:\"BlockRecord\":18:{s:5:\"_dbat\";i:1;s:6:\"_table\";s:14:\"btContentImage\";s:8:\"_tableat\";s:14:\"btContentImage\";s:6:\"_where\";N;s:6:\"_saved\";b:1;s:8:\"_lasterr\";b:0;s:9:\"_original\";a:9:{i:0;s:2:\"65\";i:1;s:1:\"4\";i:2;s:1:\"0\";i:3;i:0;i:4;i:0;i:5;s:0:\"\";i:6;i:0;i:7;i:1;i:8;s:0:\"\";}s:11:\"foreignName\";s:11:\"blockrecord\";s:8:\"lockMode\";s:12:\" for update \";s:3:\"bID\";s:2:\"65\";s:3:\"fID\";s:1:\"4\";s:10:\"fOnstateID\";s:1:\"0\";s:8:\"maxWidth\";i:0;s:9:\"maxHeight\";i:0;s:12:\"externalLink\";s:0:\"\";s:15:\"internalLinkCID\";i:0;s:27:\"forceImageToMatchDimensions\";i:1;s:7:\"altText\";s:0:\"\";}')
 ,(66,NULL,'2016-06-04 15:48:16','2016-06-04 15:48:16',NULL,'1',18,1,'O:11:\"BlockRecord\":18:{s:5:\"_dbat\";i:1;s:6:\"_table\";s:14:\"btContentImage\";s:8:\"_tableat\";s:14:\"btContentImage\";s:6:\"_where\";N;s:6:\"_saved\";b:1;s:8:\"_lasterr\";b:0;s:9:\"_original\";a:9:{i:0;s:2:\"66\";i:1;s:1:\"8\";i:2;s:1:\"0\";i:3;i:0;i:4;i:0;i:5;s:0:\"\";i:6;i:0;i:7;i:1;i:8;s:0:\"\";}s:11:\"foreignName\";s:11:\"blockrecord\";s:8:\"lockMode\";s:12:\" for update \";s:3:\"bID\";s:2:\"66\";s:3:\"fID\";s:1:\"8\";s:10:\"fOnstateID\";s:1:\"0\";s:8:\"maxWidth\";i:0;s:9:\"maxHeight\";i:0;s:12:\"externalLink\";s:0:\"\";s:15:\"internalLinkCID\";i:0;s:27:\"forceImageToMatchDimensions\";i:1;s:7:\"altText\";s:0:\"\";}');

DROP TABLE IF EXISTS CollectionAttributeValues;

CREATE TABLE IF NOT EXISTS `CollectionAttributeValues` (
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `cvID` int(10) unsigned NOT NULL DEFAULT '0',
  `akID` int(10) unsigned NOT NULL DEFAULT '0',
  `avID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cID`,`cvID`,`akID`,`avID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO CollectionAttributeValues VALUES(3,1,3,1)
 ,(3,1,4,2)
 ,(4,1,3,3)
 ,(4,1,4,4)
 ,(5,1,3,5)
 ,(5,1,4,6)
 ,(6,1,3,7)
 ,(7,1,3,8)
 ,(7,1,4,9)
 ,(8,1,3,10)
 ,(8,1,4,11)
 ,(9,1,3,12)
 ,(9,1,4,13)
 ,(11,1,3,14)
 ,(11,1,4,15)
 ,(12,1,3,16)
 ,(12,1,4,17)
 ,(13,1,3,18)
 ,(13,1,4,19)
 ,(14,1,3,21)
 ,(14,1,4,22)
 ,(14,1,5,20)
 ,(15,1,3,23)
 ,(16,1,3,24)
 ,(16,1,4,25)
 ,(17,1,3,26)
 ,(17,1,4,27)
 ,(18,1,3,28)
 ,(18,1,4,29)
 ,(19,1,3,30)
 ,(19,1,4,32)
 ,(19,1,5,31)
 ,(20,1,3,33)
 ,(20,1,4,35)
 ,(20,1,5,34)
 ,(21,1,3,36)
 ,(21,1,4,37)
 ,(22,1,3,38)
 ,(23,1,3,39)
 ,(23,1,4,40)
 ,(24,1,3,41)
 ,(24,1,4,42)
 ,(25,1,3,43)
 ,(25,1,4,44)
 ,(26,1,3,45)
 ,(26,1,4,46)
 ,(28,1,3,47)
 ,(28,1,4,48)
 ,(29,1,3,49)
 ,(30,1,3,50)
 ,(31,1,3,51)
 ,(32,1,3,52)
 ,(32,1,4,53)
 ,(34,1,3,54)
 ,(34,1,4,55)
 ,(35,1,3,56)
 ,(35,1,4,57)
 ,(36,1,3,58)
 ,(37,1,4,59)
 ,(38,1,4,60)
 ,(40,1,3,61)
 ,(40,1,4,62)
 ,(41,1,4,63)
 ,(42,1,5,64)
 ,(42,1,8,65)
 ,(43,1,3,66)
 ,(43,1,4,67)
 ,(44,1,5,68)
 ,(45,1,5,69)
 ,(46,1,3,70)
 ,(47,1,3,71)
 ,(48,1,3,72)
 ,(49,1,3,73)
 ,(50,1,3,74)
 ,(51,1,5,75)
 ,(53,1,3,76)
 ,(54,1,3,77)
 ,(55,1,3,78)
 ,(56,1,3,79)
 ,(57,1,3,80)
 ,(58,1,3,81)
 ,(60,1,3,82)
 ,(61,1,3,83)
 ,(62,1,3,84)
 ,(63,1,3,85)
 ,(64,1,3,86)
 ,(65,1,3,87)
 ,(67,1,3,88)
 ,(68,1,3,89)
 ,(69,1,3,90)
 ,(71,1,3,91)
 ,(72,1,3,92)
 ,(73,1,3,93)
 ,(74,1,3,94)
 ,(77,1,3,95)
 ,(78,1,3,96)
 ,(79,1,3,97)
 ,(80,1,3,98)
 ,(82,1,3,99)
 ,(83,1,3,100)
 ,(84,1,3,101)
 ,(85,1,3,102)
 ,(86,1,3,103)
 ,(87,1,3,104)
 ,(88,1,3,105)
 ,(89,1,3,106)
 ,(90,1,3,107)
 ,(91,1,3,108)
 ,(92,1,8,109)
 ,(93,1,3,110)
 ,(94,1,3,111)
 ,(95,1,3,112)
 ,(96,1,3,113)
 ,(97,1,3,114)
 ,(98,1,3,115)
 ,(100,1,3,116)
 ,(101,1,3,117)
 ,(106,1,5,118)
 ,(107,1,5,119)
 ,(107,1,8,120)
 ,(125,9,15,127)
 ,(125,10,15,127);

DROP TABLE IF EXISTS CollectionSearchIndexAttributes;

CREATE TABLE IF NOT EXISTS `CollectionSearchIndexAttributes` (
  `cID` int(11) unsigned NOT NULL DEFAULT '0',
  `ak_meta_title` text,
  `ak_meta_description` text,
  `ak_meta_keywords` text,
  `ak_icon_dashboard` text,
  `ak_exclude_nav` tinyint(4) DEFAULT '0',
  `ak_exclude_page_list` tinyint(4) DEFAULT '0',
  `ak_header_extra_content` text,
  `ak_exclude_search_index` tinyint(4) DEFAULT '0',
  `ak_exclude_sitemapxml` tinyint(4) DEFAULT '0',
  `ak_body_class` text,
  PRIMARY KEY (`cID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO CollectionSearchIndexAttributes VALUES(1,NULL,NULL,NULL,NULL,0,0,NULL,0,0,NULL)
 ,(3,NULL,NULL,'blog, blogging','icon-book',0,0,NULL,0,0,NULL)
 ,(4,NULL,NULL,'new blog, write blog, blogging','icon-pencil',0,0,NULL,0,0,NULL)
 ,(5,NULL,NULL,'blog drafts, composer','icon-book',0,0,NULL,0,0,NULL)
 ,(6,NULL,NULL,'pages, add page, delete page, copy, move, alias',NULL,0,0,NULL,0,0,NULL)
 ,(7,NULL,NULL,'pages, add page, delete page, copy, move, alias','icon-home',0,0,NULL,0,0,NULL)
 ,(8,NULL,NULL,'pages, add page, delete page, copy, move, alias, bulk','icon-road',0,0,NULL,0,0,NULL)
 ,(9,NULL,NULL,'find page, search page, search, find, pages, sitemap','icon-search',0,0,NULL,0,0,NULL)
 ,(11,NULL,NULL,'add file, delete file, copy, move, alias, resize, crop, rename, images, title, attribute','icon-picture',0,0,NULL,0,0,NULL)
 ,(12,NULL,NULL,'file, file attributes, title, attribute, description, rename','icon-cog',0,0,NULL,0,0,NULL)
 ,(13,NULL,NULL,'files, category, categories','icon-list-alt',0,0,NULL,0,0,NULL)
 ,(14,NULL,NULL,'new file set','icon-plus-sign',1,0,NULL,0,0,NULL)
 ,(15,NULL,NULL,'users, groups, people, find, delete user, remove user, change password, password',NULL,0,0,NULL,0,0,NULL)
 ,(16,NULL,NULL,'find, search, people, delete user, remove user, change password, password','icon-user',0,0,NULL,0,0,NULL)
 ,(17,NULL,NULL,'user, group, people, permissions, access, expire','icon-globe',0,0,NULL,0,0,NULL)
 ,(18,NULL,NULL,'user attributes, user data, gather data, registration data','icon-cog',0,0,NULL,0,0,NULL)
 ,(19,NULL,NULL,'new user, create','icon-plus-sign',1,0,NULL,0,0,NULL)
 ,(20,NULL,NULL,'new user group, new group, group, create','icon-plus',1,0,NULL,0,0,NULL)
 ,(21,NULL,NULL,'group set','icon-list',0,0,NULL,0,0,NULL)
 ,(22,NULL,NULL,'forms, log, error, email, mysql, exception, survey',NULL,0,0,NULL,0,0,NULL)
 ,(23,NULL,NULL,'hits, pageviews, visitors, activity','icon-signal',0,0,NULL,0,0,NULL)
 ,(24,NULL,NULL,'forms, questions, response, data','icon-briefcase',0,0,NULL,0,0,NULL)
 ,(25,NULL,NULL,'questions, quiz, response','icon-tasks',0,0,NULL,0,0,NULL)
 ,(26,NULL,NULL,'forms, log, error, email, mysql, exception, survey, history','icon-time',0,0,NULL,0,0,NULL)
 ,(28,NULL,NULL,'new theme, theme, active theme, change theme, template, css','icon-font',0,0,NULL,0,0,NULL)
 ,(29,NULL,NULL,'theme',NULL,0,0,NULL,0,0,NULL)
 ,(30,NULL,NULL,'page types',NULL,0,0,NULL,0,0,NULL)
 ,(31,NULL,NULL,'custom theme, change theme, custom css, css',NULL,0,0,NULL,0,0,NULL)
 ,(32,NULL,NULL,'page type defaults, global block, global area, starter, template','icon-file',0,0,NULL,0,0,NULL)
 ,(34,NULL,NULL,'page attributes, custom','icon-cog',0,0,NULL,0,0,NULL)
 ,(35,NULL,NULL,'single, page, custom, application','icon-wrench',0,0,NULL,0,0,NULL)
 ,(36,NULL,NULL,'add workflow, remove workflow',NULL,0,0,NULL,0,0,NULL)
 ,(37,NULL,NULL,NULL,'icon-list',0,0,NULL,0,0,NULL)
 ,(38,NULL,NULL,NULL,'icon-user',0,0,NULL,0,0,NULL)
 ,(40,NULL,NULL,'stacks, reusable content, scrapbook, copy, paste, paste block, copy block, site name, logo','icon-th',0,0,NULL,0,0,NULL)
 ,(41,NULL,NULL,NULL,'icon-lock',0,0,NULL,0,0,NULL)
 ,(42,NULL,NULL,NULL,NULL,1,0,NULL,1,0,NULL)
 ,(43,NULL,NULL,'block, refresh, custom','icon-wrench',0,0,NULL,0,0,NULL)
 ,(44,NULL,NULL,NULL,NULL,1,0,NULL,0,0,NULL)
 ,(45,NULL,NULL,NULL,NULL,1,0,NULL,0,0,NULL)
 ,(46,NULL,NULL,'add-on, addon, ecommerce, install, discussions, forums, themes, templates, blocks',NULL,0,0,NULL,0,0,NULL)
 ,(47,NULL,NULL,'update, upgrade',NULL,0,0,NULL,0,0,NULL)
 ,(48,NULL,NULL,'concrete5.org, my account, marketplace',NULL,0,0,NULL,0,0,NULL)
 ,(49,NULL,NULL,'buy theme, new theme, marketplace, template',NULL,0,0,NULL,0,0,NULL)
 ,(50,NULL,NULL,'buy addon, buy add on, buy add-on, purchase addon, purchase add on, purchase add-on, find addon, new addon, marketplace',NULL,0,0,NULL,0,0,NULL)
 ,(51,NULL,NULL,NULL,NULL,1,0,NULL,0,0,NULL)
 ,(53,NULL,NULL,'website name, title',NULL,0,0,NULL,0,0,NULL)
 ,(54,NULL,NULL,'logo, favicon, iphone, icon, bookmark',NULL,0,0,NULL,0,0,NULL)
 ,(55,NULL,NULL,'tinymce, content block, fonts, editor, content, overlay',NULL,0,0,NULL,0,0,NULL)
 ,(56,NULL,NULL,'translate, translation, internationalization, multilingual',NULL,0,0,NULL,0,0,NULL)
 ,(57,NULL,NULL,'timezone, profile, locale',NULL,0,0,NULL,0,0,NULL)
 ,(58,NULL,NULL,'interface, quick nav, dashboard background, background image',NULL,0,0,NULL,0,0,NULL)
 ,(60,NULL,NULL,'vanity, pretty url, seo, pageview, view',NULL,0,0,NULL,0,0,NULL)
 ,(61,NULL,NULL,'bulk, seo, change keywords, engine, optimization, search',NULL,0,0,NULL,0,0,NULL)
 ,(62,NULL,NULL,'traffic, statistics, google analytics, quant, pageviews, hits',NULL,0,0,NULL,0,0,NULL)
 ,(63,NULL,NULL,'pretty, slug',NULL,0,0,NULL,0,0,NULL)
 ,(64,NULL,NULL,'turn off statistics, tracking, statistics, pageviews, hits',NULL,0,0,NULL,0,0,NULL)
 ,(65,NULL,NULL,'configure search, site search, search option',NULL,0,0,NULL,0,0,NULL)
 ,(67,NULL,NULL,'cache option, change cache, override, turn on cache, turn off cache, no cache, page cache, caching',NULL,0,0,NULL,0,0,NULL)
 ,(68,NULL,NULL,'cache option, turn off cache, no cache, page cache, caching',NULL,0,0,NULL,0,0,NULL)
 ,(69,NULL,NULL,'index search, reindex search, build sitemap, sitemap.xml, clear old versions, page versions, remove old',NULL,0,0,NULL,0,0,NULL)
 ,(71,NULL,NULL,'editors, hide site, offline, private, public, access',NULL,0,0,NULL,0,0,NULL)
 ,(72,NULL,NULL,'file options, file manager, upload, modify',NULL,0,0,NULL,0,0,NULL)
 ,(73,NULL,NULL,'security, files, media, extension, manager, upload',NULL,0,0,NULL,0,0,NULL)
 ,(74,NULL,NULL,'security, actions, administrator, admin, package, marketplace, search',NULL,0,0,NULL,0,0,NULL)
 ,(77,NULL,NULL,'security, lock ip, lock out, block ip, address, restrict, access',NULL,0,0,NULL,0,0,NULL)
 ,(78,NULL,NULL,'security, registration',NULL,0,0,NULL,0,0,NULL)
 ,(79,NULL,NULL,'antispam, block spam, security',NULL,0,0,NULL,0,0,NULL)
 ,(80,NULL,NULL,'lock site, under construction, hide, hidden',NULL,0,0,NULL,0,0,NULL)
 ,(82,NULL,NULL,'profile, login, redirect, specific, dashboard, administrators',NULL,0,0,NULL,0,0,NULL)
 ,(83,NULL,NULL,'member profile, member page, community, forums, social, avatar',NULL,0,0,NULL,0,0,NULL)
 ,(84,NULL,NULL,'signup, new user, community',NULL,0,0,NULL,0,0,NULL)
 ,(85,NULL,NULL,'smtp, mail settings',NULL,0,0,NULL,0,0,NULL)
 ,(86,NULL,NULL,'email server, mail settings, mail configuration, external, internal',NULL,0,0,NULL,0,0,NULL)
 ,(87,NULL,NULL,'test smtp, test mail',NULL,0,0,NULL,0,0,NULL)
 ,(88,NULL,NULL,'email server, mail settings, mail configuration, private message, message system, import, email, message',NULL,0,0,NULL,0,0,NULL)
 ,(89,NULL,NULL,'attribute configuration',NULL,0,0,NULL,0,0,NULL)
 ,(90,NULL,NULL,'attributes, sets',NULL,0,0,NULL,0,0,NULL)
 ,(91,NULL,NULL,'attributes, types',NULL,0,0,NULL,0,0,NULL)
 ,(92,NULL,NULL,NULL,NULL,0,0,NULL,1,0,NULL)
 ,(93,NULL,NULL,'overrides, system info, debug, support, help',NULL,0,0,NULL,0,0,NULL)
 ,(94,NULL,NULL,'errors, exceptions, develop, support, help',NULL,0,0,NULL,0,0,NULL)
 ,(95,NULL,NULL,'email, logging, logs, smtp, pop, errors, mysql, log',NULL,0,0,NULL,0,0,NULL)
 ,(96,NULL,NULL,'security, alternate storage, hide files',NULL,0,0,NULL,0,0,NULL)
 ,(97,NULL,NULL,'network, proxy server',NULL,0,0,NULL,0,0,NULL)
 ,(98,NULL,NULL,'export, backup, database, sql, mysql, encryption, restore',NULL,0,0,NULL,0,0,NULL)
 ,(100,NULL,NULL,'upgrade, new version, update',NULL,0,0,NULL,0,0,NULL)
 ,(101,NULL,NULL,'export, database, xml, starting, points, schema, refresh, custom, tables',NULL,0,0,NULL,0,0,NULL)
 ,(106,NULL,NULL,NULL,NULL,1,0,NULL,0,0,NULL)
 ,(107,NULL,NULL,NULL,NULL,1,0,NULL,1,0,NULL)
 ,(122,NULL,NULL,NULL,NULL,0,0,NULL,0,0,NULL)
 ,(124,NULL,NULL,NULL,NULL,0,0,NULL,0,0,NULL)
 ,(125,NULL,NULL,NULL,NULL,0,0,NULL,0,0,'rooms')
 ,(126,NULL,NULL,NULL,NULL,0,0,NULL,0,0,NULL)
 ,(127,NULL,NULL,NULL,NULL,0,0,NULL,0,0,NULL)
 ,(128,NULL,NULL,NULL,NULL,0,0,NULL,0,0,NULL)
 ,(129,NULL,NULL,NULL,NULL,0,0,NULL,0,0,NULL)
 ,(130,NULL,NULL,NULL,NULL,0,0,NULL,0,0,NULL);

DROP TABLE IF EXISTS CollectionVersionAreaLayouts;

CREATE TABLE IF NOT EXISTS `CollectionVersionAreaLayouts` (
  `cvalID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cID` int(10) unsigned DEFAULT '0',
  `cvID` int(10) unsigned DEFAULT '0',
  `arHandle` varchar(255) DEFAULT NULL,
  `layoutID` int(10) unsigned NOT NULL DEFAULT '0',
  `position` int(10) DEFAULT '1000',
  `areaNameNumber` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`cvalID`),
  KEY `areaLayoutsIndex` (`cID`,`cvID`,`arHandle`),
  KEY `cID` (`cID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS CollectionVersionAreaStyles;

CREATE TABLE IF NOT EXISTS `CollectionVersionAreaStyles` (
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `cvID` int(10) unsigned NOT NULL DEFAULT '0',
  `arHandle` varchar(255) NOT NULL,
  `csrID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cID`,`cvID`,`arHandle`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS CollectionVersionBlockStyles;

CREATE TABLE IF NOT EXISTS `CollectionVersionBlockStyles` (
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `cvID` int(10) unsigned NOT NULL DEFAULT '0',
  `bID` int(10) unsigned NOT NULL DEFAULT '0',
  `arHandle` varchar(255) NOT NULL,
  `csrID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cID`,`cvID`,`bID`,`arHandle`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS CollectionVersionBlocks;

CREATE TABLE IF NOT EXISTS `CollectionVersionBlocks` (
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `cvID` int(10) unsigned NOT NULL DEFAULT '1',
  `bID` int(10) unsigned NOT NULL DEFAULT '0',
  `arHandle` varchar(255) NOT NULL,
  `cbDisplayOrder` int(10) unsigned NOT NULL DEFAULT '0',
  `isOriginal` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `cbOverrideAreaPermissions` tinyint(1) NOT NULL DEFAULT '0',
  `cbIncludeAll` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`cID`,`cvID`,`bID`,`arHandle`),
  KEY `cbIncludeAll` (`cbIncludeAll`),
  KEY `isOriginal` (`isOriginal`),
  KEY `bID` (`bID`),
  KEY `cIDcvID` (`cID`,`cvID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO CollectionVersionBlocks VALUES(1,2,13,'Slideshow',0,1,0,0)
 ,(1,3,13,'Slideshow',0,0,0,0)
 ,(1,3,14,'Main',0,1,0,0)
 ,(1,4,13,'Slideshow',0,0,0,0)
 ,(1,4,14,'Main',0,0,0,0)
 ,(1,4,15,'Main Side Bar',0,1,0,0)
 ,(1,5,13,'Slideshow',0,0,0,0)
 ,(1,5,14,'Main',0,0,0,0)
 ,(1,5,16,'Main Side Bar',0,1,0,0)
 ,(106,1,1,'Header',0,1,0,0)
 ,(106,1,2,'Column 1',0,1,0,0)
 ,(106,1,3,'Column 2',0,1,0,0)
 ,(106,1,4,'Column 3',0,1,0,0)
 ,(106,1,5,'Column 4',0,1,0,0)
 ,(107,1,6,'Primary',0,1,0,0)
 ,(107,1,7,'Primary',1,1,0,0)
 ,(107,1,8,'Secondary 1',0,1,0,0)
 ,(107,1,9,'Secondary 2',0,1,0,0)
 ,(107,1,10,'Secondary 3',0,1,0,0)
 ,(107,1,11,'Secondary 4',0,1,0,0)
 ,(107,1,12,'Secondary 5',0,1,0,0)
 ,(122,2,62,'Main',0,1,0,0)
 ,(122,3,62,'Main',0,0,0,0)
 ,(122,3,63,'Main',1,1,0,0)
 ,(122,4,62,'Main',0,0,0,0)
 ,(122,4,63,'Main',1,0,0,0)
 ,(122,4,64,'Main',2,1,0,0)
 ,(122,5,62,'Main',0,0,0,0)
 ,(122,5,63,'Main',1,0,0,0)
 ,(122,5,64,'Main',2,0,0,0)
 ,(122,5,65,'Main',3,1,0,0)
 ,(122,6,62,'Main',0,0,0,0)
 ,(122,6,63,'Main',1,0,0,0)
 ,(122,6,64,'Main',2,0,0,0)
 ,(122,6,65,'Main',3,0,0,0)
 ,(122,6,66,'Main',4,1,0,0)
 ,(124,2,17,'Slideshow',0,1,0,0)
 ,(124,2,18,'Main',0,1,0,0)
 ,(124,2,19,'Main Side Bar',0,1,0,0)
 ,(125,2,20,'Slideshow',0,1,0,0)
 ,(125,2,21,'Slideshow Side Bar',0,1,0,0)
 ,(125,3,20,'Slideshow',0,0,0,0)
 ,(125,3,21,'Slideshow Side Bar',0,0,0,0)
 ,(125,3,22,'Main',0,1,0,0)
 ,(125,3,23,'Column One',0,1,0,0)
 ,(125,3,24,'Column Two',0,1,0,0)
 ,(125,3,25,'Column Three',0,1,0,0)
 ,(125,4,20,'Slideshow',0,0,0,0)
 ,(125,4,21,'Slideshow Side Bar',0,0,0,0)
 ,(125,4,22,'Main',0,0,0,0)
 ,(125,4,23,'Column One',0,0,0,0)
 ,(125,4,24,'Column Two',0,0,0,0)
 ,(125,4,25,'Column Three',0,0,0,0)
 ,(125,4,26,'Column One',1,1,0,0)
 ,(125,4,27,'Column Two',1,1,0,0)
 ,(125,4,28,'Column Three',1,1,0,0)
 ,(125,4,29,'Column One',2,1,0,0)
 ,(125,4,30,'Column Two',2,1,0,0)
 ,(125,4,31,'Column Three',2,1,0,0)
 ,(125,5,20,'Slideshow',0,0,0,0)
 ,(125,5,21,'Slideshow Side Bar',0,0,0,0)
 ,(125,5,22,'Main',0,0,0,0)
 ,(125,5,23,'Column One',0,0,0,0)
 ,(125,5,24,'Column Two',0,0,0,0)
 ,(125,5,25,'Column Three',0,0,0,0)
 ,(125,5,26,'Column One',1,0,0,0)
 ,(125,5,27,'Column Two',1,0,0,0)
 ,(125,5,28,'Column Three',1,0,0,0)
 ,(125,5,29,'Column One',2,0,0,0)
 ,(125,5,30,'Column Two',2,0,0,0)
 ,(125,5,31,'Column Three',2,0,0,0)
 ,(125,5,32,'Tariff',0,1,0,0)
 ,(125,6,20,'Slideshow',0,0,0,0)
 ,(125,6,21,'Slideshow Side Bar',0,0,0,0)
 ,(125,6,22,'Main',0,0,0,0)
 ,(125,6,23,'Column One',0,0,0,0)
 ,(125,6,24,'Column Two',0,0,0,0)
 ,(125,6,25,'Column Three',0,0,0,0)
 ,(125,6,26,'Column One',1,0,0,0)
 ,(125,6,27,'Column Two',1,0,0,0)
 ,(125,6,28,'Column Three',1,0,0,0)
 ,(125,6,29,'Column One',2,0,0,0)
 ,(125,6,30,'Column Two',2,0,0,0)
 ,(125,6,31,'Column Three',2,0,0,0)
 ,(125,6,33,'Tariff',0,1,0,0)
 ,(125,7,20,'Slideshow',0,0,0,0)
 ,(125,7,21,'Slideshow Side Bar',0,0,0,0)
 ,(125,7,22,'Main',0,0,0,0)
 ,(125,7,23,'Column One',0,0,0,0)
 ,(125,7,24,'Column Two',0,0,0,0)
 ,(125,7,25,'Column Three',0,0,0,0)
 ,(125,7,26,'Column One',1,0,0,0)
 ,(125,7,27,'Column Two',1,0,0,0)
 ,(125,7,28,'Column Three',1,0,0,0)
 ,(125,7,29,'Column One',2,0,0,0)
 ,(125,7,30,'Column Two',2,0,0,0)
 ,(125,7,31,'Column Three',2,0,0,0)
 ,(125,7,33,'Tariff',0,0,0,0)
 ,(125,7,34,'Testimonials',0,1,0,0)
 ,(125,7,35,'Testimonials',1,1,0,0)
 ,(125,7,36,'Testimonials',2,1,0,0)
 ,(125,8,20,'Slideshow',0,0,0,0)
 ,(125,8,21,'Slideshow Side Bar',0,0,0,0)
 ,(125,8,22,'Main',0,0,0,0)
 ,(125,8,23,'Column One',0,0,0,0)
 ,(125,8,24,'Column Two',0,0,0,0)
 ,(125,8,25,'Column Three',0,0,0,0)
 ,(125,8,26,'Column One',1,0,0,0)
 ,(125,8,27,'Column Two',1,0,0,0)
 ,(125,8,28,'Column Three',1,0,0,0)
 ,(125,8,29,'Column One',2,0,0,0)
 ,(125,8,30,'Column Two',2,0,0,0)
 ,(125,8,31,'Column Three',2,0,0,0)
 ,(125,8,33,'Tariff',0,0,0,0)
 ,(125,8,34,'Testimonials',0,0,0,0)
 ,(125,8,35,'Testimonials',1,0,0,0)
 ,(125,8,36,'Testimonials',2,0,0,0)
 ,(125,8,37,'Booking Info',0,1,0,0)
 ,(125,9,20,'Slideshow',0,0,0,0)
 ,(125,9,21,'Slideshow Side Bar',0,0,0,0)
 ,(125,9,22,'Main',0,0,0,0)
 ,(125,9,23,'Column One',0,0,0,0)
 ,(125,9,24,'Column Two',0,0,0,0)
 ,(125,9,25,'Column Three',0,0,0,0)
 ,(125,9,26,'Column One',1,0,0,0)
 ,(125,9,27,'Column Two',1,0,0,0)
 ,(125,9,28,'Column Three',1,0,0,0)
 ,(125,9,29,'Column One',2,0,0,0)
 ,(125,9,30,'Column Two',2,0,0,0)
 ,(125,9,31,'Column Three',2,0,0,0)
 ,(125,9,33,'Tariff',0,0,0,0)
 ,(125,9,34,'Testimonials',0,0,0,0)
 ,(125,9,35,'Testimonials',1,0,0,0)
 ,(125,9,36,'Testimonials',2,0,0,0)
 ,(125,9,37,'Booking Info',0,0,0,0)
 ,(125,10,20,'Slideshow',0,0,0,0)
 ,(125,10,21,'Slideshow Side Bar',0,0,0,0)
 ,(125,10,22,'Main',0,0,0,0)
 ,(125,10,23,'Column One',0,0,0,0)
 ,(125,10,24,'Column Two',0,0,0,0)
 ,(125,10,25,'Column Three',0,0,0,0)
 ,(125,10,26,'Column One',1,0,0,0)
 ,(125,10,27,'Column Two',1,0,0,0)
 ,(125,10,28,'Column Three',1,0,0,0)
 ,(125,10,29,'Column One',2,0,0,0)
 ,(125,10,30,'Column Two',2,0,0,0)
 ,(125,10,31,'Column Three',2,0,0,0)
 ,(125,10,33,'Tariff',0,0,0,0)
 ,(125,10,34,'Testimonials',0,0,0,0)
 ,(125,10,35,'Testimonials',1,0,0,0)
 ,(125,10,36,'Testimonials',2,0,0,0)
 ,(125,10,37,'Booking Info',0,0,0,0)
 ,(126,3,38,'Slideshow',0,1,0,0)
 ,(126,3,39,'Slideshow Side Bar',0,1,0,0)
 ,(126,3,40,'Column One',0,1,0,0)
 ,(126,3,41,'Column Two',0,1,0,0)
 ,(128,2,42,'Slideshow Side Bar',0,1,0,0)
 ,(128,2,43,'Slideshow',0,1,0,0)
 ,(128,2,44,'Column One',0,1,0,0)
 ,(128,2,45,'Column Two',0,1,0,0)
 ,(129,2,46,'Slideshow',0,1,0,0)
 ,(129,2,47,'Slideshow Side Bar',0,1,0,0)
 ,(129,2,48,'Main',0,1,0,0)
 ,(129,2,49,'Column One',0,1,0,0)
 ,(129,3,46,'Slideshow',0,0,0,0)
 ,(129,3,47,'Slideshow Side Bar',0,0,0,0)
 ,(129,3,48,'Main',0,0,0,0)
 ,(129,3,49,'Column One',0,0,0,0)
 ,(129,3,50,'Column One',1,1,0,0)
 ,(129,3,51,'Column One',2,1,0,0)
 ,(129,3,52,'Column Two',0,1,0,0)
 ,(129,3,53,'Column Two',1,1,0,0)
 ,(129,3,54,'Column Two',2,1,0,0)
 ,(129,3,55,'Column Three',0,1,0,0)
 ,(129,3,56,'Column Three',1,1,0,0)
 ,(129,3,57,'Column Three',2,1,0,0)
 ,(130,2,58,'Main',0,1,0,0)
 ,(130,2,59,'Slideshow',0,1,0,0)
 ,(130,3,58,'Main',0,0,0,0)
 ,(130,3,59,'Slideshow',0,0,0,0)
 ,(130,3,60,'Slideshow Side Bar',0,1,0,0)
 ,(130,4,58,'Main',0,0,0,0)
 ,(130,4,59,'Slideshow',0,0,0,0)
 ,(130,4,61,'Slideshow Side Bar',0,1,0,0);

DROP TABLE IF EXISTS CollectionVersionBlocksOutputCache;

CREATE TABLE IF NOT EXISTS `CollectionVersionBlocksOutputCache` (
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `cvID` int(10) unsigned NOT NULL DEFAULT '1',
  `bID` int(10) unsigned NOT NULL DEFAULT '0',
  `arHandle` varchar(255) NOT NULL,
  `btCachedBlockOutput` longtext,
  `btCachedBlockOutputExpires` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cID`,`cvID`,`bID`,`arHandle`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO CollectionVersionBlocksOutputCache VALUES(1,5,14,'Main','<h1>Woodland Bed &amp; Breakfast with tea garden</h1>\r\n<p>Lowther House is set at the end of a tree lined drive in a clearing in Pickering Woods. It has a real country feel about it yet is just a ten minute walk down a tree-lined avenue into Pickering Town Centre.</p>\r\n<p>The house is bordered on two sides by Pickering Beck and is part of the Duchy of Lancaster Estate. The North York Moors Railway station is just five minutes away and the track runs past the garden. It’s a lovely sight to see when the steam trains go past – especially if you’re having cake and tea in the garden at the same time!!</p>\r\n<p>The house sits between the North York Moors National Park - which you can walk into from our gate - and the Yorkshire Wolds to the south, making it the perfect location for exploring some of the most spectacular scenery around. Excellent walks and cycle tracks are right outside our door,</p>\r\n<blockquote>“We moved into Lowther House in September 2015 after running a pub and bed and breakfast in the Yorkshire Dales. We knew the first time we saw Lowther House that we wanted to live here, the house are gardens are beautiful and have a real sense of calm about them. We hope you will enjoy the comfort, charm and warm welcome at Lowther House.”</blockquote>',1622812934)
 ,(1,5,16,'Main Side Bar','<h1>Latest News &amp; Info</h1>\r\n<h4>Winter warmer<br />bed &amp; breakfast<br />special offer</h4>\r\n<p>Available Nov - Feb inclusive.</p>\r\n<p>Book one night and get (consecutive) night free.</p>\r\n<p>Subject to availabliity<br />Room price is £80.</p>',1622812934)
 ,(125,9,21,'Slideshow Side Bar','<h1>Booking Enquiry Form</h1>',1622813458)
 ,(125,9,22,'Main','<h1>Bedrooms at Lowther House</h1>\r\n<p>We have two first floor rooms - so we can offer excellent service. Fresh flowers greet you, in hospitality corner there is a silent running fridge for your use for beverages, wine etc. - just ask for ice and glasses. Also, there are a selection of Twinings teas and Fresh Rombouts Coffees - yours for the making, plus biscuits to nibble, an insulated carafe of chilled filtered water is also provided. A radio-controlled alarm clock with a very useful weather feature is by the bed.</p>\r\n<p>There is a Freesat TV with DVD player a selection of DVD\'s/CD\'s is available on the landing. In the closet you\'ll find shower robes, hair dryer, shaver adaptor, fan, extra bedding etc.</p>',1622813459)
 ,(125,9,23,'Column One','<h1>Beck Room</h1>',1622813459)
 ,(125,9,24,'Column Two','<h1>Orchard Room</h1>',1622813459)
 ,(125,9,25,'Column Three','<h1>Garden Room</h1>',1622813459)
 ,(125,9,26,'Column One','<img border=\"0\" class=\"ccm-image-block\" alt=\"\" src=\"http://test:8888/lowther-house/files/3314/6460/9580/house.jpg\"  width=\"100%\" height=\"100%\" />',1622813459)
 ,(125,9,27,'Column Two','<img border=\"0\" class=\"ccm-image-block\" alt=\"\" src=\"http://test:8888/lowther-house/files/3314/6460/9580/house.jpg\"  width=\"100%\" height=\"100%\" />',1622813459)
 ,(125,9,28,'Column Three','<img border=\"0\" class=\"ccm-image-block\" alt=\"\" src=\"http://test:8888/lowther-house/files/3314/6460/9580/house.jpg\"  width=\"100%\" height=\"100%\" />',1622813459)
 ,(125,9,29,'Column One','<p>BECK ROOM Available as a twin-bedded room. Double aspect, with lovely views of the Beck and the garden across to the Butts river meadow. With the added fun of watching the steam trains of the North York\'s Moors Railway as they chug up the dale to Whitby!</p>\r\n<p>Drift off to sleep with the sounds of the beck trickling by your window, interrupted only by the hoots of owls on their night-time hunting trips.</p>\r\n<p>For a romantic treat we are happy to serve breakfast in the room - just let us know ahead of time! The private wet-room with key access for exclusive use is across the hall</p>',1622813459)
 ,(125,9,30,'Column Two','<p>ORCHARD ROOM A king-size bed (5\') with en-suite wet-room. Wake to gorgeous views over the garden orchard and Pickering Woods, maybe you\'ll see a deer or two as well!</p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam sodales vehicula risus, et facilisis massa lacinia eget. Pellentesque auctor bibendum urna sed tempus. Pellentesque elementum, tellus quis tristique maximus, eros arcu malesuada augue, nec consectetur purus sem quis velit.</p>',1622813459)
 ,(125,9,31,'Column Three','<p>GARDEN ROOM Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam sodales vehicula risus, et facilisis massa lacinia eget. Pellentesque auctor bibendum urna sed tempus. Pellentesque elementum, tellus quis tristique maximus, eros arcu malesuada augue, nec consectetur purus sem quis velit.</p>\r\n<p>Curabitur molestie nisl nisl, a eleifend tortor congue ut. Morbi eleifend sapien vel felis consequat, tincidunt convallis eros malesuada. Sed mollis aliquet nisi, lobortis aliquam nibh tristique vel. Nulla accumsan ipsum felis. Nunc eget diam nunc. Pvarius magna eget.</p>',1622813459)
 ,(125,9,33,'Tariff','<h1>Bed &amp; Breakfast tariff for 2016</h1>\r\n<p>Lowther House Tariff below is for direct bookings only</p>\r\n<table>\r\n<tbody>\r\n<tr><th>Rooms</th><th>1 Night</th><th>2-4 Nights</th><th>5+ Nights</th></tr>\r\n<tr>\r\n<td><strong>Orchard</strong><br />En-suite, King</td>\r\n<td>£75</td>\r\n<td>£70</td>\r\n<td>£65</td>\r\n</tr>\r\n<tr>\r\n<td><strong>Beckside</strong><br />Separate Bathroom Twin or Super King</td>\r\n<td>£70</td>\r\n<td>£65</td>\r\n<td>£60</td>\r\n</tr>\r\n<tr>\r\n<td><strong>Garden</strong><br />Separate Bathroom</td>\r\n<td>£70</td>\r\n<td>£65</td>\r\n<td>£60</td>\r\n</tr>\r\n</tbody>\r\n</table>',1622813459)
 ,(125,9,34,'Testimonials','<blockquote>“Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam sodales vehicula risus, et facilisis massa lacinia eget. Pellentesque auctor bibendum urna sed tempus. Pellentesque elementum, tellus quis tristique maximus, eros arcu malesuada augue, nec consectetur purus sem quis velit.”</blockquote>',1622813459)
 ,(125,9,35,'Testimonials','<blockquote>Eu epicurei suscipiantur mea. Ius eu wisi suscipit, pri tollit vocibus id. Percipit tacimates id eum. Vel et alia nominavi laboramus, vel ex tritani prodesset, ut duo modo volutpat aliquando.</blockquote>',1622813459)
 ,(125,9,36,'Testimonials','<blockquote>Mutat essent ut sea, est solum mucius te. Qui veniam consetetur definiebas an. Dicam intellegam definitiones vis ut, perfecto tincidunt incorrupte sit ex. Vis graece virtute inimicus no, nec ad efficiendi definitionem, at aeque abhorreant omittantur mei. Persius signiferumque eum ne.</blockquote>',1622813459)
 ,(125,9,37,'Booking Info','<h1>Booking Information</h1>\r\n<p>Single occupancy rates are £10.00 less per room.</p>\r\n<p>Prices are inclusive of breakfast.</p>\r\n<p>We accept well behaved dogs at a one off charge of £10 per dog.</p>\r\n<p>Bookings through third parties may be charged at a higher tariff</p>\r\n<p>We accept most British and International Debit, Credit and Commercial Cards, for deposits and payments, except Diners and Amex. If you need further information please give us a call on 01751 477 568 or email <a href=\"mailto:info@lowtherhouse.co.uk\">info@lowtherhouse.co.uk</a></p>\r\n<h6>DOWNLOADS</h6>\r\n<p>Booking Terms &amp; Conditions <br />Accesibility Statement <br />B&amp;B Tariff</p>',1622813459)
 ,(125,10,21,'Slideshow Side Bar','<h1>Booking Enquiry Form</h1>',1622814502)
 ,(125,10,22,'Main','<h1>Bedrooms at Lowther House</h1>\r\n<p>We have two first floor rooms - so we can offer excellent service. Fresh flowers greet you, in hospitality corner there is a silent running fridge for your use for beverages, wine etc. - just ask for ice and glasses. Also, there are a selection of Twinings teas and Fresh Rombouts Coffees - yours for the making, plus biscuits to nibble, an insulated carafe of chilled filtered water is also provided. A radio-controlled alarm clock with a very useful weather feature is by the bed.</p>\r\n<p>There is a Freesat TV with DVD player a selection of DVD\'s/CD\'s is available on the landing. In the closet you\'ll find shower robes, hair dryer, shaver adaptor, fan, extra bedding etc.</p>',1622814502)
 ,(125,10,23,'Column One','<h1>Beck Room</h1>',1622814502)
 ,(125,10,24,'Column Two','<h1>Orchard Room</h1>',1622814502)
 ,(125,10,25,'Column Three','<h1>Garden Room</h1>',1622814502)
 ,(125,10,26,'Column One','<img border=\"0\" class=\"ccm-image-block\" alt=\"\" src=\"http://test:8888/lowther-house/files/3314/6460/9580/house.jpg\"  width=\"100%\" height=\"100%\" />',1622814502)
 ,(125,10,27,'Column Two','<img border=\"0\" class=\"ccm-image-block\" alt=\"\" src=\"http://test:8888/lowther-house/files/3314/6460/9580/house.jpg\"  width=\"100%\" height=\"100%\" />',1622814502)
 ,(125,10,28,'Column Three','<img border=\"0\" class=\"ccm-image-block\" alt=\"\" src=\"http://test:8888/lowther-house/files/3314/6460/9580/house.jpg\"  width=\"100%\" height=\"100%\" />',1622814502)
 ,(125,10,29,'Column One','<p>BECK ROOM Available as a twin-bedded room. Double aspect, with lovely views of the Beck and the garden across to the Butts river meadow. With the added fun of watching the steam trains of the North York\'s Moors Railway as they chug up the dale to Whitby!</p>\r\n<p>Drift off to sleep with the sounds of the beck trickling by your window, interrupted only by the hoots of owls on their night-time hunting trips.</p>\r\n<p>For a romantic treat we are happy to serve breakfast in the room - just let us know ahead of time! The private wet-room with key access for exclusive use is across the hall</p>',1622814502)
 ,(125,10,30,'Column Two','<p>ORCHARD ROOM A king-size bed (5\') with en-suite wet-room. Wake to gorgeous views over the garden orchard and Pickering Woods, maybe you\'ll see a deer or two as well!</p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam sodales vehicula risus, et facilisis massa lacinia eget. Pellentesque auctor bibendum urna sed tempus. Pellentesque elementum, tellus quis tristique maximus, eros arcu malesuada augue, nec consectetur purus sem quis velit.</p>',1622814502)
 ,(125,10,31,'Column Three','<p>GARDEN ROOM Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam sodales vehicula risus, et facilisis massa lacinia eget. Pellentesque auctor bibendum urna sed tempus. Pellentesque elementum, tellus quis tristique maximus, eros arcu malesuada augue, nec consectetur purus sem quis velit.</p>\r\n<p>Curabitur molestie nisl nisl, a eleifend tortor congue ut. Morbi eleifend sapien vel felis consequat, tincidunt convallis eros malesuada. Sed mollis aliquet nisi, lobortis aliquam nibh tristique vel. Nulla accumsan ipsum felis. Nunc eget diam nunc. Pvarius magna eget.</p>',1622814502)
 ,(125,10,33,'Tariff','<h1>Bed &amp; Breakfast tariff for 2016</h1>\r\n<p>Lowther House Tariff below is for direct bookings only</p>\r\n<table>\r\n<tbody>\r\n<tr><th>Rooms</th><th>1 Night</th><th>2-4 Nights</th><th>5+ Nights</th></tr>\r\n<tr>\r\n<td><strong>Orchard</strong><br />En-suite, King</td>\r\n<td>£75</td>\r\n<td>£70</td>\r\n<td>£65</td>\r\n</tr>\r\n<tr>\r\n<td><strong>Beckside</strong><br />Separate Bathroom Twin or Super King</td>\r\n<td>£70</td>\r\n<td>£65</td>\r\n<td>£60</td>\r\n</tr>\r\n<tr>\r\n<td><strong>Garden</strong><br />Separate Bathroom</td>\r\n<td>£70</td>\r\n<td>£65</td>\r\n<td>£60</td>\r\n</tr>\r\n</tbody>\r\n</table>',1622814502)
 ,(125,10,34,'Testimonials','<blockquote>“Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam sodales vehicula risus, et facilisis massa lacinia eget. Pellentesque auctor bibendum urna sed tempus. Pellentesque elementum, tellus quis tristique maximus, eros arcu malesuada augue, nec consectetur purus sem quis velit.”</blockquote>',1622814502)
 ,(125,10,35,'Testimonials','<blockquote>Eu epicurei suscipiantur mea. Ius eu wisi suscipit, pri tollit vocibus id. Percipit tacimates id eum. Vel et alia nominavi laboramus, vel ex tritani prodesset, ut duo modo volutpat aliquando.</blockquote>',1622814502)
 ,(125,10,36,'Testimonials','<blockquote>Mutat essent ut sea, est solum mucius te. Qui veniam consetetur definiebas an. Dicam intellegam definitiones vis ut, perfecto tincidunt incorrupte sit ex. Vis graece virtute inimicus no, nec ad efficiendi definitionem, at aeque abhorreant omittantur mei. Persius signiferumque eum ne.</blockquote>',1622814502)
 ,(125,10,37,'Booking Info','<h1>Booking Information</h1>\r\n<p>Single occupancy rates are £10.00 less per room.</p>\r\n<p>Prices are inclusive of breakfast.</p>\r\n<p>We accept well behaved dogs at a one off charge of £10 per dog.</p>\r\n<p>Bookings through third parties may be charged at a higher tariff</p>\r\n<p>We accept most British and International Debit, Credit and Commercial Cards, for deposits and payments, except Diners and Amex. If you need further information please give us a call on 01751 477 568 or email <a href=\"mailto:info@lowtherhouse.co.uk\">info@lowtherhouse.co.uk</a></p>\r\n<h6>DOWNLOADS</h6>\r\n<p>Booking Terms &amp; Conditions <br />Accesibility Statement <br />B&amp;B Tariff</p>',1622814502)
 ,(125,10,62,'Badges','<img border=\"0\" class=\"ccm-image-block\" alt=\"\" src=\"/lowther-house/files/6614/6504/8030/enjoy-eng-stars.png\" width=\"82\" height=\"118\" />',1622814441)
 ,(125,10,63,'Badges','<img border=\"0\" class=\"ccm-image-block\" alt=\"\" src=\"/lowther-house/files/3814/6504/8029/enjoy-eng-silver.png\" width=\"82\" height=\"118\" />',1622814458)
 ,(125,10,64,'Badges','<img border=\"0\" class=\"ccm-image-block\" alt=\"\" src=\"/lowther-house/files/3314/6504/8029/enjoy-eng-breakfast.png\" width=\"83\" height=\"118\" />',1622814469)
 ,(125,10,65,'Badges','<img border=\"0\" class=\"ccm-image-block\" alt=\"\" src=\"/lowther-house/files/8614/6504/8029/cyclist-welcome.png\" width=\"80\" height=\"80\" />',1622814480)
 ,(125,10,66,'Badges','<img border=\"0\" class=\"ccm-image-block\" alt=\"\" src=\"/lowther-house/files/5714/6504/8030/walkers-welcome.png\" width=\"80\" height=\"80\" />',1622814496)
 ,(126,3,39,'Slideshow Side Bar','<h1>Eating With Us</h1>\r\n<p>Lorem ipsum dolor sit amet, quo doctus ponderum eu. Ad doming molestiae conclusionemque cum. Assum mandamus ne eum, at nulla oratio his. Eam dolore vivendum ad. An impetus appareat tincidunt has, id sed option liberavisse.</p>\r\n<p>Eu epicurei suscipiantur mea. Ius eu wisi suscipit, pri tollit vocibus id. Percipit tacimates id eum. Vel et alia nominavi laboramus, vel ex tritani prodesset, ut duo modo volutpat aliquando.</p>',1622812440)
 ,(126,3,40,'Column One','<h1>Meals</h1>\r\n<p>We pride ourselves on the freshness and quality of our food, all our fresh food is purchased from local butchers, bakers, greengrocers, fishmongers and grocery stores ensuring we know when and where it grew or was made. Meals can be served in the dining room or terrace, weather permitting.</p>\r\n<h6>SAMPLE MENU</h6>',1622812492)
 ,(126,3,41,'Column Two','<h1>Breakfast</h1>\r\n<h6>SAMPLE MENU</h6>\r\n<p>100% pure fresh fruit juice</p>\r\n<p>Choice of Teas and Cafetiere coffee, or our luxury Hot Frothy Chocolate</p>\r\n<p>Choice of Cereals and Porridge</p>\r\n<p>Traditional English ­ grilled not fried</p>\r\n<p>A choice of: Bacon, Sausages, Baked Beans, Yorkshire Black Pudding (yes there are other varieties!), Mushrooms, Hash Browns, Tomatoes, Eggs cooked a variety of ways.</p>\r\n<h6>CONTINENTAL</h6>\r\n<p>A variety of meats and cheeses, fresh fruit, yoghurt, croissants, etc.</p>\r\n<p>Granary or White Toast with local Jams, Jellies and Marmalade ­ even Marmite!</p>',1622812600)
 ,(128,2,42,'Slideshow Side Bar','<h1>Events Info</h1>\r\n<p>Lorem ipsum dolor sit amet, quo doctus ponderum eu. Ad doming molestiae conclusionemque cum. Assum mandamus ne eum, at nulla oratio his. Eam dolore vivendum ad. An impetus appareat tincidunt has, id sed option liberavisse.</p>\r\n<p>Eu epicurei suscipiantur mea. Ius eu wisi suscipit, pri tollit vocibus id. Percipit tacimates id eum. Vel et alia nominavi laboramus, vel ex tritani prodesset, ut duo modo volutpat aliquando.</p>',1622813007)
 ,(128,2,44,'Column One','<h1>Local Events</h1>\r\n<p>Flying Scotsman visits NYMR - 12th, 13th, 15th, 16th, 17th, 19th, and 20th March</p>\r\n<p>NYMR Summer services begin Mon 21st March</p>\r\n<p>Tour de Yorkshire (Stage 3) Sunday 1st May</p>\r\n<p>NYMR Steam Gala 6th - 8th and 13th - 15th May, visiting engines LNWR 58926 and Standard 80072</p>\r\n<p>Malton Food Festival 28th - 29th May</p>\r\n<p>70\'s Weekend at NMR 17th - 19th June</p>\r\n<p>Forest Live - Dalby Forest music festival 23rd - 25th June</p>\r\n<p>60\'s Weekend at NYMR 2nd - 3rd July</p>\r\n<p>Classic Car and Vehicle Rally 9th - 10th July</p>\r\n<p>4th Rydale Jazz Festival 24th - 30th July</p>\r\n<p>Pickering Traction Rall 5th, 6th and 7th August</p>\r\n<p>Autumn Steam gala 30th Sept - 2nd Oct</p>\r\n<p>Pickering War Weekend 14th - 16th October</p>',1622813124)
 ,(128,2,45,'Column Two','<h1>2016 events a Lowther House</h1>\r\n<p>Valentines Weekend - Two night stay, £140, includes afternoon tea on arrival and a bottle of fizz in your room.</p>\r\n<p>Easter Weekend - Easter Afternoon Tea available all weekend, Easter Egg Hunt on Sunday 27th March 2pm.</p>\r\n<p>The derelict chicken hut and run are being repaired and we hope to have it for ready for the new hen residents by the end of April.</p>\r\n<p>Our new \'Herdy Hut\' will be available to hire from May, the renovated glamping pod will be newly fitted out and ready for guests.</p>\r\n<p>The \'Vintage Barn\' - new for this Summer, when you visit for an overnight stay or for a treat in the tea garden you\'ll be able to visit the vintage barn - \'upcyled furniture, vintage finds and handmade gifts\'.</p>\r\n<p>Jazz on the Lawn - share a Summers evening, a nice glass of fizz and live jazz with the Rydale Jazz Band - June date tbc Summer Gala - Sat 9th July - Great food, live music, children\'s games, gifts and produce for sale.</p>\r\n<p>Sausage and Cider Day - Sunday 31st July (Bank Holiday weekend)</p>\r\n<p>Afternoon Tea - afternoon tea with all the trimmings, vintage china, tablecloths and embroidered napkins. Available Weds - Sunday £9.95. Gift certificates for afternoon tea available to treat someone special.</p>\r\n<p>Hire our Vintage Barn for parties,small weddings,events or birthdays. Theme your event, cater yourselves or we\'ll cater for you. Use of the beautiful garden throughout your event.</p>',1622813258)
 ,(129,2,47,'Slideshow Side Bar','<h1>Out Location</h1>\r\n<p>The house is surrounded by the fabulously \'Tolkien\' Pickering Woods in which are secret meadows, unchanged for centuries, you could well believe you\'re in the Shire of Middle Earth! Ideal for those who like either an early morning or late evening stroll (best times to spot Hobbits!).</p>\r\n<p>We can lend you a couple of bikes if you\'d like to pedal around for the day!</p>',1622813348)
 ,(129,2,48,'Main','<h1>Cut &amp; About in the local area</h1>\r\n<p>Lorem ipsum dolor sit amet, quo doctus ponderum eu. Ad doming molestiae conclusionemque cum. Assum mandamus ne eum, at nulla oratio his. Eam dolore vivendum ad. An impetus appareat tincidunt has, id sed option liberavisse.</p>\r\n<p>Eu epicurei suscipiantur mea. Ius eu wisi suscipit, pri tollit vocibus id. Percipit tacimates id eum. Vel et alia nominavi laboramus, vel ex tritani prodesset, ut duo modo volutpat aliquando.</p>',1622813396)
 ,(129,2,49,'Column One','<h1>Around the moors</h1>',1622813419)
 ,(129,3,47,'Slideshow Side Bar','<h1>Out Location</h1>\r\n<p>The house is surrounded by the fabulously \'Tolkien\' Pickering Woods in which are secret meadows, unchanged for centuries, you could well believe you\'re in the Shire of Middle Earth! Ideal for those who like either an early morning or late evening stroll (best times to spot Hobbits!).</p>\r\n<p>We can lend you a couple of bikes if you\'d like to pedal around for the day!</p>',1622813651)
 ,(129,3,48,'Main','<h1>Cut &amp; About in the local area</h1>\r\n<p>Lorem ipsum dolor sit amet, quo doctus ponderum eu. Ad doming molestiae conclusionemque cum. Assum mandamus ne eum, at nulla oratio his. Eam dolore vivendum ad. An impetus appareat tincidunt has, id sed option liberavisse.</p>\r\n<p>Eu epicurei suscipiantur mea. Ius eu wisi suscipit, pri tollit vocibus id. Percipit tacimates id eum. Vel et alia nominavi laboramus, vel ex tritani prodesset, ut duo modo volutpat aliquando.</p>',1622813651)
 ,(129,3,49,'Column One','<h1>Around the moors</h1>',1622813651)
 ,(129,3,50,'Column One','<img border=\"0\" class=\"ccm-image-block\" alt=\"\" src=\"http://test:8888/lowther-house/files/3314/6460/9580/house.jpg\"  width=\"100%\" height=\"100%\" />',1622813493)
 ,(129,3,51,'Column One','<p>Available as a twin-bedded room. Double aspect, with lovely views of the Beck and the garden across to the Butts river meadow. With the added fun of watching the steam trains of the North York\'s Moors Railway as they chug up the dale to Whitby!</p>\r\n<p>Drift off to sleep with the sounds of the beck trickling by your window, interrupted only by the hoots of owls on their night-time hunting trips.</p>\r\n<p>For a romantic treat we are happy to serve breakfast in the room - just let us know ahead of time!</p>\r\n<p>The private wet-room with key access for exclusive use is across the hall.</p>',1622813543)
 ,(129,3,52,'Column Two','<h1>Along the coast</h1>',1622813569)
 ,(129,3,53,'Column Two','<img border=\"0\" class=\"ccm-image-block\" alt=\"\" src=\"http://test:8888/lowther-house/files/3314/6460/9580/house.jpg\"  width=\"100%\" height=\"100%\" />',1622813582)
 ,(129,3,54,'Column Two','<p>A king-size bed (5\') with en-suite wet-room. Wake to gorgeous views over the garden orchard and Pickering Woods, maybe you\'ll see a deer or two as well!</p>',1622813606)
 ,(129,3,55,'Column Three','<h1>Eating &amp; Drinking</h1>',1622813624)
 ,(129,3,56,'Column Three','<img border=\"0\" class=\"ccm-image-block\" alt=\"\" src=\"http://test:8888/lowther-house/files/3314/6460/9580/house.jpg\"  width=\"100%\" height=\"100%\" />',1622813635)
 ,(129,3,57,'Column Three','<p>Lorem ipsum dolor sit amet, quo doctus ponderum eu. Ad doming molestiae conclusionemque cum. Assum mandamus ne eum, at nulla oratio his. Eam dolore vivendum ad. An impetus appareat tincidunt has, id sed option liberavisse.</p>\r\n<p>Eu epicurei suscipiantur mea. Ius eu wisi suscipit, pri tollit vocibus id. Percipit tacimates id eum. Vel et alia nominavi laboramus, vel ex tritani prodesset, ut duo modo volutpat aliquando.</p>',1622813647)
 ,(130,2,58,'Main','<h1>How to find Lowther House</h1>\r\n<p>We have two first floor rooms - so we can offer excellent service. Fresh flowers greet you, in hospitality corner there is a silent running fridge for your use for beverages, wine etc. - just ask for ice and glasses. Also, there are a selection of Twinings teas and Fresh Rombouts Coffees - yours for the making, plus biscuits to nibble, an insulated carafe of chilled filtered water is also provided. A radio-controlled alarm clock with a very useful weather feature is by the bed.</p>\r\n<p>There is a Freesat TV with DVD player a selection of DVD\'s/CD\'s is available on the landing. In the closet you\'ll find shower robes, hair dryer, shaver adaptor, fan, extra bedding etc.</p>',1622813962)
 ,(130,2,59,'Slideshow','\n<div id=\"HTMLBlock59\" class=\"HTMLBlock\">\n<iframe src=\"https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d16045.60232683728!2d-0.7812352837625243!3d54.25955757072218!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x487f26281ae4319f%3A0x8462d61287f7f084!2sBridge+Row%2C+Newbridge%2C+Pickering%2C+North+Yorkshire+YO18+8JL!5e1!3m2!1sen!2suk!4v1465047689012\" width=\"100%\" height=\"500\" frameborder=\"0\" style=\"border:0\" allowfullscreen></iframe></div>',1622814118)
 ,(130,3,58,'Main','<h1>How to find Lowther House</h1>\r\n<p>We have two first floor rooms - so we can offer excellent service. Fresh flowers greet you, in hospitality corner there is a silent running fridge for your use for beverages, wine etc. - just ask for ice and glasses. Also, there are a selection of Twinings teas and Fresh Rombouts Coffees - yours for the making, plus biscuits to nibble, an insulated carafe of chilled filtered water is also provided. A radio-controlled alarm clock with a very useful weather feature is by the bed.</p>\r\n<p>There is a Freesat TV with DVD player a selection of DVD\'s/CD\'s is available on the landing. In the closet you\'ll find shower robes, hair dryer, shaver adaptor, fan, extra bedding etc.</p>',1622814197)
 ,(130,3,59,'Slideshow','\n<div id=\"HTMLBlock59\" class=\"HTMLBlock\">\n<iframe src=\"https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d16045.60232683728!2d-0.7812352837625243!3d54.25955757072218!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x487f26281ae4319f%3A0x8462d61287f7f084!2sBridge+Row%2C+Newbridge%2C+Pickering%2C+North+Yorkshire+YO18+8JL!5e1!3m2!1sen!2suk!4v1465047689012\" width=\"100%\" height=\"500\" frameborder=\"0\" style=\"border:0\" allowfullscreen></iframe></div>',1622814197)
 ,(130,3,60,'Slideshow Side Bar','<h1>Booking Form</h1>',1622814193)
 ,(130,4,58,'Main','<h1>How to find Lowther House</h1>\r\n<p>We have two first floor rooms - so we can offer excellent service. Fresh flowers greet you, in hospitality corner there is a silent running fridge for your use for beverages, wine etc. - just ask for ice and glasses. Also, there are a selection of Twinings teas and Fresh Rombouts Coffees - yours for the making, plus biscuits to nibble, an insulated carafe of chilled filtered water is also provided. A radio-controlled alarm clock with a very useful weather feature is by the bed.</p>\r\n<p>There is a Freesat TV with DVD player a selection of DVD\'s/CD\'s is available on the landing. In the closet you\'ll find shower robes, hair dryer, shaver adaptor, fan, extra bedding etc.</p>',1622814220)
 ,(130,4,59,'Slideshow','\n<div id=\"HTMLBlock59\" class=\"HTMLBlock\">\n<iframe src=\"https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d16045.60232683728!2d-0.7812352837625243!3d54.25955757072218!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x487f26281ae4319f%3A0x8462d61287f7f084!2sBridge+Row%2C+Newbridge%2C+Pickering%2C+North+Yorkshire+YO18+8JL!5e1!3m2!1sen!2suk!4v1465047689012\" width=\"100%\" height=\"500\" frameborder=\"0\" style=\"border:0\" allowfullscreen></iframe></div>',1622814220)
 ,(130,4,61,'Slideshow Side Bar','<h1>Booking Enquiry Form</h1>',1622814216);

DROP TABLE IF EXISTS CollectionVersionRelatedEdits;

CREATE TABLE IF NOT EXISTS `CollectionVersionRelatedEdits` (
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `cvID` int(10) unsigned NOT NULL DEFAULT '0',
  `cRelationID` int(10) unsigned NOT NULL DEFAULT '0',
  `cvRelationID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cID`,`cvID`,`cRelationID`,`cvRelationID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS CollectionVersions;

CREATE TABLE IF NOT EXISTS `CollectionVersions` (
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `cvID` int(10) unsigned NOT NULL DEFAULT '1',
  `cvName` text,
  `cvHandle` varchar(255) DEFAULT NULL,
  `cvDescription` text,
  `cvDatePublic` datetime DEFAULT NULL,
  `cvDateCreated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `cvComments` varchar(255) DEFAULT NULL,
  `cvIsApproved` tinyint(1) NOT NULL DEFAULT '0',
  `cvIsNew` tinyint(1) NOT NULL DEFAULT '0',
  `cvAuthorUID` int(10) unsigned DEFAULT NULL,
  `cvApproverUID` int(10) unsigned DEFAULT NULL,
  `ptID` int(10) unsigned NOT NULL DEFAULT '0',
  `ctID` int(10) unsigned NOT NULL DEFAULT '0',
  `cvActivateDatetime` datetime DEFAULT NULL,
  PRIMARY KEY (`cID`,`cvID`),
  KEY `cvIsApproved` (`cvIsApproved`),
  KEY `ctID` (`ctID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO CollectionVersions VALUES(1,1,'Home','home','','2016-05-21 13:53:25','2016-05-21 13:53:25','Version 1',0,0,1,NULL,5,4,NULL)
 ,(1,2,'Home','home','','2016-05-21 13:53:25','2016-05-30 14:00:17','Version 2',0,0,1,1,5,4,NULL)
 ,(1,3,'Home','home','','2016-05-21 13:53:25','2016-05-30 14:45:28','Version 3',0,0,1,1,5,4,NULL)
 ,(1,4,'Home','home','','2016-05-21 13:53:25','2016-05-30 17:15:28','Version 4',0,0,1,1,5,4,NULL)
 ,(1,5,'Home','home','','2016-05-21 13:53:25','2016-05-30 17:18:06','Version 5',1,0,1,1,5,4,NULL)
 ,(2,1,'Dashboard','dashboard','','2016-05-21 13:53:29','2016-05-21 13:53:29','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(3,1,'Composer','composer','Write for your site.','2016-05-21 13:53:29','2016-05-21 13:53:29','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(4,1,'Write','write','','2016-05-21 13:53:29','2016-05-21 13:53:29','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(5,1,'Drafts','drafts','','2016-05-21 13:53:29','2016-05-21 13:53:29','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(6,1,'Sitemap','sitemap','Whole world at a glance.','2016-05-21 13:53:29','2016-05-21 13:53:29','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(7,1,'Full Sitemap','full','','2016-05-21 13:53:29','2016-05-21 13:53:29','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(8,1,'Flat View','explore','','2016-05-21 13:53:29','2016-05-21 13:53:29','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(9,1,'Page Search','search','','2016-05-21 13:53:29','2016-05-21 13:53:29','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(10,1,'Files','files','All documents and images.','2016-05-21 13:53:29','2016-05-21 13:53:29','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(11,1,'File Manager','search','','2016-05-21 13:53:29','2016-05-21 13:53:29','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(12,1,'Attributes','attributes','','2016-05-21 13:53:29','2016-05-21 13:53:29','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(13,1,'File Sets','sets','','2016-05-21 13:53:29','2016-05-21 13:53:29','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(14,1,'Add File Set','add_set','','2016-05-21 13:53:29','2016-05-21 13:53:29','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(15,1,'Members','users','Add and manage the user accounts and groups on your website.','2016-05-21 13:53:29','2016-05-21 13:53:29','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(16,1,'Search Users','search','','2016-05-21 13:53:29','2016-05-21 13:53:29','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(17,1,'User Groups','groups','','2016-05-21 13:53:29','2016-05-21 13:53:29','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(18,1,'Attributes','attributes','','2016-05-21 13:53:29','2016-05-21 13:53:29','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(19,1,'Add User','add','','2016-05-21 13:53:29','2016-05-21 13:53:29','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(20,1,'Add Group','add_group','','2016-05-21 13:53:29','2016-05-21 13:53:29','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(21,1,'Group Sets','group_sets','','2016-05-21 13:53:29','2016-05-21 13:53:29','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(22,1,'Reports','reports','Get data from forms and logs.','2016-05-21 13:53:30','2016-05-21 13:53:30','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(23,1,'Statistics','statistics','View your site activity.','2016-05-21 13:53:30','2016-05-21 13:53:30','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(24,1,'Form Results','forms','Get submission data.','2016-05-21 13:53:30','2016-05-21 13:53:30','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(25,1,'Surveys','surveys','','2016-05-21 13:53:30','2016-05-21 13:53:30','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(26,1,'Logs','logs','','2016-05-21 13:53:30','2016-05-21 13:53:30','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(27,1,'Pages & Themes','pages','Reskin your site.','2016-05-21 13:53:30','2016-05-21 13:53:30','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(28,1,'Themes','themes','Reskin your site.','2016-05-21 13:53:30','2016-05-21 13:53:30','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(29,1,'Add','add','','2016-05-21 13:53:30','2016-05-21 13:53:30','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(30,1,'Inspect','inspect','','2016-05-21 13:53:30','2016-05-21 13:53:30','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(31,1,'Customize','customize','','2016-05-21 13:53:30','2016-05-21 13:53:30','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(32,1,'Page Types','types','What goes in your site.','2016-05-21 13:53:30','2016-05-21 13:53:30','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(33,1,'Add Page Type','add','Add page types to your site.','2016-05-21 13:53:30','2016-05-21 13:53:30','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(34,1,'Attributes','attributes','','2016-05-21 13:53:30','2016-05-21 13:53:30','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(35,1,'Single Pages','single','','2016-05-21 13:53:30','2016-05-21 13:53:30','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(36,1,'Workflow','workflow','','2016-05-21 13:53:30','2016-05-21 13:53:30','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(37,1,'Workflow List','list','','2016-05-21 13:53:30','2016-05-21 13:53:30','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(38,1,'Waiting for Me','me','','2016-05-21 13:53:30','2016-05-21 13:53:30','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(39,1,'Stacks & Blocks','blocks','Manage sitewide content and administer block types.','2016-05-21 13:53:30','2016-05-21 13:53:30','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(40,1,'Stacks','stacks','Share content across your site.','2016-05-21 13:53:30','2016-05-21 13:53:30','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(41,1,'Block & Stack Permissions','permissions','Control who can add blocks and stacks on your site.','2016-05-21 13:53:30','2016-05-21 13:53:30','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(42,1,'Stack List','list','','2016-05-21 13:53:30','2016-05-21 13:53:30','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(43,1,'Block Types','types','Manage the installed block types in your site.','2016-05-21 13:53:30','2016-05-21 13:53:30','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(44,1,'Extend concrete5','extend','Connect to the concrete5 marketplace, install custom add-ons, and download updates for marketplace add-ons and themes.','2016-05-21 13:53:30','2016-05-21 13:53:30','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(45,1,'Dashboard','news','','2016-05-21 13:53:30','2016-05-21 13:53:30','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(46,1,'Add Functionality','install','Install add-ons & themes.','2016-05-21 13:53:30','2016-05-21 13:53:30','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(47,1,'Update Add-Ons','update','Update your installed packages.','2016-05-21 13:53:30','2016-05-21 13:53:30','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(48,1,'Connect to the Community','connect','Connect to the concrete5 community.','2016-05-21 13:53:30','2016-05-21 13:53:30','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(49,1,'Get More Themes','themes','Download themes from concrete5.org.','2016-05-21 13:53:30','2016-05-21 13:53:30','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(50,1,'Get More Add-Ons','add-ons','Download add-ons from concrete5.org.','2016-05-21 13:53:30','2016-05-21 13:53:30','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(51,1,'System & Settings','system','Secure and setup your site.','2016-05-21 13:53:30','2016-05-21 13:53:30','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(52,1,'Basics','basics','Basic information about your website.','2016-05-21 13:53:30','2016-05-21 13:53:30','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(53,1,'Site Name','site_name','','2016-05-21 13:53:30','2016-05-21 13:53:30','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(54,1,'Bookmark Icons','icons','Bookmark icon and mobile home screen icon setup.','2016-05-21 13:53:30','2016-05-21 13:53:30','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(55,1,'Rich Text Editor','editor','','2016-05-21 13:53:30','2016-05-21 13:53:30','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(56,1,'Languages','multilingual','','2016-05-21 13:53:30','2016-05-21 13:53:30','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(57,1,'Time Zone','timezone','','2016-05-21 13:53:30','2016-05-21 13:53:30','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(58,1,'Interface Preferences','interface','','2016-05-21 13:53:30','2016-05-21 13:53:30','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(59,1,'SEO & Statistics','seo','Enable pretty URLs, statistics and tracking codes.','2016-05-21 13:53:30','2016-05-21 13:53:30','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(60,1,'Pretty URLs','urls','','2016-05-21 13:53:30','2016-05-21 13:53:30','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(61,1,'Bulk SEO Updater','bulk_seo_tool','','2016-05-21 13:53:30','2016-05-21 13:53:30','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(62,1,'Tracking Codes','tracking_codes','','2016-05-21 13:53:30','2016-05-21 13:53:30','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(63,1,'Excluded URL Word List','excluded','','2016-05-21 13:53:30','2016-05-21 13:53:30','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(64,1,'Statistics','statistics','','2016-05-21 13:53:31','2016-05-21 13:53:31','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(65,1,'Search Index','search_index','','2016-05-21 13:53:31','2016-05-21 13:53:31','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(66,1,'Optimization','optimization','Keep your site running well.','2016-05-21 13:53:31','2016-05-21 13:53:31','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(67,1,'Cache & Speed Settings','cache','','2016-05-21 13:53:31','2016-05-21 13:53:31','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(68,1,'Clear Cache','clear_cache','','2016-05-21 13:53:31','2016-05-21 13:53:31','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(69,1,'Automated Jobs','jobs','','2016-05-21 13:53:31','2016-05-21 13:53:31','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(70,1,'Permissions & Access','permissions','Control who sees and edits your site.','2016-05-21 13:53:31','2016-05-21 13:53:31','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(71,1,'Site Access','site','','2016-05-21 13:53:31','2016-05-21 13:53:31','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(72,1,'File Manager Permissions','files','','2016-05-21 13:53:31','2016-05-21 13:53:31','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(73,1,'Allowed File Types','file_types','','2016-05-21 13:53:31','2016-05-21 13:53:31','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(74,1,'Task Permissions','tasks','','2016-05-21 13:53:31','2016-05-21 13:53:31','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(75,1,'User Permissions','users','','2016-05-21 13:53:31','2016-05-21 13:53:31','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(76,1,'Advanced Permissions','advanced','','2016-05-21 13:53:31','2016-05-21 13:53:31','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(77,1,'IP Blacklist','ip_blacklist','','2016-05-21 13:53:31','2016-05-21 13:53:31','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(78,1,'Captcha Setup','captcha','','2016-05-21 13:53:31','2016-05-21 13:53:31','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(79,1,'Spam Control','antispam','','2016-05-21 13:53:31','2016-05-21 13:53:31','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(80,1,'Maintenance Mode','maintenance_mode','','2016-05-21 13:53:31','2016-05-21 13:53:31','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(81,1,'Login & Registration','registration','Change login behaviors and setup public profiles.','2016-05-21 13:53:31','2016-05-21 13:53:31','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(82,1,'Login Destination','postlogin','','2016-05-21 13:53:31','2016-05-21 13:53:31','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(83,1,'Public Profiles','profiles','','2016-05-21 13:53:31','2016-05-21 13:53:31','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(84,1,'Public Registration','public_registration','','2016-05-21 13:53:31','2016-05-21 13:53:31','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(85,1,'Email','mail','Control how your site send and processes mail.','2016-05-21 13:53:31','2016-05-21 13:53:31','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(86,1,'SMTP Method','method','','2016-05-21 13:53:31','2016-05-21 13:53:31','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(87,1,'Test Mail Settings','test_settings','','2016-05-21 13:53:31','2016-05-21 13:53:31','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(88,1,'Email Importers','importers','','2016-05-21 13:53:31','2016-05-21 13:53:31','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(89,1,'Attributes','attributes','Setup attributes for pages, users, files and more.','2016-05-21 13:53:31','2016-05-21 13:53:31','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(90,1,'Sets','sets','Group attributes into sets for easier organization','2016-05-21 13:53:31','2016-05-21 13:53:31','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(91,1,'Types','types','Choose which attribute types are available for different items.','2016-05-21 13:53:31','2016-05-21 13:53:31','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(92,1,'Environment','environment','Advanced settings for web developers.','2016-05-21 13:53:31','2016-05-21 13:53:31','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(93,1,'Environment Information','info','','2016-05-21 13:53:31','2016-05-21 13:53:31','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(94,1,'Debug Settings','debug','','2016-05-21 13:53:31','2016-05-21 13:53:31','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(95,1,'Logging Settings','logging','','2016-05-21 13:53:31','2016-05-21 13:53:31','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(96,1,'File Storage Locations','file_storage_locations','','2016-05-21 13:53:31','2016-05-21 13:53:31','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(97,1,'Proxy Server','proxy','','2016-05-21 13:53:31','2016-05-21 13:53:31','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(98,1,'Backup & Restore','backup_restore','Backup or restore your website.','2016-05-21 13:53:31','2016-05-21 13:53:31','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(99,1,'Backup Database','backup','','2016-05-21 13:53:31','2016-05-21 13:53:31','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(100,1,'Update concrete5','update','','2016-05-21 13:53:31','2016-05-21 13:53:31','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(101,1,'Database XML','database','','2016-05-21 13:53:31','2016-05-21 13:53:31','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(102,1,'Composer','composer','','2016-05-21 13:53:32','2016-05-21 13:53:32','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(103,1,'',NULL,NULL,'2016-05-21 13:53:32','2016-05-21 13:53:32','Initial Version',1,0,NULL,NULL,0,1,NULL)
 ,(104,1,'',NULL,NULL,'2016-05-21 13:53:32','2016-05-21 13:53:32','Initial Version',1,0,NULL,NULL,0,2,NULL)
 ,(105,1,'',NULL,NULL,'2016-05-21 13:53:32','2016-05-21 13:53:32','Initial Version',1,0,NULL,NULL,0,3,NULL)
 ,(106,1,'Welcome to concrete5','welcome','Learn about how to use concrete5, how to develop for concrete5, and get general help.','2016-05-21 13:53:32','2016-05-21 13:53:32','Initial Version',1,0,1,NULL,5,3,NULL)
 ,(107,1,'Customize Dashboard Home','home','','2016-05-21 13:53:32','2016-05-21 13:53:32','Initial Version',1,0,1,NULL,5,2,NULL)
 ,(108,1,'Drafts','!drafts','','2016-05-21 13:53:34','2016-05-21 13:53:34','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(109,1,'Trash','!trash','','2016-05-21 13:53:34','2016-05-21 13:53:34','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(110,1,'Stacks','!stacks','','2016-05-21 13:53:34','2016-05-21 13:53:34','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(111,1,'Login','login','','2016-05-21 13:53:34','2016-05-21 13:53:34','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(112,1,'Register','register','','2016-05-21 13:53:34','2016-05-21 13:53:34','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(113,1,'Profile','profile','','2016-05-21 13:53:34','2016-05-21 13:53:34','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(114,1,'Edit','edit','','2016-05-21 13:53:34','2016-05-21 13:53:34','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(115,1,'Avatar','avatar','','2016-05-21 13:53:34','2016-05-21 13:53:34','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(116,1,'Messages','messages','','2016-05-21 13:53:34','2016-05-21 13:53:34','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(117,1,'Friends','friends','','2016-05-21 13:53:34','2016-05-21 13:53:34','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(118,1,'Page Not Found','page_not_found','','2016-05-21 13:53:34','2016-05-21 13:53:34','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(119,1,'Page Forbidden','page_forbidden','','2016-05-21 13:53:34','2016-05-21 13:53:34','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(120,1,'Download File','download_file','','2016-05-21 13:53:34','2016-05-21 13:53:34','Initial Version',1,0,1,NULL,5,0,NULL)
 ,(121,1,'',NULL,NULL,'2016-05-21 13:53:35','2016-05-21 13:53:35','Initial Version',1,0,NULL,NULL,0,4,NULL)
 ,(122,1,'Badges','badges',NULL,'2016-05-29 18:14:53','2016-05-29 18:14:53','Initial Version',0,0,1,NULL,5,1,NULL)
 ,(122,2,'Badges','badges',NULL,'2016-05-29 18:14:53','2016-06-04 15:47:21','New Version 2',0,0,1,1,5,1,NULL)
 ,(122,3,'Badges','badges',NULL,'2016-05-29 18:14:53','2016-06-04 15:47:38','New Version 3',0,0,1,1,5,1,NULL)
 ,(122,4,'Badges','badges',NULL,'2016-05-29 18:14:53','2016-06-04 15:47:49','New Version 4',0,0,1,1,5,1,NULL)
 ,(122,5,'Badges','badges',NULL,'2016-05-29 18:14:53','2016-06-04 15:48:00','New Version 5',0,0,1,1,5,1,NULL)
 ,(122,6,'Badges','badges',NULL,'2016-05-29 18:14:53','2016-06-04 15:48:16','New Version 6',1,0,1,1,5,1,NULL)
 ,(123,1,'Map','map',NULL,'2016-05-29 18:14:53','2016-05-29 18:14:53','Initial Version',1,0,1,NULL,5,1,NULL)
 ,(124,1,'The House & Gardens','house-and-gardens','','2016-05-29 18:45:00','2016-05-29 18:46:08','Initial Version',0,0,1,1,5,4,NULL)
 ,(124,2,'The House & Gardens','house-and-gardens','','2016-05-29 18:45:00','2016-05-30 17:43:17','Version 2',1,0,1,1,5,4,NULL)
 ,(125,1,'Bedrooms','bedrooms','','2016-05-29 18:46:00','2016-05-29 18:46:21','Initial Version',0,0,1,1,5,4,NULL)
 ,(125,2,'Bedrooms','bedrooms','','2016-05-29 18:46:00','2016-05-30 17:48:08','Version 2',0,0,1,1,5,4,NULL)
 ,(125,3,'Bedrooms','bedrooms','','2016-05-29 18:46:00','2016-05-30 17:56:43','Version 3',0,0,1,1,5,5,NULL)
 ,(125,4,'Bedrooms','bedrooms','','2016-05-29 18:46:00','2016-05-30 18:28:25','Version 4',0,0,1,1,5,5,NULL)
 ,(125,5,'Bedrooms','bedrooms','','2016-05-29 18:46:00','2016-06-01 22:18:39','Version 5',0,0,1,1,5,5,NULL)
 ,(125,6,'Bedrooms','bedrooms','','2016-05-29 18:46:00','2016-06-01 22:19:40','Version 6',0,0,1,1,5,5,NULL)
 ,(125,7,'Bedrooms','bedrooms','','2016-05-29 18:46:00','2016-06-02 21:36:43','Version 7',0,0,1,1,5,5,NULL)
 ,(125,8,'Bedrooms','bedrooms','','2016-05-29 18:46:00','2016-06-02 21:58:41','Version 8',0,0,1,1,5,5,NULL)
 ,(125,9,'Bedrooms','bedrooms','','2016-05-29 18:46:00','2016-06-04 14:57:39','Version 9',0,0,1,1,5,5,NULL)
 ,(125,10,'Bedrooms','bedrooms','','2016-05-29 18:46:00','2016-06-04 15:47:21','Version 10',1,0,1,1,5,5,NULL)
 ,(126,1,'Eating With Us','eating-us','','2016-05-29 18:46:00','2016-05-29 18:46:38','Initial Version',0,0,1,1,5,4,NULL)
 ,(126,2,'Eating With Us','eating-us','','2016-05-29 18:46:00','2016-05-29 18:46:56','New Version 2',0,0,1,1,5,4,NULL)
 ,(126,3,'Eating With Us','eating-us','','2016-05-29 18:46:00','2016-06-04 15:12:48','Version 3',1,0,1,1,5,6,NULL)
 ,(127,1,'Tea Room','tea-room','','2016-05-29 18:47:00','2016-05-29 18:47:12','Initial Version',1,0,1,1,5,4,NULL)
 ,(128,1,'Events','events','','2016-05-29 18:47:00','2016-05-29 18:47:22','Initial Version',0,0,1,1,5,4,NULL)
 ,(128,2,'Events','events','','2016-05-29 18:47:00','2016-06-04 15:22:59','Version 2',1,0,1,1,5,6,NULL)
 ,(129,1,'Local Area','local-area','','2016-05-29 18:47:00','2016-05-29 18:47:30','Initial Version',0,0,1,1,5,4,NULL)
 ,(129,2,'Local Area','local-area','','2016-05-29 18:47:00','2016-06-04 15:28:21','Version 2',0,0,1,1,5,5,NULL)
 ,(129,3,'Local Area','local-area','','2016-05-29 18:47:00','2016-06-04 15:31:33','Version 3',1,0,1,1,5,5,NULL)
 ,(130,1,'Contact & Find Us','contact-and-find-us','','2016-05-29 18:47:00','2016-05-29 18:47:55','Initial Version',0,0,1,1,5,4,NULL)
 ,(130,2,'Contact & Find Us','contact-and-find-us','','2016-05-29 18:47:00','2016-06-04 15:38:28','Version 2',0,0,1,1,5,5,NULL)
 ,(130,3,'Contact & Find Us','contact-and-find-us','','2016-05-29 18:47:00','2016-06-04 15:43:13','Version 3',0,0,1,1,5,5,NULL)
 ,(130,4,'Contact & Find Us','contact-and-find-us','','2016-05-29 18:47:00','2016-06-04 15:43:35','Version 4',1,0,1,1,5,5,NULL)
 ,(131,1,'',NULL,NULL,'2016-05-30 17:56:29','2016-05-30 17:56:29','Initial Version',1,0,NULL,NULL,0,5,NULL)
 ,(132,1,'',NULL,NULL,'2016-06-04 15:12:37','2016-06-04 15:12:37','Initial Version',1,0,NULL,NULL,0,6,NULL);

DROP TABLE IF EXISTS Collections;

CREATE TABLE IF NOT EXISTS `Collections` (
  `cID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cDateAdded` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `cDateModified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `cHandle` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`cID`),
  KEY `cDateModified` (`cDateModified`),
  KEY `cDateAdded` (`cDateAdded`)
) ENGINE=InnoDB AUTO_INCREMENT=133 DEFAULT CHARSET=utf8;

INSERT INTO Collections VALUES(1,'2016-05-21 13:53:25','2016-05-30 17:18:09','home')
 ,(2,'2016-05-21 13:53:29','2016-05-21 13:53:29','dashboard')
 ,(3,'2016-05-21 13:53:29','2016-05-21 13:53:29','composer')
 ,(4,'2016-05-21 13:53:29','2016-05-21 13:53:29','write')
 ,(5,'2016-05-21 13:53:29','2016-05-21 13:53:29','drafts')
 ,(6,'2016-05-21 13:53:29','2016-05-21 13:53:29','sitemap')
 ,(7,'2016-05-21 13:53:29','2016-05-21 13:53:29','full')
 ,(8,'2016-05-21 13:53:29','2016-05-21 13:53:29','explore')
 ,(9,'2016-05-21 13:53:29','2016-05-21 13:53:29','search')
 ,(10,'2016-05-21 13:53:29','2016-05-21 13:53:29','files')
 ,(11,'2016-05-21 13:53:29','2016-05-21 13:53:29','search')
 ,(12,'2016-05-21 13:53:29','2016-05-21 13:53:29','attributes')
 ,(13,'2016-05-21 13:53:29','2016-05-21 13:53:29','sets')
 ,(14,'2016-05-21 13:53:29','2016-05-21 13:53:29','add_set')
 ,(15,'2016-05-21 13:53:29','2016-05-21 13:53:29','users')
 ,(16,'2016-05-21 13:53:29','2016-05-21 13:53:29','search')
 ,(17,'2016-05-21 13:53:29','2016-05-21 13:53:29','groups')
 ,(18,'2016-05-21 13:53:29','2016-05-21 13:53:29','attributes')
 ,(19,'2016-05-21 13:53:29','2016-05-21 13:53:29','add')
 ,(20,'2016-05-21 13:53:29','2016-05-21 13:53:29','add_group')
 ,(21,'2016-05-21 13:53:29','2016-05-21 13:53:29','group_sets')
 ,(22,'2016-05-21 13:53:30','2016-05-21 13:53:30','reports')
 ,(23,'2016-05-21 13:53:30','2016-05-21 13:53:30','statistics')
 ,(24,'2016-05-21 13:53:30','2016-05-21 13:53:30','forms')
 ,(25,'2016-05-21 13:53:30','2016-05-21 13:53:30','surveys')
 ,(26,'2016-05-21 13:53:30','2016-05-21 13:53:30','logs')
 ,(27,'2016-05-21 13:53:30','2016-05-21 13:53:30','pages')
 ,(28,'2016-05-21 13:53:30','2016-05-21 13:53:30','themes')
 ,(29,'2016-05-21 13:53:30','2016-05-21 13:53:30','add')
 ,(30,'2016-05-21 13:53:30','2016-05-21 13:53:30','inspect')
 ,(31,'2016-05-21 13:53:30','2016-05-21 13:53:30','customize')
 ,(32,'2016-05-21 13:53:30','2016-05-21 13:53:30','types')
 ,(33,'2016-05-21 13:53:30','2016-05-21 13:53:30','add')
 ,(34,'2016-05-21 13:53:30','2016-05-21 13:53:30','attributes')
 ,(35,'2016-05-21 13:53:30','2016-05-21 13:53:30','single')
 ,(36,'2016-05-21 13:53:30','2016-05-21 13:53:30','workflow')
 ,(37,'2016-05-21 13:53:30','2016-05-21 13:53:30','list')
 ,(38,'2016-05-21 13:53:30','2016-05-21 13:53:30','me')
 ,(39,'2016-05-21 13:53:30','2016-05-21 13:53:30','blocks')
 ,(40,'2016-05-21 13:53:30','2016-05-21 13:53:30','stacks')
 ,(41,'2016-05-21 13:53:30','2016-05-21 13:53:30','permissions')
 ,(42,'2016-05-21 13:53:30','2016-05-21 13:53:30','list')
 ,(43,'2016-05-21 13:53:30','2016-05-21 13:53:30','types')
 ,(44,'2016-05-21 13:53:30','2016-05-21 13:53:30','extend')
 ,(45,'2016-05-21 13:53:30','2016-05-21 13:53:30','news')
 ,(46,'2016-05-21 13:53:30','2016-05-21 13:53:30','install')
 ,(47,'2016-05-21 13:53:30','2016-05-21 13:53:30','update')
 ,(48,'2016-05-21 13:53:30','2016-05-21 13:53:30','connect')
 ,(49,'2016-05-21 13:53:30','2016-05-21 13:53:30','themes')
 ,(50,'2016-05-21 13:53:30','2016-05-21 13:53:30','add-ons')
 ,(51,'2016-05-21 13:53:30','2016-05-21 13:53:30','system')
 ,(52,'2016-05-21 13:53:30','2016-05-21 13:53:30','basics')
 ,(53,'2016-05-21 13:53:30','2016-05-21 13:53:30','site_name')
 ,(54,'2016-05-21 13:53:30','2016-05-21 13:53:30','icons')
 ,(55,'2016-05-21 13:53:30','2016-05-21 13:53:30','editor')
 ,(56,'2016-05-21 13:53:30','2016-05-21 13:53:30','multilingual')
 ,(57,'2016-05-21 13:53:30','2016-05-21 13:53:30','timezone')
 ,(58,'2016-05-21 13:53:30','2016-05-21 13:53:30','interface')
 ,(59,'2016-05-21 13:53:30','2016-05-21 13:53:30','seo')
 ,(60,'2016-05-21 13:53:30','2016-05-21 13:53:30','urls')
 ,(61,'2016-05-21 13:53:30','2016-05-21 13:53:30','bulk_seo_tool')
 ,(62,'2016-05-21 13:53:30','2016-05-21 13:53:30','tracking_codes')
 ,(63,'2016-05-21 13:53:30','2016-05-21 13:53:30','excluded')
 ,(64,'2016-05-21 13:53:31','2016-05-21 13:53:31','statistics')
 ,(65,'2016-05-21 13:53:31','2016-05-21 13:53:31','search_index')
 ,(66,'2016-05-21 13:53:31','2016-05-21 13:53:31','optimization')
 ,(67,'2016-05-21 13:53:31','2016-05-21 13:53:31','cache')
 ,(68,'2016-05-21 13:53:31','2016-05-21 13:53:31','clear_cache')
 ,(69,'2016-05-21 13:53:31','2016-05-21 13:53:31','jobs')
 ,(70,'2016-05-21 13:53:31','2016-05-21 13:53:31','permissions')
 ,(71,'2016-05-21 13:53:31','2016-05-21 13:53:31','site')
 ,(72,'2016-05-21 13:53:31','2016-05-21 13:53:31','files')
 ,(73,'2016-05-21 13:53:31','2016-05-21 13:53:31','file_types')
 ,(74,'2016-05-21 13:53:31','2016-05-21 13:53:31','tasks')
 ,(75,'2016-05-21 13:53:31','2016-05-21 13:53:31','users')
 ,(76,'2016-05-21 13:53:31','2016-05-21 13:53:31','advanced')
 ,(77,'2016-05-21 13:53:31','2016-05-21 13:53:31','ip_blacklist')
 ,(78,'2016-05-21 13:53:31','2016-05-21 13:53:31','captcha')
 ,(79,'2016-05-21 13:53:31','2016-05-21 13:53:31','antispam')
 ,(80,'2016-05-21 13:53:31','2016-05-21 13:53:31','maintenance_mode')
 ,(81,'2016-05-21 13:53:31','2016-05-21 13:53:31','registration')
 ,(82,'2016-05-21 13:53:31','2016-05-21 13:53:31','postlogin')
 ,(83,'2016-05-21 13:53:31','2016-05-21 13:53:31','profiles')
 ,(84,'2016-05-21 13:53:31','2016-05-21 13:53:31','public_registration')
 ,(85,'2016-05-21 13:53:31','2016-05-21 13:53:31','mail')
 ,(86,'2016-05-21 13:53:31','2016-05-21 13:53:31','method')
 ,(87,'2016-05-21 13:53:31','2016-05-21 13:53:31','test_settings')
 ,(88,'2016-05-21 13:53:31','2016-05-21 13:53:31','importers')
 ,(89,'2016-05-21 13:53:31','2016-05-21 13:53:31','attributes')
 ,(90,'2016-05-21 13:53:31','2016-05-21 13:53:31','sets')
 ,(91,'2016-05-21 13:53:31','2016-05-21 13:53:31','types')
 ,(92,'2016-05-21 13:53:31','2016-05-21 13:53:31','environment')
 ,(93,'2016-05-21 13:53:31','2016-05-21 13:53:31','info')
 ,(94,'2016-05-21 13:53:31','2016-05-21 13:53:31','debug')
 ,(95,'2016-05-21 13:53:31','2016-05-21 13:53:31','logging')
 ,(96,'2016-05-21 13:53:31','2016-05-21 13:53:31','file_storage_locations')
 ,(97,'2016-05-21 13:53:31','2016-05-21 13:53:31','proxy')
 ,(98,'2016-05-21 13:53:31','2016-05-21 13:53:31','backup_restore')
 ,(99,'2016-05-21 13:53:31','2016-05-21 13:53:31','backup')
 ,(100,'2016-05-21 13:53:31','2016-05-21 13:53:31','update')
 ,(101,'2016-05-21 13:53:31','2016-05-21 13:53:32','database')
 ,(102,'2016-05-21 13:53:32','2016-05-21 13:53:32','composer')
 ,(103,'2016-05-21 13:53:32','2016-05-21 13:53:32',NULL)
 ,(104,'2016-05-21 13:53:32','2016-05-21 13:53:32',NULL)
 ,(105,'2016-05-21 13:53:32','2016-05-21 13:53:32',NULL)
 ,(106,'2016-05-21 13:53:32','2016-05-21 13:53:32','welcome')
 ,(107,'2016-05-21 13:53:32','2016-05-21 13:53:32','home')
 ,(108,'2016-05-21 13:53:34','2016-05-21 13:53:34','!drafts')
 ,(109,'2016-05-21 13:53:34','2016-05-21 13:53:34','!trash')
 ,(110,'2016-05-21 13:53:34','2016-05-21 13:53:34','!stacks')
 ,(111,'2016-05-21 13:53:34','2016-05-21 13:53:34','login')
 ,(112,'2016-05-21 13:53:34','2016-05-21 13:53:34','register')
 ,(113,'2016-05-21 13:53:34','2016-05-21 13:53:34','profile')
 ,(114,'2016-05-21 13:53:34','2016-05-21 13:53:34','edit')
 ,(115,'2016-05-21 13:53:34','2016-05-21 13:53:34','avatar')
 ,(116,'2016-05-21 13:53:34','2016-05-21 13:53:34','messages')
 ,(117,'2016-05-21 13:53:34','2016-05-21 13:53:34','friends')
 ,(118,'2016-05-21 13:53:34','2016-05-21 13:53:34','page_not_found')
 ,(119,'2016-05-21 13:53:34','2016-05-21 13:53:34','page_forbidden')
 ,(120,'2016-05-21 13:53:34','2016-05-21 13:53:34','download_file')
 ,(121,'2016-05-21 13:53:35','2016-05-21 13:53:35',NULL)
 ,(122,'2016-05-29 18:14:53','2016-06-04 15:48:21','badges')
 ,(123,'2016-05-29 18:14:53','2016-05-29 18:14:53','map')
 ,(124,'2016-05-29 18:46:08','2016-05-30 17:45:36','house-and-gardens')
 ,(125,'2016-05-29 18:46:21','2016-06-04 15:48:21','bedrooms')
 ,(126,'2016-05-29 18:46:38','2016-06-04 15:16:45','eating-us')
 ,(127,'2016-05-29 18:47:12','2016-05-29 18:47:12','tea-room')
 ,(128,'2016-05-29 18:47:22','2016-06-04 15:27:43','events')
 ,(129,'2016-05-29 18:47:30','2016-06-04 15:34:11','local-area')
 ,(130,'2016-05-29 18:47:55','2016-06-04 15:43:40','contact-and-find-us')
 ,(131,'2016-05-30 17:56:29','2016-05-30 17:56:29',NULL)
 ,(132,'2016-06-04 15:12:37','2016-06-04 15:12:37',NULL);

DROP TABLE IF EXISTS ComposerContentLayout;

CREATE TABLE IF NOT EXISTS `ComposerContentLayout` (
  `cclID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bID` int(10) unsigned NOT NULL DEFAULT '0',
  `akID` int(10) unsigned NOT NULL DEFAULT '0',
  `displayOrder` int(10) unsigned NOT NULL DEFAULT '0',
  `ctID` int(10) unsigned NOT NULL DEFAULT '0',
  `ccFilename` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`cclID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS ComposerDrafts;

CREATE TABLE IF NOT EXISTS `ComposerDrafts` (
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `cpPublishParentID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS ComposerTypes;

CREATE TABLE IF NOT EXISTS `ComposerTypes` (
  `ctID` int(10) unsigned NOT NULL DEFAULT '0',
  `ctComposerPublishPageMethod` varchar(64) NOT NULL DEFAULT 'CHOOSE',
  `ctComposerPublishPageTypeID` int(10) unsigned NOT NULL DEFAULT '0',
  `ctComposerPublishPageParentID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ctID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS Config;

CREATE TABLE IF NOT EXISTS `Config` (
  `cfKey` varchar(64) NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `cfValue` longtext,
  `uID` int(10) unsigned NOT NULL DEFAULT '0',
  `pkgID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cfKey`,`uID`),
  KEY `uID` (`uID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO Config VALUES('ACCESS_ENTITY_UPDATED','2016-05-30 13:59:39','1464609579',0,0)
 ,('ANTISPAM_LOG_SPAM','2016-05-21 13:53:34','1',0,0)
 ,('APP_VERSION_LATEST','2016-06-04 14:56:54','5.6.3.4',0,0)
 ,('DO_PAGE_REINDEX_CHECK','2016-06-04 15:48:22','0',0,0)
 ,('ENABLE_BLOCK_CACHE','2016-05-21 13:53:34','1',0,0)
 ,('ENABLE_LOG_EMAILS','2016-05-21 13:53:34','1',0,0)
 ,('ENABLE_LOG_ERRORS','2016-05-21 13:53:34','1',0,0)
 ,('ENABLE_MARKETPLACE_SUPPORT','2016-05-21 13:53:34','1',0,0)
 ,('ENABLE_OVERRIDE_CACHE','2016-05-21 13:53:34','1',0,0)
 ,('FULL_PAGE_CACHE_GLOBAL','2016-05-21 13:53:34','0',0,0)
 ,('NEWSFLOW_LAST_VIEWED','2016-06-04 13:56:53','1465045013',1,0)
 ,('SECURITY_TOKEN_ENCRYPTION','2016-05-21 13:53:35','jwcbzSYQZ1LlZvu1V8l208jEDZQDrm9Cr7uA7mQUbjKAY4aWp7SDfOmXMzbjXwqR',0,0)
 ,('SECURITY_TOKEN_JOBS','2016-05-21 13:53:35','MJMhrmKzENTupJnWlbbSbQ65I2y488cMQPtHZVfIbj5We6NKoEqkTcHDmoiUFrVK',0,0)
 ,('SECURITY_TOKEN_VALIDATION','2016-05-21 13:53:35','5jTy0a4Py5JLCtD9ibsDvVGIQ8ALtGNEGUD03uhhqTLSmnFs8RvwjJMFjvT8QhjS',0,0)
 ,('SEEN_INTRODUCTION','2016-05-21 13:53:51','1',0,0)
 ,('SITE','2016-05-21 13:53:35','Lowther House',0,0)
 ,('SITE_APP_VERSION','2016-05-21 13:53:35','5.6.3.3',0,0)
 ,('SITE_DEBUG_LEVEL','2016-05-21 13:53:34','1',0,0)
 ,('SITE_INSTALLED_APP_VERSION','2016-05-21 13:53:35','5.6.3.3',0,0);

DROP TABLE IF EXISTS CustomStylePresets;

CREATE TABLE IF NOT EXISTS `CustomStylePresets` (
  `cspID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cspName` varchar(255) NOT NULL,
  `csrID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cspID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS CustomStyleRules;

CREATE TABLE IF NOT EXISTS `CustomStyleRules` (
  `csrID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `css_id` varchar(128) DEFAULT NULL,
  `css_class` varchar(128) DEFAULT NULL,
  `css_serialized` text,
  `css_custom` text,
  PRIMARY KEY (`csrID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS DownloadStatistics;

CREATE TABLE IF NOT EXISTS `DownloadStatistics` (
  `dsID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fID` int(10) unsigned NOT NULL,
  `fvID` int(10) unsigned NOT NULL,
  `uID` int(10) unsigned NOT NULL,
  `rcID` int(10) unsigned NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`dsID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS FileAttributeValues;

CREATE TABLE IF NOT EXISTS `FileAttributeValues` (
  `fID` int(10) unsigned NOT NULL DEFAULT '0',
  `fvID` int(10) unsigned NOT NULL DEFAULT '0',
  `akID` int(10) unsigned NOT NULL DEFAULT '0',
  `avID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`fID`,`fvID`,`akID`,`avID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO FileAttributeValues VALUES(1,1,12,121)
 ,(1,1,13,122)
 ,(2,1,12,123)
 ,(2,1,13,124)
 ,(3,1,12,125)
 ,(3,1,13,126)
 ,(4,1,12,128)
 ,(4,1,13,129)
 ,(5,1,12,130)
 ,(5,1,13,131)
 ,(6,1,12,132)
 ,(6,1,13,133)
 ,(7,1,12,134)
 ,(7,1,13,135)
 ,(8,1,12,136)
 ,(8,1,13,137);

DROP TABLE IF EXISTS FilePermissionAssignments;

CREATE TABLE IF NOT EXISTS `FilePermissionAssignments` (
  `fID` int(10) unsigned NOT NULL DEFAULT '0',
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `pkID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`fID`,`paID`,`pkID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS FilePermissionFileTypes;

CREATE TABLE IF NOT EXISTS `FilePermissionFileTypes` (
  `fsID` int(10) unsigned NOT NULL DEFAULT '0',
  `gID` int(10) unsigned NOT NULL DEFAULT '0',
  `uID` int(10) unsigned NOT NULL DEFAULT '0',
  `extension` varchar(32) NOT NULL,
  PRIMARY KEY (`fsID`,`gID`,`uID`,`extension`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS FileSearchIndexAttributes;

CREATE TABLE IF NOT EXISTS `FileSearchIndexAttributes` (
  `fID` int(11) unsigned NOT NULL DEFAULT '0',
  `ak_width` decimal(14,4) DEFAULT '0.0000',
  `ak_height` decimal(14,4) DEFAULT '0.0000',
  `ak_duration` decimal(14,4) DEFAULT '0.0000',
  PRIMARY KEY (`fID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO FileSearchIndexAttributes VALUES(1,630.0000,460.0000,0.0000)
 ,(2,630.0000,460.0000,0.0000)
 ,(3,630.0000,460.0000,0.0000)
 ,(4,80.0000,80.0000,0.0000)
 ,(5,83.0000,118.0000,0.0000)
 ,(6,82.0000,118.0000,0.0000)
 ,(7,82.0000,118.0000,0.0000)
 ,(8,80.0000,80.0000,0.0000);

DROP TABLE IF EXISTS FileSetFiles;

CREATE TABLE IF NOT EXISTS `FileSetFiles` (
  `fsfID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fID` int(10) unsigned NOT NULL,
  `fsID` int(10) unsigned NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fsDisplayOrder` int(10) unsigned NOT NULL,
  PRIMARY KEY (`fsfID`),
  KEY `fID` (`fID`),
  KEY `fsID` (`fsID`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO FileSetFiles VALUES(1,3,1,'2016-05-30 13:59:54',0)
 ,(2,1,1,'2016-05-30 13:59:54',1)
 ,(3,2,1,'2016-05-30 13:59:54',2);

DROP TABLE IF EXISTS FileSetPermissionAssignments;

CREATE TABLE IF NOT EXISTS `FileSetPermissionAssignments` (
  `fsID` int(10) unsigned NOT NULL DEFAULT '0',
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `pkID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`fsID`,`paID`,`pkID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO FileSetPermissionAssignments VALUES(0,44,35)
 ,(0,45,36)
 ,(0,46,37)
 ,(0,47,38)
 ,(0,48,39)
 ,(0,49,40)
 ,(0,50,42)
 ,(0,51,41)
 ,(0,52,43);

DROP TABLE IF EXISTS FileSetPermissionFileTypeAccessList;

CREATE TABLE IF NOT EXISTS `FileSetPermissionFileTypeAccessList` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `permission` varchar(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`paID`,`peID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS FileSetPermissionFileTypeAccessListCustom;

CREATE TABLE IF NOT EXISTS `FileSetPermissionFileTypeAccessListCustom` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `extension` varchar(64) NOT NULL,
  PRIMARY KEY (`paID`,`peID`,`extension`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS FileSetSavedSearches;

CREATE TABLE IF NOT EXISTS `FileSetSavedSearches` (
  `fsID` int(10) unsigned NOT NULL DEFAULT '0',
  `fsSearchRequest` text,
  `fsResultColumns` text,
  PRIMARY KEY (`fsID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS FileSets;

CREATE TABLE IF NOT EXISTS `FileSets` (
  `fsID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fsName` varchar(64) NOT NULL,
  `uID` int(10) unsigned NOT NULL DEFAULT '0',
  `fsType` int(4) NOT NULL,
  `fsOverrideGlobalPermissions` int(4) DEFAULT NULL,
  PRIMARY KEY (`fsID`),
  KEY `fsOverrideGlobalPermissions` (`fsOverrideGlobalPermissions`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO FileSets VALUES(1,'homepage',1,1,0);

DROP TABLE IF EXISTS FileStorageLocations;

CREATE TABLE IF NOT EXISTS `FileStorageLocations` (
  `fslID` int(10) unsigned NOT NULL DEFAULT '0',
  `fslName` varchar(255) NOT NULL,
  `fslDirectory` varchar(255) NOT NULL,
  PRIMARY KEY (`fslID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS FileVersionLog;

CREATE TABLE IF NOT EXISTS `FileVersionLog` (
  `fvlID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fID` int(10) unsigned NOT NULL DEFAULT '0',
  `fvID` int(10) unsigned NOT NULL DEFAULT '0',
  `fvUpdateTypeID` int(3) unsigned NOT NULL DEFAULT '0',
  `fvUpdateTypeAttributeID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`fvlID`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8;

INSERT INTO FileVersionLog VALUES(1,1,1,5,12)
 ,(2,1,1,5,13)
 ,(3,2,1,5,12)
 ,(4,2,1,5,13)
 ,(5,3,1,5,12)
 ,(6,3,1,5,13)
 ,(7,4,1,5,12)
 ,(8,4,1,5,13)
 ,(9,5,1,5,12)
 ,(10,5,1,5,13)
 ,(11,6,1,5,12)
 ,(12,6,1,5,13)
 ,(13,7,1,5,12)
 ,(14,7,1,5,13)
 ,(15,8,1,5,12)
 ,(16,8,1,5,13);

DROP TABLE IF EXISTS FileVersions;

CREATE TABLE IF NOT EXISTS `FileVersions` (
  `fID` int(10) unsigned NOT NULL DEFAULT '0',
  `fvID` int(10) unsigned NOT NULL DEFAULT '0',
  `fvFilename` varchar(255) NOT NULL,
  `fvPrefix` varchar(12) DEFAULT NULL,
  `fvGenericType` int(3) unsigned NOT NULL DEFAULT '0',
  `fvSize` int(20) unsigned NOT NULL DEFAULT '0',
  `fvTitle` varchar(255) DEFAULT NULL,
  `fvDescription` text,
  `fvTags` varchar(255) DEFAULT NULL,
  `fvIsApproved` int(10) unsigned NOT NULL DEFAULT '1',
  `fvDateAdded` datetime DEFAULT NULL,
  `fvApproverUID` int(10) unsigned NOT NULL DEFAULT '0',
  `fvAuthorUID` int(10) unsigned NOT NULL DEFAULT '0',
  `fvActivateDatetime` datetime DEFAULT NULL,
  `fvHasThumbnail1` int(1) NOT NULL DEFAULT '0',
  `fvHasThumbnail2` int(1) NOT NULL DEFAULT '0',
  `fvHasThumbnail3` int(1) NOT NULL DEFAULT '0',
  `fvExtension` varchar(32) DEFAULT NULL,
  `fvType` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`fID`,`fvID`),
  KEY `fvExtension` (`fvType`),
  KEY `fvTitle` (`fvTitle`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO FileVersions VALUES(1,1,'house3.jpg','511464609579',1,271940,'house3.jpg','','',1,'2016-05-30 13:59:39',1,1,'2016-05-30 13:59:39',1,1,0,'jpg',1)
 ,(2,1,'house2.jpg','671464609579',1,201180,'house2.jpg','','',1,'2016-05-30 13:59:39',1,1,'2016-05-30 13:59:39',1,1,0,'jpg',1)
 ,(3,1,'house.jpg','331464609580',1,149617,'house.jpg','','',1,'2016-05-30 13:59:40',1,1,'2016-05-30 13:59:40',1,1,0,'jpg',1)
 ,(4,1,'cyclist-welcome.png','861465048029',1,12054,'cyclist-welcome.png','','',1,'2016-06-04 15:47:09',1,1,'2016-06-04 15:47:09',1,1,0,'png',1)
 ,(5,1,'enjoy-eng-breakfast.png','331465048029',1,12619,'enjoy-eng-breakfast.png','','',1,'2016-06-04 15:47:09',1,1,'2016-06-04 15:47:09',1,1,0,'png',1)
 ,(6,1,'enjoy-eng-silver.png','381465048029',1,11861,'enjoy-eng-silver.png','','',1,'2016-06-04 15:47:09',1,1,'2016-06-04 15:47:09',1,1,0,'png',1)
 ,(7,1,'enjoy-eng-stars.png','661465048030',1,14636,'enjoy-eng-stars.png','','',1,'2016-06-04 15:47:10',1,1,'2016-06-04 15:47:10',1,1,0,'png',1)
 ,(8,1,'walkers-welcome.png','571465048030',1,10610,'walkers-welcome.png','','',1,'2016-06-04 15:47:10',1,1,'2016-06-04 15:47:10',1,1,0,'png',1);

DROP TABLE IF EXISTS Files;

CREATE TABLE IF NOT EXISTS `Files` (
  `fID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fDateAdded` datetime DEFAULT NULL,
  `uID` int(10) unsigned NOT NULL DEFAULT '0',
  `fslID` int(10) unsigned NOT NULL DEFAULT '0',
  `ocID` int(10) unsigned NOT NULL DEFAULT '0',
  `fOverrideSetPermissions` int(1) NOT NULL DEFAULT '0',
  `fPassword` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`fID`,`uID`,`fslID`),
  KEY `fOverrideSetPermissions` (`fOverrideSetPermissions`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

INSERT INTO Files VALUES(1,'2016-05-30 13:59:39',1,0,0,0,NULL)
 ,(2,'2016-05-30 13:59:39',1,0,0,0,NULL)
 ,(3,'2016-05-30 13:59:40',1,0,0,0,NULL)
 ,(4,'2016-06-04 15:47:09',1,0,125,0,NULL)
 ,(5,'2016-06-04 15:47:09',1,0,125,0,NULL)
 ,(6,'2016-06-04 15:47:09',1,0,125,0,NULL)
 ,(7,'2016-06-04 15:47:10',1,0,125,0,NULL)
 ,(8,'2016-06-04 15:47:10',1,0,125,0,NULL);

DROP TABLE IF EXISTS GroupSetGroups;

CREATE TABLE IF NOT EXISTS `GroupSetGroups` (
  `gID` int(10) unsigned NOT NULL DEFAULT '0',
  `gsID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`gID`,`gsID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS GroupSets;

CREATE TABLE IF NOT EXISTS `GroupSets` (
  `gsID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `gsName` varchar(255) DEFAULT NULL,
  `pkgID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`gsID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS Groups;

CREATE TABLE IF NOT EXISTS `Groups` (
  `gID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `gName` varchar(128) NOT NULL,
  `gDescription` varchar(255) NOT NULL,
  `gUserExpirationIsEnabled` int(1) NOT NULL DEFAULT '0',
  `gUserExpirationMethod` varchar(12) DEFAULT NULL,
  `gUserExpirationSetDateTime` datetime DEFAULT NULL,
  `gUserExpirationInterval` int(10) unsigned NOT NULL DEFAULT '0',
  `gUserExpirationAction` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`gID`),
  UNIQUE KEY `gName` (`gName`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO Groups VALUES(1,'Guest','The guest group represents unregistered visitors to your site.',0,NULL,NULL,0,NULL)
 ,(2,'Registered Users','The registered users group represents all user accounts.',0,NULL,NULL,0,NULL)
 ,(3,'Administrators','',0,NULL,NULL,0,NULL);

DROP TABLE IF EXISTS JobSetJobs;

CREATE TABLE IF NOT EXISTS `JobSetJobs` (
  `jsID` int(10) unsigned NOT NULL DEFAULT '0',
  `jID` int(10) unsigned NOT NULL DEFAULT '0',
  `jRunOrder` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`jsID`,`jID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO JobSetJobs VALUES(1,1,0)
 ,(1,3,0)
 ,(1,4,0)
 ,(1,5,0);

DROP TABLE IF EXISTS JobSets;

CREATE TABLE IF NOT EXISTS `JobSets` (
  `jsID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `jsName` varchar(128) NOT NULL,
  `pkgID` int(10) unsigned NOT NULL DEFAULT '0',
  `jDateLastRun` datetime DEFAULT NULL,
  `isScheduled` smallint(1) NOT NULL DEFAULT '0',
  `scheduledInterval` varchar(255) NOT NULL DEFAULT 'days',
  `scheduledValue` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`jsID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO JobSets VALUES(1,'Default',0,NULL,0,'days',0);

DROP TABLE IF EXISTS Jobs;

CREATE TABLE IF NOT EXISTS `Jobs` (
  `jID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `jName` varchar(100) NOT NULL,
  `jDescription` varchar(255) NOT NULL,
  `jDateInstalled` datetime DEFAULT NULL,
  `jDateLastRun` datetime DEFAULT NULL,
  `pkgID` int(10) unsigned NOT NULL DEFAULT '0',
  `jLastStatusText` longtext,
  `jLastStatusCode` smallint(4) NOT NULL DEFAULT '0',
  `jStatus` varchar(14) NOT NULL DEFAULT 'ENABLED',
  `jHandle` varchar(255) NOT NULL,
  `jNotUninstallable` smallint(4) NOT NULL DEFAULT '0',
  `isScheduled` smallint(1) NOT NULL DEFAULT '0',
  `scheduledInterval` varchar(255) NOT NULL DEFAULT 'days',
  `scheduledValue` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`jID`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO Jobs VALUES(1,'Index Search Engine - Updates','Index the site to allow searching to work quickly and accurately. Only reindexes pages that have changed since last indexing.','2016-05-21 13:53:29',NULL,0,NULL,0,'ENABLED','index_search',1,0,'days',0)
 ,(2,'Index Search Engine - All','Empties the page search index and reindexes all pages.','2016-05-21 13:53:29',NULL,0,NULL,0,'ENABLED','index_search_all',1,0,'days',0)
 ,(3,'Generate the sitemap.xml file','Generate the sitemap.xml file that search engines use to crawl your site.','2016-05-21 13:53:29',NULL,0,NULL,0,'ENABLED','generate_sitemap',0,0,'days',0)
 ,(4,'Process Email Posts','Polls an email account and grabs private messages/postings that are sent there..','2016-05-21 13:53:29',NULL,0,NULL,0,'ENABLED','process_email',0,0,'days',0)
 ,(5,'Remove Old Page Versions','Removes all except the 10 most recent page versions for each page.','2016-05-21 13:53:29',NULL,0,NULL,0,'ENABLED','remove_old_page_versions',0,0,'days',0);

DROP TABLE IF EXISTS JobsLog;

CREATE TABLE IF NOT EXISTS `JobsLog` (
  `jlID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `jID` int(10) unsigned NOT NULL,
  `jlMessage` longtext,
  `jlTimestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `jlError` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`jlID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS LayoutPresets;

CREATE TABLE IF NOT EXISTS `LayoutPresets` (
  `lpID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `lpName` varchar(128) NOT NULL,
  `layoutID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`lpID`),
  UNIQUE KEY `layoutID` (`layoutID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS Layouts;

CREATE TABLE IF NOT EXISTS `Layouts` (
  `layoutID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `layout_rows` int(5) NOT NULL DEFAULT '3',
  `layout_columns` int(3) NOT NULL DEFAULT '3',
  `spacing` int(3) NOT NULL DEFAULT '3',
  `breakpoints` varchar(255) NOT NULL DEFAULT '',
  `locked` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`layoutID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS Logs;

CREATE TABLE IF NOT EXISTS `Logs` (
  `logID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `logType` varchar(64) NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `logText` longtext,
  `logUserID` int(10) unsigned DEFAULT NULL,
  `logIsInternal` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`logID`),
  KEY `logType` (`logType`),
  KEY `logIsInternal` (`logIsInternal`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS MailImporters;

CREATE TABLE IF NOT EXISTS `MailImporters` (
  `miID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `miHandle` varchar(64) NOT NULL,
  `miServer` varchar(255) DEFAULT NULL,
  `miUsername` varchar(255) DEFAULT NULL,
  `miPassword` varchar(255) DEFAULT NULL,
  `miEncryption` varchar(32) DEFAULT NULL,
  `miIsEnabled` int(1) NOT NULL DEFAULT '0',
  `miEmail` varchar(255) DEFAULT NULL,
  `miPort` int(10) unsigned NOT NULL DEFAULT '0',
  `pkgID` int(10) unsigned DEFAULT NULL,
  `miConnectionMethod` varchar(8) DEFAULT 'POP',
  PRIMARY KEY (`miID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO MailImporters VALUES(1,'private_message','',NULL,NULL,NULL,0,'',0,0,'POP');

DROP TABLE IF EXISTS MailValidationHashes;

CREATE TABLE IF NOT EXISTS `MailValidationHashes` (
  `mvhID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `miID` int(10) unsigned NOT NULL DEFAULT '0',
  `email` varchar(255) NOT NULL,
  `mHash` varchar(128) NOT NULL,
  `mDateGenerated` int(10) unsigned NOT NULL DEFAULT '0',
  `mDateRedeemed` int(10) unsigned NOT NULL DEFAULT '0',
  `data` text,
  PRIMARY KEY (`mvhID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS Packages;

CREATE TABLE IF NOT EXISTS `Packages` (
  `pkgID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pkgName` varchar(255) NOT NULL,
  `pkgHandle` varchar(64) NOT NULL,
  `pkgDescription` text,
  `pkgDateInstalled` datetime NOT NULL,
  `pkgIsInstalled` tinyint(1) NOT NULL DEFAULT '1',
  `pkgVersion` varchar(32) DEFAULT NULL,
  `pkgAvailableVersion` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`pkgID`),
  UNIQUE KEY `pkgHandle` (`pkgHandle`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO Packages VALUES(1,'Flexslider 2','flex_slider','Flexslider 2 application intergration','2016-05-30 13:33:13',1,'1.0',NULL);

DROP TABLE IF EXISTS PagePaths;

CREATE TABLE IF NOT EXISTS `PagePaths` (
  `ppID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cID` int(10) unsigned DEFAULT '0',
  `cPath` text,
  `ppIsCanonical` varchar(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`ppID`),
  KEY `cID` (`cID`),
  KEY `ppIsCanonical` (`ppIsCanonical`)
) ENGINE=InnoDB AUTO_INCREMENT=149 DEFAULT CHARSET=utf8;

INSERT INTO PagePaths VALUES(1,2,'/dashboard','1')
 ,(2,3,'/dashboard/composer','1')
 ,(3,4,'/dashboard/composer/write','1')
 ,(4,5,'/dashboard/composer/drafts','1')
 ,(5,6,'/dashboard/sitemap','1')
 ,(6,7,'/dashboard/sitemap/full','1')
 ,(7,8,'/dashboard/sitemap/explore','1')
 ,(8,9,'/dashboard/sitemap/search','1')
 ,(9,10,'/dashboard/files','1')
 ,(10,11,'/dashboard/files/search','1')
 ,(11,12,'/dashboard/files/attributes','1')
 ,(12,13,'/dashboard/files/sets','1')
 ,(13,14,'/dashboard/files/add_set','1')
 ,(14,15,'/dashboard/users','1')
 ,(15,16,'/dashboard/users/search','1')
 ,(16,17,'/dashboard/users/groups','1')
 ,(17,18,'/dashboard/users/attributes','1')
 ,(18,19,'/dashboard/users/add','1')
 ,(19,20,'/dashboard/users/add_group','1')
 ,(20,21,'/dashboard/users/group_sets','1')
 ,(21,22,'/dashboard/reports','1')
 ,(22,23,'/dashboard/reports/statistics','1')
 ,(23,24,'/dashboard/reports/forms','1')
 ,(24,25,'/dashboard/reports/surveys','1')
 ,(25,26,'/dashboard/reports/logs','1')
 ,(26,27,'/dashboard/pages','1')
 ,(27,28,'/dashboard/pages/themes','1')
 ,(28,29,'/dashboard/pages/themes/add','1')
 ,(29,30,'/dashboard/pages/themes/inspect','1')
 ,(30,31,'/dashboard/pages/themes/customize','1')
 ,(31,32,'/dashboard/pages/types','1')
 ,(32,33,'/dashboard/pages/types/add','1')
 ,(33,34,'/dashboard/pages/attributes','1')
 ,(34,35,'/dashboard/pages/single','1')
 ,(35,36,'/dashboard/workflow','1')
 ,(36,37,'/dashboard/workflow/list','1')
 ,(37,38,'/dashboard/workflow/me','1')
 ,(38,39,'/dashboard/blocks','1')
 ,(39,40,'/dashboard/blocks/stacks','1')
 ,(40,41,'/dashboard/blocks/permissions','1')
 ,(41,42,'/dashboard/blocks/stacks/list','1')
 ,(42,43,'/dashboard/blocks/types','1')
 ,(43,44,'/dashboard/extend','1')
 ,(44,45,'/dashboard/news','1')
 ,(45,46,'/dashboard/extend/install','1')
 ,(46,47,'/dashboard/extend/update','1')
 ,(47,48,'/dashboard/extend/connect','1')
 ,(48,49,'/dashboard/extend/themes','1')
 ,(49,50,'/dashboard/extend/add-ons','1')
 ,(50,51,'/dashboard/system','1')
 ,(51,52,'/dashboard/system/basics','1')
 ,(52,53,'/dashboard/system/basics/site_name','1')
 ,(53,54,'/dashboard/system/basics/icons','1')
 ,(54,55,'/dashboard/system/basics/editor','1')
 ,(55,56,'/dashboard/system/basics/multilingual','1')
 ,(56,57,'/dashboard/system/basics/timezone','1')
 ,(57,58,'/dashboard/system/basics/interface','1')
 ,(58,59,'/dashboard/system/seo','1')
 ,(59,60,'/dashboard/system/seo/urls','1')
 ,(60,61,'/dashboard/system/seo/bulk_seo_tool','1')
 ,(61,62,'/dashboard/system/seo/tracking_codes','1')
 ,(62,63,'/dashboard/system/seo/excluded','1')
 ,(63,64,'/dashboard/system/seo/statistics','1')
 ,(64,65,'/dashboard/system/seo/search_index','1')
 ,(65,66,'/dashboard/system/optimization','1')
 ,(66,67,'/dashboard/system/optimization/cache','1')
 ,(67,68,'/dashboard/system/optimization/clear_cache','1')
 ,(68,69,'/dashboard/system/optimization/jobs','1')
 ,(69,70,'/dashboard/system/permissions','1')
 ,(70,71,'/dashboard/system/permissions/site','1')
 ,(71,72,'/dashboard/system/permissions/files','1')
 ,(72,73,'/dashboard/system/permissions/file_types','1')
 ,(73,74,'/dashboard/system/permissions/tasks','1')
 ,(74,75,'/dashboard/system/permissions/users','1')
 ,(75,76,'/dashboard/system/permissions/advanced','1')
 ,(76,77,'/dashboard/system/permissions/ip_blacklist','1')
 ,(77,78,'/dashboard/system/permissions/captcha','1')
 ,(78,79,'/dashboard/system/permissions/antispam','1')
 ,(79,80,'/dashboard/system/permissions/maintenance_mode','1')
 ,(80,81,'/dashboard/system/registration','1')
 ,(81,82,'/dashboard/system/registration/postlogin','1')
 ,(82,83,'/dashboard/system/registration/profiles','1')
 ,(83,84,'/dashboard/system/registration/public_registration','1')
 ,(84,85,'/dashboard/system/mail','1')
 ,(85,86,'/dashboard/system/mail/method','1')
 ,(86,87,'/dashboard/system/mail/method/test_settings','1')
 ,(87,88,'/dashboard/system/mail/importers','1')
 ,(88,89,'/dashboard/system/attributes','1')
 ,(89,90,'/dashboard/system/attributes/sets','1')
 ,(90,91,'/dashboard/system/attributes/types','1')
 ,(91,92,'/dashboard/system/environment','1')
 ,(92,93,'/dashboard/system/environment/info','1')
 ,(93,94,'/dashboard/system/environment/debug','1')
 ,(94,95,'/dashboard/system/environment/logging','1')
 ,(95,96,'/dashboard/system/environment/file_storage_locations','1')
 ,(96,97,'/dashboard/system/environment/proxy','1')
 ,(97,98,'/dashboard/system/backup_restore','1')
 ,(98,99,'/dashboard/system/backup_restore/backup','1')
 ,(99,100,'/dashboard/system/backup_restore/update','1')
 ,(100,101,'/dashboard/system/backup_restore/database','1')
 ,(101,102,'/dashboard/pages/types/composer','1')
 ,(102,106,'/dashboard/welcome','1')
 ,(103,107,'/dashboard/home','1')
 ,(104,108,'/!drafts','1')
 ,(105,109,'/!trash','1')
 ,(106,110,'/!stacks','1')
 ,(107,111,'/login','1')
 ,(108,112,'/register','1')
 ,(109,113,'/profile','1')
 ,(110,114,'/profile/edit','1')
 ,(111,115,'/profile/avatar','1')
 ,(112,116,'/profile/messages','1')
 ,(113,117,'/profile/friends','1')
 ,(114,118,'/page_not_found','1')
 ,(115,119,'/page_forbidden','1')
 ,(116,120,'/download_file','1')
 ,(118,123,'/!stacks/map','1')
 ,(123,127,'/tea-room','1')
 ,(127,124,'/house-and-gardens','1')
 ,(136,126,'/eating-us','1')
 ,(137,128,'/events','1')
 ,(139,129,'/local-area','1')
 ,(142,130,'/contact-and-find-us','1')
 ,(143,125,'/bedrooms','1')
 ,(148,122,'/!stacks/badges','1');

DROP TABLE IF EXISTS PagePermissionAssignments;

CREATE TABLE IF NOT EXISTS `PagePermissionAssignments` (
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `pkID` int(10) unsigned NOT NULL DEFAULT '0',
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cID`,`pkID`,`paID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO PagePermissionAssignments VALUES(1,1,53)
 ,(1,2,54)
 ,(1,3,55)
 ,(1,4,56)
 ,(1,5,57)
 ,(1,6,58)
 ,(1,7,59)
 ,(1,8,60)
 ,(1,9,61)
 ,(1,10,62)
 ,(1,11,63)
 ,(1,12,64)
 ,(1,13,65)
 ,(1,14,66)
 ,(1,15,67)
 ,(1,16,68)
 ,(2,1,19)
 ,(2,2,21)
 ,(2,3,20)
 ,(2,4,26)
 ,(2,5,22)
 ,(2,6,23)
 ,(2,7,28)
 ,(2,8,30)
 ,(2,9,32)
 ,(2,10,29)
 ,(2,11,33)
 ,(2,12,34)
 ,(2,13,24)
 ,(2,14,27)
 ,(2,15,25)
 ,(2,16,31)
 ,(42,1,35)
 ,(42,3,36)
 ,(111,1,39)
 ,(111,3,40)
 ,(112,1,41)
 ,(112,3,42);

DROP TABLE IF EXISTS PagePermissionPageTypeAccessList;

CREATE TABLE IF NOT EXISTS `PagePermissionPageTypeAccessList` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `permission` varchar(1) NOT NULL DEFAULT '1',
  `externalLink` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`paID`,`peID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS PagePermissionPageTypeAccessListCustom;

CREATE TABLE IF NOT EXISTS `PagePermissionPageTypeAccessListCustom` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `ctID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`paID`,`peID`,`ctID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS PagePermissionPropertyAccessList;

CREATE TABLE IF NOT EXISTS `PagePermissionPropertyAccessList` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `name` int(1) unsigned DEFAULT '0',
  `publicDateTime` int(1) unsigned DEFAULT '0',
  `uID` int(1) unsigned DEFAULT '0',
  `description` int(1) unsigned DEFAULT '0',
  `paths` int(1) unsigned DEFAULT '0',
  `attributePermission` varchar(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`paID`,`peID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS PagePermissionPropertyAttributeAccessListCustom;

CREATE TABLE IF NOT EXISTS `PagePermissionPropertyAttributeAccessListCustom` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `akID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`paID`,`peID`,`akID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS PagePermissionThemeAccessList;

CREATE TABLE IF NOT EXISTS `PagePermissionThemeAccessList` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `permission` varchar(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`paID`,`peID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS PagePermissionThemeAccessListCustom;

CREATE TABLE IF NOT EXISTS `PagePermissionThemeAccessListCustom` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `ptID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`paID`,`peID`,`ptID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS PageSearchIndex;

CREATE TABLE IF NOT EXISTS `PageSearchIndex` (
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `content` longtext,
  `cName` varchar(255) DEFAULT NULL,
  `cDescription` text,
  `cPath` text,
  `cDatePublic` datetime DEFAULT NULL,
  `cDateLastIndexed` datetime DEFAULT NULL,
  `cDateLastSitemapped` datetime DEFAULT NULL,
  `cRequiresReindex` tinyint(1) unsigned DEFAULT '0',
  PRIMARY KEY (`cID`),
  KEY `cDateLastIndexed` (`cDateLastIndexed`),
  KEY `cDateLastSitemapped` (`cDateLastSitemapped`),
  KEY `cRequiresReindex` (`cRequiresReindex`),
  FULLTEXT KEY `cName` (`cName`),
  FULLTEXT KEY `cDescription` (`cDescription`),
  FULLTEXT KEY `content` (`content`),
  FULLTEXT KEY `content2` (`cName`,`cDescription`,`content`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO PageSearchIndex VALUES(3,'','Composer','Write for your site.','/dashboard/composer','2016-05-21 13:53:29','2016-05-21 13:53:32',NULL,0)
 ,(4,'','Write','','/dashboard/composer/write','2016-05-21 13:53:29','2016-05-21 13:53:32',NULL,0)
 ,(5,'','Drafts','','/dashboard/composer/drafts','2016-05-21 13:53:29','2016-05-21 13:53:32',NULL,0)
 ,(6,'','Sitemap','Whole world at a glance.','/dashboard/sitemap','2016-05-21 13:53:29','2016-05-21 13:53:32',NULL,0)
 ,(7,'','Full Sitemap','','/dashboard/sitemap/full','2016-05-21 13:53:29','2016-05-21 13:53:32',NULL,0)
 ,(8,'','Flat View','','/dashboard/sitemap/explore','2016-05-21 13:53:29','2016-05-21 13:53:32',NULL,0)
 ,(9,'','Page Search','','/dashboard/sitemap/search','2016-05-21 13:53:29','2016-05-21 13:53:32',NULL,0)
 ,(11,'','File Manager','','/dashboard/files/search','2016-05-21 13:53:29','2016-05-21 13:53:32',NULL,0)
 ,(12,'','Attributes','','/dashboard/files/attributes','2016-05-21 13:53:29','2016-05-21 13:53:32',NULL,0)
 ,(13,'','File Sets','','/dashboard/files/sets','2016-05-21 13:53:29','2016-05-21 13:53:32',NULL,0)
 ,(14,'','Add File Set','','/dashboard/files/add_set','2016-05-21 13:53:29','2016-05-21 13:53:32',NULL,0)
 ,(15,'','Members','Add and manage the user accounts and groups on your website.','/dashboard/users','2016-05-21 13:53:29','2016-05-21 13:53:32',NULL,0)
 ,(16,'','Search Users','','/dashboard/users/search','2016-05-21 13:53:29','2016-05-21 13:53:32',NULL,0)
 ,(17,'','User Groups','','/dashboard/users/groups','2016-05-21 13:53:29','2016-05-21 13:53:32',NULL,0)
 ,(18,'','Attributes','','/dashboard/users/attributes','2016-05-21 13:53:29','2016-05-21 13:53:32',NULL,0)
 ,(19,'','Add User','','/dashboard/users/add','2016-05-21 13:53:29','2016-05-21 13:53:32',NULL,0)
 ,(20,'','Add Group','','/dashboard/users/add_group','2016-05-21 13:53:29','2016-05-21 13:53:32',NULL,0)
 ,(21,'','Group Sets','','/dashboard/users/group_sets','2016-05-21 13:53:29','2016-05-21 13:53:32',NULL,0)
 ,(22,'','Reports','Get data from forms and logs.','/dashboard/reports','2016-05-21 13:53:30','2016-05-21 13:53:32',NULL,0)
 ,(23,'','Statistics','View your site activity.','/dashboard/reports/statistics','2016-05-21 13:53:30','2016-05-21 13:53:32',NULL,0)
 ,(24,'','Form Results','Get submission data.','/dashboard/reports/forms','2016-05-21 13:53:30','2016-05-21 13:53:32',NULL,0)
 ,(25,'','Surveys','','/dashboard/reports/surveys','2016-05-21 13:53:30','2016-05-21 13:53:32',NULL,0)
 ,(26,'','Logs','','/dashboard/reports/logs','2016-05-21 13:53:30','2016-05-21 13:53:32',NULL,0)
 ,(28,'','Themes','Reskin your site.','/dashboard/pages/themes','2016-05-21 13:53:30','2016-05-21 13:53:32',NULL,0)
 ,(29,'','Add','','/dashboard/pages/themes/add','2016-05-21 13:53:30','2016-05-21 13:53:32',NULL,0)
 ,(30,'','Inspect','','/dashboard/pages/themes/inspect','2016-05-21 13:53:30','2016-05-21 13:53:32',NULL,0)
 ,(31,'','Customize','','/dashboard/pages/themes/customize','2016-05-21 13:53:30','2016-05-21 13:53:32',NULL,0)
 ,(32,'','Page Types','What goes in your site.','/dashboard/pages/types','2016-05-21 13:53:30','2016-05-21 13:53:32',NULL,0)
 ,(34,'','Attributes','','/dashboard/pages/attributes','2016-05-21 13:53:30','2016-05-21 13:53:32',NULL,0)
 ,(35,'','Single Pages','','/dashboard/pages/single','2016-05-21 13:53:30','2016-05-21 13:53:32',NULL,0)
 ,(36,'','Workflow','','/dashboard/workflow','2016-05-21 13:53:30','2016-05-21 13:53:32',NULL,0)
 ,(37,'','Workflow List','','/dashboard/workflow/list','2016-05-21 13:53:30','2016-05-21 13:53:32',NULL,0)
 ,(38,'','Waiting for Me','','/dashboard/workflow/me','2016-05-21 13:53:30','2016-05-21 13:53:32',NULL,0)
 ,(40,'','Stacks','Share content across your site.','/dashboard/blocks/stacks','2016-05-21 13:53:30','2016-05-21 13:53:32',NULL,0)
 ,(41,'','Block & Stack Permissions','Control who can add blocks and stacks on your site.','/dashboard/blocks/permissions','2016-05-21 13:53:30','2016-05-21 13:53:32',NULL,0)
 ,(42,'','Stack List','','/dashboard/blocks/stacks/list','2016-05-21 13:53:30','2016-05-21 13:53:33',NULL,0)
 ,(43,'','Block Types','Manage the installed block types in your site.','/dashboard/blocks/types','2016-05-21 13:53:30','2016-05-21 13:53:33',NULL,0)
 ,(44,'','Extend concrete5','Connect to the concrete5 marketplace, install custom add-ons, and download updates for marketplace add-ons and themes.','/dashboard/extend','2016-05-21 13:53:30','2016-05-21 13:53:33',NULL,0)
 ,(45,'','Dashboard','','/dashboard/news','2016-05-21 13:53:30','2016-05-21 13:53:33',NULL,0)
 ,(46,'','Add Functionality','Install add-ons & themes.','/dashboard/extend/install','2016-05-21 13:53:30','2016-05-21 13:53:33',NULL,0)
 ,(47,'','Update Add-Ons','Update your installed packages.','/dashboard/extend/update','2016-05-21 13:53:30','2016-05-21 13:53:33',NULL,0)
 ,(48,'','Connect to the Community','Connect to the concrete5 community.','/dashboard/extend/connect','2016-05-21 13:53:30','2016-05-21 13:53:33',NULL,0)
 ,(49,'','Get More Themes','Download themes from concrete5.org.','/dashboard/extend/themes','2016-05-21 13:53:30','2016-05-21 13:53:33',NULL,0)
 ,(50,'','Get More Add-Ons','Download add-ons from concrete5.org.','/dashboard/extend/add-ons','2016-05-21 13:53:30','2016-05-21 13:53:33',NULL,0)
 ,(51,'','System & Settings','Secure and setup your site.','/dashboard/system','2016-05-21 13:53:30','2016-05-21 13:53:33',NULL,0)
 ,(53,'','Site Name','','/dashboard/system/basics/site_name','2016-05-21 13:53:30','2016-05-21 13:53:33',NULL,0)
 ,(54,'','Bookmark Icons','Bookmark icon and mobile home screen icon setup.','/dashboard/system/basics/icons','2016-05-21 13:53:30','2016-05-21 13:53:33',NULL,0)
 ,(55,'','Rich Text Editor','','/dashboard/system/basics/editor','2016-05-21 13:53:30','2016-05-21 13:53:33',NULL,0)
 ,(56,'','Languages','','/dashboard/system/basics/multilingual','2016-05-21 13:53:30','2016-05-21 13:53:33',NULL,0)
 ,(57,'','Time Zone','','/dashboard/system/basics/timezone','2016-05-21 13:53:30','2016-05-21 13:53:33',NULL,0)
 ,(58,'','Interface Preferences','','/dashboard/system/basics/interface','2016-05-21 13:53:30','2016-05-21 13:53:33',NULL,0)
 ,(60,'','Pretty URLs','','/dashboard/system/seo/urls','2016-05-21 13:53:30','2016-05-21 13:53:33',NULL,0)
 ,(61,'','Bulk SEO Updater','','/dashboard/system/seo/bulk_seo_tool','2016-05-21 13:53:30','2016-05-21 13:53:33',NULL,0)
 ,(62,'','Tracking Codes','','/dashboard/system/seo/tracking_codes','2016-05-21 13:53:30','2016-05-21 13:53:33',NULL,0)
 ,(63,'','Excluded URL Word List','','/dashboard/system/seo/excluded','2016-05-21 13:53:30','2016-05-21 13:53:33',NULL,0)
 ,(64,'','Statistics','','/dashboard/system/seo/statistics','2016-05-21 13:53:31','2016-05-21 13:53:33',NULL,0)
 ,(65,'','Search Index','','/dashboard/system/seo/search_index','2016-05-21 13:53:31','2016-05-21 13:53:33',NULL,0)
 ,(67,'','Cache & Speed Settings','','/dashboard/system/optimization/cache','2016-05-21 13:53:31','2016-05-21 13:53:33',NULL,0)
 ,(68,'','Clear Cache','','/dashboard/system/optimization/clear_cache','2016-05-21 13:53:31','2016-05-21 13:53:33',NULL,0)
 ,(69,'','Automated Jobs','','/dashboard/system/optimization/jobs','2016-05-21 13:53:31','2016-05-21 13:53:33',NULL,0)
 ,(71,'','Site Access','','/dashboard/system/permissions/site','2016-05-21 13:53:31','2016-05-21 13:53:33',NULL,0)
 ,(72,'','File Manager Permissions','','/dashboard/system/permissions/files','2016-05-21 13:53:31','2016-05-21 13:53:33',NULL,0)
 ,(73,'','Allowed File Types','','/dashboard/system/permissions/file_types','2016-05-21 13:53:31','2016-05-21 13:53:33',NULL,0)
 ,(74,'','Task Permissions','','/dashboard/system/permissions/tasks','2016-05-21 13:53:31','2016-05-21 13:53:33',NULL,0)
 ,(77,'','IP Blacklist','','/dashboard/system/permissions/ip_blacklist','2016-05-21 13:53:31','2016-05-21 13:53:33',NULL,0)
 ,(78,'','Captcha Setup','','/dashboard/system/permissions/captcha','2016-05-21 13:53:31','2016-05-21 13:53:33',NULL,0)
 ,(79,'','Spam Control','','/dashboard/system/permissions/antispam','2016-05-21 13:53:31','2016-05-21 13:53:33',NULL,0)
 ,(80,'','Maintenance Mode','','/dashboard/system/permissions/maintenance_mode','2016-05-21 13:53:31','2016-05-21 13:53:33',NULL,0)
 ,(82,'','Login Destination','','/dashboard/system/registration/postlogin','2016-05-21 13:53:31','2016-05-21 13:53:33',NULL,0)
 ,(83,'','Public Profiles','','/dashboard/system/registration/profiles','2016-05-21 13:53:31','2016-05-21 13:53:33',NULL,0)
 ,(84,'','Public Registration','','/dashboard/system/registration/public_registration','2016-05-21 13:53:31','2016-05-21 13:53:33',NULL,0)
 ,(85,'','Email','Control how your site send and processes mail.','/dashboard/system/mail','2016-05-21 13:53:31','2016-05-21 13:53:33',NULL,0)
 ,(86,'','SMTP Method','','/dashboard/system/mail/method','2016-05-21 13:53:31','2016-05-21 13:53:33',NULL,0)
 ,(87,'','Test Mail Settings','','/dashboard/system/mail/method/test_settings','2016-05-21 13:53:31','2016-05-21 13:53:33',NULL,0)
 ,(88,'','Email Importers','','/dashboard/system/mail/importers','2016-05-21 13:53:31','2016-05-21 13:53:33',NULL,0)
 ,(89,'','Attributes','Setup attributes for pages, users, files and more.','/dashboard/system/attributes','2016-05-21 13:53:31','2016-05-21 13:53:33',NULL,0)
 ,(90,'','Sets','Group attributes into sets for easier organization','/dashboard/system/attributes/sets','2016-05-21 13:53:31','2016-05-21 13:53:33',NULL,0)
 ,(91,'','Types','Choose which attribute types are available for different items.','/dashboard/system/attributes/types','2016-05-21 13:53:31','2016-05-21 13:53:33',NULL,0)
 ,(92,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0)
 ,(93,'','Environment Information','','/dashboard/system/environment/info','2016-05-21 13:53:31','2016-05-21 13:53:33',NULL,0)
 ,(94,'','Debug Settings','','/dashboard/system/environment/debug','2016-05-21 13:53:31','2016-05-21 13:53:33',NULL,0)
 ,(95,'','Logging Settings','','/dashboard/system/environment/logging','2016-05-21 13:53:31','2016-05-21 13:53:33',NULL,0)
 ,(96,'','File Storage Locations','','/dashboard/system/environment/file_storage_locations','2016-05-21 13:53:31','2016-05-21 13:53:33',NULL,0)
 ,(97,'','Proxy Server','','/dashboard/system/environment/proxy','2016-05-21 13:53:31','2016-05-21 13:53:33',NULL,0)
 ,(98,'','Backup & Restore','Backup or restore your website.','/dashboard/system/backup_restore','2016-05-21 13:53:31','2016-05-21 13:53:33',NULL,0)
 ,(100,'','Update concrete5','','/dashboard/system/backup_restore/update','2016-05-21 13:53:31','2016-05-21 13:53:33',NULL,0)
 ,(101,'','Database XML','','/dashboard/system/backup_restore/database','2016-05-21 13:53:31','2016-05-21 13:53:33',NULL,0)
 ,(106,'	Welcome to concrete5.\n						It\'s easy to edit content and add pages using in-context editing. \n						 \n							Building Your Own Site\n							 Editing with concrete5 is a breeze. Just point and click to make changes. \n							 \n							 Editor\'s Guide \n							  \n							Developing Applications\n							 If you’re comfortable in PHP concrete5 should be a breeze to learn. Take a few moments to understand the architecture. \n							 Developer\'s Guide \n							  \n							Designing Websites\n							 Good with CSS and HTML? You can easily theme anything with concrete5. \n							 \n							 Designer\'s Guide \n							  \n						\n						Business Background\n						 Worried about license structures, white-labeling or why concrete5 is a good choice for your agency? \n						 Executive\'s Guide \n						  ','Welcome to concrete5','Learn about how to use concrete5, how to develop for concrete5, and get general help.','/dashboard/welcome','2016-05-21 13:53:32','2016-05-21 13:53:34',NULL,0)
 ,(107,'','Customize Dashboard Home','','/dashboard/home','2016-05-21 13:53:32','2016-05-21 13:53:34',NULL,0)
 ,(1,'Woodland Bed & Breakfast with tea garden\r\n Lowther House is set at the end of a tree lined drive in a clearing in Pickering Woods. It has a real country feel about it yet is just a ten minute walk down a tree-lined avenue into Pickering Town Centre. \r\n The house is bordered on two sides by Pickering Beck and is part of the Duchy of Lancaster Estate. The North York Moors Railway station is just five minutes away and the track runs past the garden. It’s a lovely sight to see when the steam trains go past – especially if you’re having cake and tea in the garden at the same time!! \r\n The house sits between the North York Moors National Park - which you can walk into from our gate - and the Yorkshire Wolds to the south, making it the perfect location for exploring some of the most spectacular scenery around. Excellent walks and cycle tracks are right outside our door, \r\n“We moved into Lowther House in September 2015 after running a pub and bed and breakfast in the Yorkshire Dales. We knew the first time we saw Lowther House that we wanted to live here, the house are gardens are beautiful and have a real sense of calm about them. We hope you will enjoy the comfort, charm and warm welcome at Lowther House.” Latest News & Info\r\nWinter warmer bed & breakfast special offer\r\n Available Nov - Feb inclusive. \r\n Book one night and get (consecutive) night free. \r\n Subject to availabliity Room price is £80.  ','Home','',NULL,'2016-05-21 13:53:25','2016-05-30 17:18:10',NULL,0)
 ,(124,'Around Lowther House\r\n The house is Georgian dating from around 1810, it was built for the Woodward of the time, the man overseeing the woods on the Pickering estate. The house is bordered on one side by a limestone outcropping and is built from this local stone – and we mean local! The quarrying remains for the stone can still be seen in the mesmeric grotto-in-the-trees adjacent to the house. \r\n It has undergone many changes and owners since then, the latest being Her Most Gracious Majesty through Her Duchy of Lancaster Estate, an ancient estate of the King (or Queen) dating back to 1399. \r\n Lowther house is a grade 11 building as defined by English Heritage and cannot be altered in its look, and is mostly original. Being over two hundred years old, she creaks and groans and is somewhat crooked in places, and some of the original windows (many with the original wonky hand-made glass panes too!) and doors have minds of their own! But as with any two hundred-year-old it’s part of her charm, and we hope you find it as endearing as we do! \r\n Fear not! Inside her sturdy 40cms thick walls the interior has modern central heating, unlimited hot water and other 21st century amenities! \r\n Bordered on two sides by the Beck, the house has a beautiful English Country Garden at the back of some half acre, the front garden is laid to grass looking over a sweeping swathe of river meadow running down to the road known as the \'Butts\' – but whether it was ever used for archery practice is not known.  Our Gardens\r\n Please feel free to wander in our lovely gardens - we can lend you a net so you can try fishing for Brown Trout, if you catch a big enough one we can cook it for you, but mostly they\'re tiny and you have to throw them back! \r\n The rear garden is also our tea garden, snacks and meals with an eclectic twist are available all day from 10 am. We cater for picnics on the lawn under the apple trees as well, a delightful way to spend an hour or two! We are also happy to cater for small private parties.  ','The House & Gardens','','/house-and-gardens','2016-05-29 18:45:00','2016-05-30 17:45:38',NULL,0)
 ,(125,'Booking Enquiry Form Bedrooms at Lowther House\r\n We have two first floor rooms - so we can offer excellent service. Fresh flowers greet you, in hospitality corner there is a silent running fridge for your use for beverages, wine etc. - just ask for ice and glasses. Also, there are a selection of Twinings teas and Fresh Rombouts Coffees - yours for the making, plus biscuits to nibble, an insulated carafe of chilled filtered water is also provided. A radio-controlled alarm clock with a very useful weather feature is by the bed. \r\n There is a Freesat TV with DVD player a selection of DVD\'s/CD\'s is available on the landing. In the closet you\'ll find shower robes, hair dryer, shaver adaptor, fan, extra bedding etc.  Beck Room Orchard Room Garden Room  BECK ROOM Available as a twin-bedded room. Double aspect, with lovely views of the Beck and the garden across to the Butts river meadow. With the added fun of watching the steam trains of the North York\'s Moors Railway as they chug up the dale to Whitby! \r\n Drift off to sleep with the sounds of the beck trickling by your window, interrupted only by the hoots of owls on their night-time hunting trips. \r\n For a romantic treat we are happy to serve breakfast in the room - just let us know ahead of time! The private wet-room with key access for exclusive use is across the hall   ORCHARD ROOM A king-size bed (5\') with en-suite wet-room. Wake to gorgeous views over the garden orchard and Pickering Woods, maybe you\'ll see a deer or two as well! \r\n Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam sodales vehicula risus, et facilisis massa lacinia eget. Pellentesque auctor bibendum urna sed tempus. Pellentesque elementum, tellus quis tristique maximus, eros arcu malesuada augue, nec consectetur purus sem quis velit.   GARDEN ROOM Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam sodales vehicula risus, et facilisis massa lacinia eget. Pellentesque auctor bibendum urna sed tempus. Pellentesque elementum, tellus quis tristique maximus, eros arcu malesuada augue, nec consectetur purus sem quis velit. \r\n Curabitur molestie nisl nisl, a eleifend tortor congue ut. Morbi eleifend sapien vel felis consequat, tincidunt convallis eros malesuada. Sed mollis aliquet nisi, lobortis aliquam nibh tristique vel. Nulla accumsan ipsum felis. Nunc eget diam nunc. Pvarius magna eget.  Bed & Breakfast tariff for 2016\r\n Lowther House Tariff below is for direct bookings only \r\n\r\n\r\nRooms1 Night2-4 Nights5+ Nights\r\n\r\nOrchard En-suite, King\r\n£75\r\n£70\r\n£65\r\n\r\n\r\nBeckside Separate Bathroom Twin or Super King\r\n£70\r\n£65\r\n£60\r\n\r\n\r\nGarden Separate Bathroom\r\n£70\r\n£65\r\n£60\r\n\r\n\r\n “Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam sodales vehicula risus, et facilisis massa lacinia eget. Pellentesque auctor bibendum urna sed tempus. Pellentesque elementum, tellus quis tristique maximus, eros arcu malesuada augue, nec consectetur purus sem quis velit.” Eu epicurei suscipiantur mea. Ius eu wisi suscipit, pri tollit vocibus id. Percipit tacimates id eum. Vel et alia nominavi laboramus, vel ex tritani prodesset, ut duo modo volutpat aliquando. Mutat essent ut sea, est solum mucius te. Qui veniam consetetur definiebas an. Dicam intellegam definitiones vis ut, perfecto tincidunt incorrupte sit ex. Vis graece virtute inimicus no, nec ad efficiendi definitionem, at aeque abhorreant omittantur mei. Persius signiferumque eum ne. Booking Information\r\n Single occupancy rates are £10.00 less per room. \r\n Prices are inclusive of breakfast. \r\n We accept well behaved dogs at a one off charge of £10 per dog. \r\n Bookings through third parties may be charged at a higher tariff \r\n We accept most British and International Debit, Credit and Commercial Cards, for deposits and payments, except Diners and Amex. If you need further information please give us a call on 01751 477 568 or email info@lowtherhouse.co.uk \r\nDOWNLOADS\r\n Booking Terms & Conditions  Accesibility Statement  B&B Tariff  ','Bedrooms','','/bedrooms','2016-05-29 18:46:00','2016-06-04 15:48:22',NULL,0)
 ,(126,'Eating With Us\r\n Lorem ipsum dolor sit amet, quo doctus ponderum eu. Ad doming molestiae conclusionemque cum. Assum mandamus ne eum, at nulla oratio his. Eam dolore vivendum ad. An impetus appareat tincidunt has, id sed option liberavisse. \r\n Eu epicurei suscipiantur mea. Ius eu wisi suscipit, pri tollit vocibus id. Percipit tacimates id eum. Vel et alia nominavi laboramus, vel ex tritani prodesset, ut duo modo volutpat aliquando.  Meals\r\n We pride ourselves on the freshness and quality of our food, all our fresh food is purchased from local butchers, bakers, greengrocers, fishmongers and grocery stores ensuring we know when and where it grew or was made. Meals can be served in the dining room or terrace, weather permitting. \r\nSAMPLE MENU Breakfast\r\nSAMPLE MENU\r\n 100% pure fresh fruit juice \r\n Choice of Teas and Cafetiere coffee, or our luxury Hot Frothy Chocolate \r\n Choice of Cereals and Porridge \r\n Traditional English ­ grilled not fried \r\n A choice of: Bacon, Sausages, Baked Beans, Yorkshire Black Pudding (yes there are other varieties!), Mushrooms, Hash Browns, Tomatoes, Eggs cooked a variety of ways. \r\nCONTINENTAL\r\n A variety of meats and cheeses, fresh fruit, yoghurt, croissants, etc. \r\n Granary or White Toast with local Jams, Jellies and Marmalade ­ even Marmite!  ','Eating With Us','','/eating-us','2016-05-29 18:46:00','2016-06-04 15:16:46',NULL,0)
 ,(127,'','Tea Room','','/tea-room','2016-05-29 18:47:00','2016-05-29 18:47:13',NULL,0)
 ,(128,'Events Info\r\n Lorem ipsum dolor sit amet, quo doctus ponderum eu. Ad doming molestiae conclusionemque cum. Assum mandamus ne eum, at nulla oratio his. Eam dolore vivendum ad. An impetus appareat tincidunt has, id sed option liberavisse. \r\n Eu epicurei suscipiantur mea. Ius eu wisi suscipit, pri tollit vocibus id. Percipit tacimates id eum. Vel et alia nominavi laboramus, vel ex tritani prodesset, ut duo modo volutpat aliquando.  Local Events\r\n Flying Scotsman visits NYMR - 12th, 13th, 15th, 16th, 17th, 19th, and 20th March \r\n NYMR Summer services begin Mon 21st March \r\n Tour de Yorkshire (Stage 3) Sunday 1st May \r\n NYMR Steam Gala 6th - 8th and 13th - 15th May, visiting engines LNWR 58926 and Standard 80072 \r\n Malton Food Festival 28th - 29th May \r\n 70\'s Weekend at NMR 17th - 19th June \r\n Forest Live - Dalby Forest music festival 23rd - 25th June \r\n 60\'s Weekend at NYMR 2nd - 3rd July \r\n Classic Car and Vehicle Rally 9th - 10th July \r\n 4th Rydale Jazz Festival 24th - 30th July \r\n Pickering Traction Rall 5th, 6th and 7th August \r\n Autumn Steam gala 30th Sept - 2nd Oct \r\n Pickering War Weekend 14th - 16th October  2016 events a Lowther House\r\n Valentines Weekend - Two night stay, £140, includes afternoon tea on arrival and a bottle of fizz in your room. \r\n Easter Weekend - Easter Afternoon Tea available all weekend, Easter Egg Hunt on Sunday 27th March 2pm. \r\n The derelict chicken hut and run are being repaired and we hope to have it for ready for the new hen residents by the end of April. \r\n Our new \'Herdy Hut\' will be available to hire from May, the renovated glamping pod will be newly fitted out and ready for guests. \r\n The \'Vintage Barn\' - new for this Summer, when you visit for an overnight stay or for a treat in the tea garden you\'ll be able to visit the vintage barn - \'upcyled furniture, vintage finds and handmade gifts\'. \r\n Jazz on the Lawn - share a Summers evening, a nice glass of fizz and live jazz with the Rydale Jazz Band - June date tbc Summer Gala - Sat 9th July - Great food, live music, children\'s games, gifts and produce for sale. \r\n Sausage and Cider Day - Sunday 31st July (Bank Holiday weekend) \r\n Afternoon Tea - afternoon tea with all the trimmings, vintage china, tablecloths and embroidered napkins. Available Weds - Sunday £9.95. Gift certificates for afternoon tea available to treat someone special. \r\n Hire our Vintage Barn for parties,small weddings,events or birthdays. Theme your event, cater yourselves or we\'ll cater for you. Use of the beautiful garden throughout your event.  ','Events','','/events','2016-05-29 18:47:00','2016-06-04 15:27:44',NULL,0)
 ,(129,'Out Location\r\n The house is surrounded by the fabulously \'Tolkien\' Pickering Woods in which are secret meadows, unchanged for centuries, you could well believe you\'re in the Shire of Middle Earth! Ideal for those who like either an early morning or late evening stroll (best times to spot Hobbits!). \r\n We can lend you a couple of bikes if you\'d like to pedal around for the day!  Cut & About in the local area\r\n Lorem ipsum dolor sit amet, quo doctus ponderum eu. Ad doming molestiae conclusionemque cum. Assum mandamus ne eum, at nulla oratio his. Eam dolore vivendum ad. An impetus appareat tincidunt has, id sed option liberavisse. \r\n Eu epicurei suscipiantur mea. Ius eu wisi suscipit, pri tollit vocibus id. Percipit tacimates id eum. Vel et alia nominavi laboramus, vel ex tritani prodesset, ut duo modo volutpat aliquando.  Around the moors  Available as a twin-bedded room. Double aspect, with lovely views of the Beck and the garden across to the Butts river meadow. With the added fun of watching the steam trains of the North York\'s Moors Railway as they chug up the dale to Whitby! \r\n Drift off to sleep with the sounds of the beck trickling by your window, interrupted only by the hoots of owls on their night-time hunting trips. \r\n For a romantic treat we are happy to serve breakfast in the room - just let us know ahead of time! \r\n The private wet-room with key access for exclusive use is across the hall.  Along the coast  A king-size bed (5\') with en-suite wet-room. Wake to gorgeous views over the garden orchard and Pickering Woods, maybe you\'ll see a deer or two as well!  Eating & Drinking  Lorem ipsum dolor sit amet, quo doctus ponderum eu. Ad doming molestiae conclusionemque cum. Assum mandamus ne eum, at nulla oratio his. Eam dolore vivendum ad. An impetus appareat tincidunt has, id sed option liberavisse. \r\n Eu epicurei suscipiantur mea. Ius eu wisi suscipit, pri tollit vocibus id. Percipit tacimates id eum. Vel et alia nominavi laboramus, vel ex tritani prodesset, ut duo modo volutpat aliquando.  ','Local Area','','/local-area','2016-05-29 18:47:00','2016-06-04 15:34:12',NULL,0)
 ,(130,'How to find Lowther House\r\n We have two first floor rooms - so we can offer excellent service. Fresh flowers greet you, in hospitality corner there is a silent running fridge for your use for beverages, wine etc. - just ask for ice and glasses. Also, there are a selection of Twinings teas and Fresh Rombouts Coffees - yours for the making, plus biscuits to nibble, an insulated carafe of chilled filtered water is also provided. A radio-controlled alarm clock with a very useful weather feature is by the bed. \r\n There is a Freesat TV with DVD player a selection of DVD\'s/CD\'s is available on the landing. In the closet you\'ll find shower robes, hair dryer, shaver adaptor, fan, extra bedding etc.   Booking Enquiry Form ','Contact & Find Us','','/contact-and-find-us','2016-05-29 18:47:00','2016-06-04 15:43:41',NULL,0)
 ,(122,'','Badges',NULL,'/!stacks/badges','2016-05-29 18:14:53','2016-06-04 15:48:21',NULL,0);

DROP TABLE IF EXISTS PageStatistics;

CREATE TABLE IF NOT EXISTS `PageStatistics` (
  `pstID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `date` date DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `uID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`pstID`),
  KEY `cID` (`cID`),
  KEY `date` (`date`),
  KEY `uID` (`uID`)
) ENGINE=MyISAM AUTO_INCREMENT=352 DEFAULT CHARSET=utf8;

INSERT INTO PageStatistics VALUES(1,1,'2016-05-21','2016-05-21 12:53:50',1)
 ,(2,106,'2016-05-21','2016-05-21 12:53:52',1)
 ,(3,1,'2016-05-29','2016-05-29 14:07:43',1)
 ,(4,107,'2016-05-29','2016-05-29 14:07:44',1)
 ,(5,1,'2016-05-29','2016-05-29 16:06:47',1)
 ,(6,2,'2016-05-29','2016-05-29 17:13:57',1)
 ,(7,28,'2016-05-29','2016-05-29 17:14:00',1)
 ,(8,28,'2016-05-29','2016-05-29 17:14:21',1)
 ,(9,28,'2016-05-29','2016-05-29 17:14:31',1)
 ,(10,1,'2016-05-29','2016-05-29 17:14:34',1)
 ,(11,2,'2016-05-29','2016-05-29 17:14:38',1)
 ,(12,28,'2016-05-29','2016-05-29 17:14:40',1)
 ,(13,28,'2016-05-29','2016-05-29 17:14:42',1)
 ,(14,30,'2016-05-29','2016-05-29 17:14:42',1)
 ,(15,28,'2016-05-29','2016-05-29 17:14:45',1)
 ,(16,28,'2016-05-29','2016-05-29 17:14:48',1)
 ,(17,28,'2016-05-29','2016-05-29 17:14:50',1)
 ,(18,1,'2016-05-29','2016-05-29 17:14:53',1)
 ,(19,1,'2016-05-29','2016-05-29 17:15:48',1)
 ,(20,1,'2016-05-29','2016-05-29 17:16:37',1)
 ,(21,1,'2016-05-29','2016-05-29 17:17:00',1)
 ,(22,1,'2016-05-29','2016-05-29 17:18:47',1)
 ,(23,1,'2016-05-29','2016-05-29 17:20:19',1)
 ,(24,1,'2016-05-29','2016-05-29 17:22:31',1)
 ,(25,1,'2016-05-29','2016-05-29 17:24:24',1)
 ,(26,1,'2016-05-29','2016-05-29 17:24:46',1)
 ,(27,1,'2016-05-29','2016-05-29 17:24:54',1)
 ,(28,1,'2016-05-29','2016-05-29 17:25:00',1)
 ,(29,1,'2016-05-29','2016-05-29 17:26:13',1)
 ,(30,1,'2016-05-29','2016-05-29 17:29:05',1)
 ,(31,1,'2016-05-29','2016-05-29 17:30:37',1)
 ,(32,1,'2016-05-29','2016-05-29 17:30:50',1)
 ,(33,1,'2016-05-29','2016-05-29 17:32:23',1)
 ,(34,1,'2016-05-29','2016-05-29 17:33:47',1)
 ,(35,1,'2016-05-29','2016-05-29 17:34:42',1)
 ,(36,1,'2016-05-29','2016-05-29 17:34:51',1)
 ,(37,1,'2016-05-29','2016-05-29 17:41:14',1)
 ,(38,1,'2016-05-29','2016-05-29 17:42:23',1)
 ,(39,1,'2016-05-29','2016-05-29 17:43:37',1)
 ,(40,1,'2016-05-29','2016-05-29 17:43:51',1)
 ,(41,1,'2016-05-29','2016-05-29 17:45:09',1)
 ,(42,7,'2016-05-29','2016-05-29 17:45:16',1)
 ,(43,6,'2016-05-29','2016-05-29 17:46:08',1)
 ,(44,7,'2016-05-29','2016-05-29 17:46:09',1)
 ,(45,6,'2016-05-29','2016-05-29 17:46:21',1)
 ,(46,7,'2016-05-29','2016-05-29 17:46:22',1)
 ,(47,6,'2016-05-29','2016-05-29 17:46:38',1)
 ,(48,7,'2016-05-29','2016-05-29 17:46:38',1)
 ,(49,6,'2016-05-29','2016-05-29 17:47:12',1)
 ,(50,7,'2016-05-29','2016-05-29 17:47:12',1)
 ,(51,6,'2016-05-29','2016-05-29 17:47:22',1)
 ,(52,7,'2016-05-29','2016-05-29 17:47:22',1)
 ,(53,6,'2016-05-29','2016-05-29 17:47:31',1)
 ,(54,7,'2016-05-29','2016-05-29 17:47:31',1)
 ,(55,6,'2016-05-29','2016-05-29 17:47:56',1)
 ,(56,7,'2016-05-29','2016-05-29 17:47:56',1)
 ,(57,1,'2016-05-29','2016-05-29 17:48:01',1)
 ,(58,1,'2016-05-29','2016-05-29 17:50:39',1)
 ,(59,1,'2016-05-29','2016-05-29 17:50:53',1)
 ,(60,1,'2016-05-29','2016-05-29 17:51:28',1)
 ,(61,1,'2016-05-29','2016-05-29 17:52:04',1)
 ,(62,1,'2016-05-29','2016-05-29 17:52:58',1)
 ,(63,1,'2016-05-29','2016-05-29 17:54:05',1)
 ,(64,1,'2016-05-29','2016-05-29 17:55:03',1)
 ,(65,1,'2016-05-29','2016-05-29 17:56:11',1)
 ,(66,1,'2016-05-29','2016-05-29 17:58:51',1)
 ,(67,1,'2016-05-29','2016-05-29 18:02:22',1)
 ,(68,1,'2016-05-29','2016-05-29 18:02:35',1)
 ,(69,1,'2016-05-29','2016-05-29 18:03:03',1)
 ,(70,1,'2016-05-29','2016-05-29 18:04:05',1)
 ,(71,1,'2016-05-29','2016-05-29 18:05:39',1)
 ,(72,1,'2016-05-29','2016-05-29 18:06:03',1)
 ,(73,1,'2016-05-29','2016-05-29 18:06:10',1)
 ,(74,1,'2016-05-29','2016-05-29 18:06:17',1)
 ,(75,1,'2016-05-29','2016-05-29 18:06:22',1)
 ,(76,1,'2016-05-29','2016-05-29 18:06:27',1)
 ,(77,1,'2016-05-29','2016-05-29 18:06:45',1)
 ,(78,1,'2016-05-29','2016-05-29 18:06:48',1)
 ,(79,1,'2016-05-29','2016-05-29 18:07:01',1)
 ,(80,1,'2016-05-29','2016-05-29 18:07:12',1)
 ,(81,1,'2016-05-29','2016-05-29 18:07:20',1)
 ,(82,1,'2016-05-29','2016-05-29 18:07:25',1)
 ,(83,1,'2016-05-29','2016-05-29 18:07:28',1)
 ,(84,1,'2016-05-29','2016-05-29 18:08:15',1)
 ,(85,1,'2016-05-29','2016-05-29 18:08:47',1)
 ,(86,1,'2016-05-29','2016-05-29 18:08:57',1)
 ,(87,1,'2016-05-29','2016-05-29 19:15:58',1)
 ,(88,1,'2016-05-29','2016-05-29 19:17:06',1)
 ,(89,1,'2016-05-29','2016-05-29 19:18:39',1)
 ,(90,1,'2016-05-29','2016-05-29 19:19:50',1)
 ,(91,1,'2016-05-29','2016-05-29 19:20:09',1)
 ,(92,1,'2016-05-29','2016-05-29 19:20:30',1)
 ,(93,1,'2016-05-29','2016-05-29 19:20:43',1)
 ,(94,1,'2016-05-29','2016-05-29 19:21:16',1)
 ,(95,1,'2016-05-29','2016-05-29 19:23:08',1)
 ,(96,1,'2016-05-29','2016-05-29 19:33:27',1)
 ,(97,1,'2016-05-29','2016-05-29 19:35:50',1)
 ,(98,1,'2016-05-29','2016-05-29 19:36:20',1)
 ,(99,1,'2016-05-29','2016-05-29 19:37:11',1)
 ,(100,1,'2016-05-29','2016-05-29 19:37:37',1)
 ,(101,1,'2016-05-29','2016-05-29 19:38:11',1)
 ,(102,1,'2016-05-29','2016-05-29 19:38:29',1)
 ,(103,1,'2016-05-29','2016-05-29 19:39:54',1)
 ,(104,1,'2016-05-29','2016-05-29 19:41:37',1)
 ,(105,1,'2016-05-29','2016-05-29 19:41:45',1)
 ,(106,1,'2016-05-29','2016-05-29 19:41:53',1)
 ,(107,1,'2016-05-29','2016-05-29 19:49:10',1)
 ,(108,1,'2016-05-29','2016-05-29 19:49:32',1)
 ,(109,1,'2016-05-29','2016-05-29 19:50:44',1)
 ,(110,1,'2016-05-29','2016-05-29 19:51:51',1)
 ,(111,1,'2016-05-29','2016-05-29 19:52:15',1)
 ,(112,1,'2016-05-29','2016-05-29 19:52:44',1)
 ,(113,1,'2016-05-29','2016-05-29 19:54:46',1)
 ,(114,1,'2016-05-29','2016-05-29 19:56:13',1)
 ,(115,1,'2016-05-29','2016-05-29 19:57:14',1)
 ,(116,46,'2016-05-30','2016-05-30 12:33:10',1)
 ,(117,46,'2016-05-30','2016-05-30 12:33:13',1)
 ,(118,46,'2016-05-30','2016-05-30 12:33:13',1)
 ,(119,1,'2016-05-30','2016-05-30 12:33:19',1)
 ,(120,1,'2016-05-30','2016-05-30 12:33:22',1)
 ,(121,1,'2016-05-30','2016-05-30 12:35:27',1)
 ,(122,1,'2016-05-30','2016-05-30 12:36:06',1)
 ,(123,1,'2016-05-30','2016-05-30 12:36:20',1)
 ,(124,1,'2016-05-30','2016-05-30 12:46:54',1)
 ,(125,1,'2016-05-30','2016-05-30 12:46:58',1)
 ,(126,1,'2016-05-30','2016-05-30 12:48:23',1)
 ,(127,1,'2016-05-30','2016-05-30 12:51:53',1)
 ,(128,1,'2016-05-30','2016-05-30 12:52:10',1)
 ,(129,11,'2016-05-30','2016-05-30 12:59:23',1)
 ,(130,1,'2016-05-30','2016-05-30 12:59:56',1)
 ,(131,1,'2016-05-30','2016-05-30 12:59:59',1)
 ,(132,1,'2016-05-30','2016-05-30 13:00:23',1)
 ,(133,1,'2016-05-30','2016-05-30 13:06:17',1)
 ,(134,1,'2016-05-30','2016-05-30 13:06:48',1)
 ,(135,1,'2016-05-30','2016-05-30 13:07:40',1)
 ,(136,1,'2016-05-30','2016-05-30 13:08:06',1)
 ,(137,1,'2016-05-30','2016-05-30 13:08:21',1)
 ,(138,1,'2016-05-30','2016-05-30 13:08:32',1)
 ,(139,1,'2016-05-30','2016-05-30 13:09:39',1)
 ,(140,1,'2016-05-30','2016-05-30 13:09:58',1)
 ,(141,1,'2016-05-30','2016-05-30 13:10:05',1)
 ,(142,1,'2016-05-30','2016-05-30 13:11:00',1)
 ,(143,1,'2016-05-30','2016-05-30 13:11:57',1)
 ,(144,1,'2016-05-30','2016-05-30 13:12:06',1)
 ,(145,1,'2016-05-30','2016-05-30 13:34:54',1)
 ,(146,1,'2016-05-30','2016-05-30 13:37:34',1)
 ,(147,1,'2016-05-30','2016-05-30 13:37:46',1)
 ,(148,1,'2016-05-30','2016-05-30 13:38:36',1)
 ,(149,1,'2016-05-30','2016-05-30 13:39:09',1)
 ,(150,1,'2016-05-30','2016-05-30 13:40:16',1)
 ,(151,1,'2016-05-30','2016-05-30 13:41:02',1)
 ,(152,1,'2016-05-30','2016-05-30 13:41:09',1)
 ,(153,1,'2016-05-30','2016-05-30 13:41:42',1)
 ,(154,1,'2016-05-30','2016-05-30 13:42:17',1)
 ,(155,1,'2016-05-30','2016-05-30 13:42:25',1)
 ,(156,1,'2016-05-30','2016-05-30 13:43:11',1)
 ,(157,1,'2016-05-30','2016-05-30 13:43:38',1)
 ,(158,1,'2016-05-30','2016-05-30 13:45:40',1)
 ,(159,1,'2016-05-30','2016-05-30 13:46:41',1)
 ,(160,1,'2016-05-30','2016-05-30 14:08:04',1)
 ,(161,107,'2016-05-30','2016-05-30 14:08:05',1)
 ,(162,1,'2016-05-30','2016-05-30 14:08:27',1)
 ,(163,1,'2016-05-30','2016-05-30 14:08:48',1)
 ,(164,1,'2016-05-30','2016-05-30 14:09:35',1)
 ,(165,1,'2016-05-30','2016-05-30 14:10:39',1)
 ,(166,1,'2016-05-30','2016-05-30 14:10:57',1)
 ,(167,1,'2016-05-30','2016-05-30 14:12:06',1)
 ,(168,1,'2016-05-30','2016-05-30 14:13:55',1)
 ,(169,1,'2016-05-30','2016-05-30 14:14:28',1)
 ,(170,1,'2016-05-30','2016-05-30 14:14:51',1)
 ,(171,1,'2016-05-30','2016-05-30 14:15:04',1)
 ,(172,1,'2016-05-30','2016-05-30 14:16:28',1)
 ,(173,1,'2016-05-30','2016-05-30 14:18:18',1)
 ,(174,1,'2016-05-30','2016-05-30 14:18:35',1)
 ,(175,1,'2016-05-30','2016-05-30 14:19:25',1)
 ,(176,1,'2016-05-30','2016-05-30 14:19:38',1)
 ,(177,1,'2016-05-30','2016-05-30 14:25:07',1)
 ,(178,1,'2016-05-30','2016-05-30 14:25:49',1)
 ,(179,1,'2016-05-30','2016-05-30 14:26:07',1)
 ,(180,1,'2016-05-30','2016-05-30 14:26:31',1)
 ,(181,1,'2016-05-30','2016-05-30 14:26:48',1)
 ,(182,1,'2016-05-30','2016-05-30 14:27:24',1)
 ,(183,1,'2016-05-30','2016-05-30 14:28:24',1)
 ,(184,1,'2016-05-30','2016-05-30 14:29:58',1)
 ,(185,1,'2016-05-30','2016-05-30 14:30:32',1)
 ,(186,1,'2016-05-30','2016-05-30 14:30:42',1)
 ,(187,1,'2016-05-30','2016-05-30 14:33:19',1)
 ,(188,1,'2016-05-30','2016-05-30 14:33:58',1)
 ,(189,1,'2016-05-30','2016-05-30 14:35:01',1)
 ,(190,1,'2016-05-30','2016-05-30 14:35:25',1)
 ,(191,1,'2016-05-30','2016-05-30 14:35:57',1)
 ,(192,1,'2016-05-30','2016-05-30 14:36:28',1)
 ,(193,1,'2016-05-30','2016-05-30 14:37:39',1)
 ,(194,1,'2016-05-30','2016-05-30 16:12:03',1)
 ,(195,1,'2016-05-30','2016-05-30 16:12:38',1)
 ,(196,1,'2016-05-30','2016-05-30 16:12:42',1)
 ,(197,1,'2016-05-30','2016-05-30 16:15:50',1)
 ,(198,1,'2016-05-30','2016-05-30 16:16:19',1)
 ,(199,1,'2016-05-30','2016-05-30 16:16:47',1)
 ,(200,1,'2016-05-30','2016-05-30 16:17:14',1)
 ,(201,1,'2016-05-30','2016-05-30 16:17:25',1)
 ,(202,1,'2016-05-30','2016-05-30 16:17:58',1)
 ,(203,1,'2016-05-30','2016-05-30 16:18:10',1)
 ,(204,124,'2016-05-30','2016-05-30 16:42:52',1)
 ,(205,124,'2016-05-30','2016-05-30 16:42:57',1)
 ,(206,124,'2016-05-30','2016-05-30 16:45:37',1)
 ,(207,124,'2016-05-30','2016-05-30 16:46:19',1)
 ,(208,124,'2016-05-30','2016-05-30 16:47:09',1)
 ,(209,125,'2016-05-30','2016-05-30 16:47:52',1)
 ,(210,125,'2016-05-30','2016-05-30 16:47:52',1)
 ,(211,125,'2016-05-30','2016-05-30 16:47:56',1)
 ,(212,125,'2016-05-30','2016-05-30 16:48:54',1)
 ,(213,125,'2016-05-30','2016-05-30 16:50:14',1)
 ,(214,125,'2016-05-30','2016-05-30 16:50:32',1)
 ,(215,125,'2016-05-30','2016-05-30 16:50:44',1)
 ,(216,2,'2016-05-30','2016-05-30 16:56:13',1)
 ,(217,28,'2016-05-30','2016-05-30 16:56:16',1)
 ,(218,30,'2016-05-30','2016-05-30 16:56:20',1)
 ,(219,30,'2016-05-30','2016-05-30 16:56:29',1)
 ,(220,125,'2016-05-30','2016-05-30 16:56:35',1)
 ,(221,125,'2016-05-30','2016-05-30 16:56:44',1)
 ,(222,51,'2016-05-30','2016-05-30 16:56:52',1)
 ,(223,68,'2016-05-30','2016-05-30 16:56:55',1)
 ,(224,68,'2016-05-30','2016-05-30 16:56:56',1)
 ,(225,68,'2016-05-30','2016-05-30 16:56:57',1)
 ,(226,125,'2016-05-30','2016-05-30 16:57:01',1)
 ,(227,125,'2016-05-30','2016-05-30 16:58:21',1)
 ,(228,68,'2016-05-30','2016-05-30 17:01:03',1)
 ,(229,68,'2016-05-30','2016-05-30 17:01:05',1)
 ,(230,68,'2016-05-30','2016-05-30 17:01:07',1)
 ,(231,125,'2016-05-30','2016-05-30 17:01:08',1)
 ,(232,125,'2016-05-30','2016-05-30 17:03:12',1)
 ,(233,125,'2016-05-30','2016-05-30 17:03:52',1)
 ,(234,125,'2016-05-30','2016-05-30 17:27:45',1)
 ,(235,2,'2016-05-30','2016-05-30 17:27:52',1)
 ,(236,43,'2016-05-30','2016-05-30 17:27:55',1)
 ,(237,43,'2016-05-30','2016-05-30 17:27:58',1)
 ,(238,125,'2016-05-30','2016-05-30 17:28:08',1)
 ,(239,125,'2016-05-30','2016-05-30 17:30:27',1)
 ,(240,125,'2016-05-30','2016-05-30 17:33:54',1)
 ,(241,125,'2016-05-30','2016-05-30 17:34:23',1)
 ,(242,125,'2016-05-30','2016-05-30 17:34:37',1)
 ,(243,125,'2016-05-30','2016-05-30 17:34:56',1)
 ,(244,125,'2016-05-30','2016-05-30 17:35:37',1)
 ,(245,125,'2016-05-30','2016-05-30 17:36:16',1)
 ,(246,125,'2016-05-30','2016-05-30 17:36:22',1)
 ,(247,125,'2016-05-30','2016-05-30 17:52:33',1)
 ,(248,125,'2016-05-31','2016-05-31 21:32:39',1)
 ,(249,107,'2016-05-31','2016-05-31 21:32:41',1)
 ,(250,125,'2016-06-01','2016-06-01 21:11:46',1)
 ,(251,125,'2016-06-01','2016-06-01 21:11:53',1)
 ,(252,125,'2016-06-01','2016-06-01 21:18:59',1)
 ,(253,125,'2016-06-01','2016-06-01 21:19:09',1)
 ,(254,125,'2016-06-01','2016-06-01 21:19:56',1)
 ,(255,125,'2016-06-02','2016-06-02 20:03:11',1)
 ,(256,107,'2016-06-02','2016-06-02 20:03:12',1)
 ,(257,125,'2016-06-02','2016-06-02 20:03:44',1)
 ,(258,125,'2016-06-02','2016-06-02 20:04:53',1)
 ,(259,125,'2016-06-02','2016-06-02 20:05:03',1)
 ,(260,125,'2016-06-02','2016-06-02 20:05:29',1)
 ,(261,125,'2016-06-02','2016-06-02 20:06:40',1)
 ,(262,125,'2016-06-02','2016-06-02 20:07:01',1)
 ,(263,125,'2016-06-02','2016-06-02 20:09:11',1)
 ,(264,125,'2016-06-02','2016-06-02 20:35:26',1)
 ,(265,125,'2016-06-02','2016-06-02 20:35:34',1)
 ,(266,125,'2016-06-02','2016-06-02 20:38:42',1)
 ,(267,125,'2016-06-02','2016-06-02 20:39:21',1)
 ,(268,125,'2016-06-02','2016-06-02 20:39:47',1)
 ,(269,125,'2016-06-02','2016-06-02 20:40:39',1)
 ,(270,125,'2016-06-02','2016-06-02 20:41:06',1)
 ,(271,125,'2016-06-02','2016-06-02 20:42:24',1)
 ,(272,125,'2016-06-02','2016-06-02 20:42:39',1)
 ,(273,125,'2016-06-02','2016-06-02 20:43:02',1)
 ,(274,125,'2016-06-02','2016-06-02 20:43:47',1)
 ,(275,125,'2016-06-02','2016-06-02 20:45:23',1)
 ,(276,125,'2016-06-02','2016-06-02 20:46:04',1)
 ,(277,125,'2016-06-02','2016-06-02 20:46:41',1)
 ,(278,125,'2016-06-02','2016-06-02 20:46:50',1)
 ,(279,125,'2016-06-02','2016-06-02 20:47:33',1)
 ,(280,125,'2016-06-02','2016-06-02 20:48:39',1)
 ,(281,125,'2016-06-02','2016-06-02 20:48:48',1)
 ,(282,125,'2016-06-02','2016-06-02 20:49:09',1)
 ,(283,125,'2016-06-02','2016-06-02 20:50:52',1)
 ,(284,125,'2016-06-02','2016-06-02 20:51:48',1)
 ,(285,125,'2016-06-02','2016-06-02 20:52:45',1)
 ,(286,125,'2016-06-02','2016-06-02 20:53:57',1)
 ,(287,125,'2016-06-02','2016-06-02 20:54:49',1)
 ,(288,125,'2016-06-02','2016-06-02 20:54:59',1)
 ,(289,125,'2016-06-02','2016-06-02 20:55:49',1)
 ,(290,125,'2016-06-02','2016-06-02 20:56:08',1)
 ,(291,125,'2016-06-02','2016-06-02 20:56:23',1)
 ,(292,125,'2016-06-02','2016-06-02 20:58:50',1)
 ,(293,1,'2016-06-02','2016-06-02 21:00:17',1)
 ,(294,1,'2016-06-02','2016-06-02 21:00:41',1)
 ,(295,125,'2016-06-02','2016-06-02 21:00:45',1)
 ,(296,125,'2016-06-02','2016-06-02 21:01:03',1)
 ,(297,126,'2016-06-02','2016-06-02 21:01:40',1)
 ,(298,2,'2016-06-04','2016-06-04 13:56:53',1)
 ,(299,107,'2016-06-04','2016-06-04 13:56:53',1)
 ,(300,34,'2016-06-04','2016-06-04 13:57:07',1)
 ,(301,34,'2016-06-04','2016-06-04 13:57:10',1)
 ,(302,34,'2016-06-04','2016-06-04 13:57:20',1)
 ,(303,34,'2016-06-04','2016-06-04 13:57:20',1)
 ,(304,7,'2016-06-04','2016-06-04 13:57:25',1)
 ,(305,125,'2016-06-04','2016-06-04 13:57:51',1)
 ,(306,126,'2016-06-04','2016-06-04 13:58:12',1)
 ,(307,2,'2016-06-04','2016-06-04 14:12:29',1)
 ,(308,28,'2016-06-04','2016-06-04 14:12:32',1)
 ,(309,30,'2016-06-04','2016-06-04 14:12:34',1)
 ,(310,30,'2016-06-04','2016-06-04 14:12:37',1)
 ,(311,126,'2016-06-04','2016-06-04 14:12:41',1)
 ,(312,126,'2016-06-04','2016-06-04 14:12:48',1)
 ,(313,51,'2016-06-04','2016-06-04 14:13:01',1)
 ,(314,68,'2016-06-04','2016-06-04 14:13:03',1)
 ,(315,68,'2016-06-04','2016-06-04 14:13:05',1)
 ,(316,68,'2016-06-04','2016-06-04 14:13:05',1)
 ,(317,126,'2016-06-04','2016-06-04 14:13:09',1)
 ,(318,126,'2016-06-04','2016-06-04 14:16:46',1)
 ,(319,126,'2016-06-04','2016-06-04 14:17:40',1)
 ,(320,126,'2016-06-04','2016-06-04 14:19:24',1)
 ,(321,126,'2016-06-04','2016-06-04 14:20:08',1)
 ,(322,1,'2016-06-04','2016-06-04 14:22:14',1)
 ,(323,126,'2016-06-04','2016-06-04 14:22:24',1)
 ,(324,128,'2016-06-04','2016-06-04 14:22:53',1)
 ,(325,128,'2016-06-04','2016-06-04 14:23:00',1)
 ,(326,128,'2016-06-04','2016-06-04 14:27:43',1)
 ,(327,129,'2016-06-04','2016-06-04 14:28:09',1)
 ,(328,129,'2016-06-04','2016-06-04 14:28:13',1)
 ,(329,129,'2016-06-04','2016-06-04 14:28:21',1)
 ,(330,129,'2016-06-04','2016-06-04 14:30:53',1)
 ,(331,125,'2016-06-04','2016-06-04 14:30:58',1)
 ,(332,125,'2016-06-04','2016-06-04 14:31:01',1)
 ,(333,125,'2016-06-04','2016-06-04 14:31:11',1)
 ,(334,129,'2016-06-04','2016-06-04 14:31:15',1)
 ,(335,129,'2016-06-04','2016-06-04 14:31:18',1)
 ,(336,129,'2016-06-04','2016-06-04 14:34:11',1)
 ,(337,129,'2016-06-04','2016-06-04 14:38:17',1)
 ,(338,130,'2016-06-04','2016-06-04 14:38:23',1)
 ,(339,130,'2016-06-04','2016-06-04 14:38:28',1)
 ,(340,130,'2016-06-04','2016-06-04 14:42:27',1)
 ,(341,130,'2016-06-04','2016-06-04 14:42:58',1)
 ,(342,130,'2016-06-04','2016-06-04 14:43:17',1)
 ,(343,130,'2016-06-04','2016-06-04 14:43:24',1)
 ,(344,130,'2016-06-04','2016-06-04 14:43:40',1)
 ,(345,125,'2016-06-04','2016-06-04 14:43:56',1)
 ,(346,125,'2016-06-04','2016-06-04 14:44:29',1)
 ,(347,125,'2016-06-04','2016-06-04 14:48:21',1)
 ,(348,2,'2016-06-04','2016-06-04 16:19:10',1)
 ,(349,51,'2016-06-04','2016-06-04 16:19:51',1)
 ,(350,99,'2016-06-04','2016-06-04 16:19:55',1)
 ,(351,99,'2016-06-04','2016-06-04 16:19:57',1);

DROP TABLE IF EXISTS PageThemeStyles;

CREATE TABLE IF NOT EXISTS `PageThemeStyles` (
  `ptID` int(10) unsigned NOT NULL DEFAULT '0',
  `ptsHandle` varchar(128) NOT NULL,
  `ptsValue` longtext,
  `ptsType` varchar(32) NOT NULL,
  PRIMARY KEY (`ptID`,`ptsHandle`,`ptsType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS PageThemes;

CREATE TABLE IF NOT EXISTS `PageThemes` (
  `ptID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ptHandle` varchar(64) NOT NULL,
  `ptName` varchar(255) DEFAULT NULL,
  `ptDescription` text,
  `pkgID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ptID`),
  UNIQUE KEY `ptHandle` (`ptHandle`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO PageThemes VALUES(1,'default','Plain Yogurt','Plain Yogurt is concrete5\'s default theme.',0)
 ,(2,'greensalad','Green Salad Theme','This is concrete5\'s Green Salad site theme.',0)
 ,(3,'dark_chocolate','Dark Chocolate','Dark Chocolate is concrete5\'s default theme in black.',0)
 ,(4,'greek_yogurt','Greek Yogurt','An elegant theme for concrete5.',0)
 ,(5,'lowther-house','Lowther House','Main Theme for Loather House website',0);

DROP TABLE IF EXISTS PageTypeAttributes;

CREATE TABLE IF NOT EXISTS `PageTypeAttributes` (
  `ctID` int(10) unsigned NOT NULL DEFAULT '0',
  `akID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ctID`,`akID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS PageTypes;

CREATE TABLE IF NOT EXISTS `PageTypes` (
  `ctID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ctHandle` varchar(32) NOT NULL,
  `ctIcon` varchar(128) DEFAULT NULL,
  `ctName` varchar(90) NOT NULL,
  `ctIsInternal` tinyint(1) NOT NULL DEFAULT '0',
  `pkgID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ctID`),
  UNIQUE KEY `ctHandle` (`ctHandle`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

INSERT INTO PageTypes VALUES(1,'core_stack','main.png','Stack',1,0)
 ,(2,'dashboard_primary_five','main.png','Dashboard Primary + Five',1,0)
 ,(3,'dashboard_header_four_col','main.png','Dashboard Header + Four Column',1,0)
 ,(4,'right_sidebar','right_sidebar.png','Right Sidebar',0,0)
 ,(5,'three_columns','main.png','Three Columns',0,0)
 ,(6,'two-columns','main.png','Two Columns',0,0);

DROP TABLE IF EXISTS PageWorkflowProgress;

CREATE TABLE IF NOT EXISTS `PageWorkflowProgress` (
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `wpID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cID`,`wpID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS Pages;

CREATE TABLE IF NOT EXISTS `Pages` (
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `cIsTemplate` int(1) unsigned NOT NULL DEFAULT '0',
  `uID` int(10) unsigned DEFAULT NULL,
  `cIsCheckedOut` tinyint(1) NOT NULL DEFAULT '0',
  `cCheckedOutUID` int(10) unsigned DEFAULT NULL,
  `cCheckedOutDatetime` datetime DEFAULT NULL,
  `cCheckedOutDatetimeLastEdit` datetime DEFAULT NULL,
  `cOverrideTemplatePermissions` tinyint(1) NOT NULL DEFAULT '1',
  `cInheritPermissionsFromCID` int(10) unsigned NOT NULL DEFAULT '0',
  `cInheritPermissionsFrom` varchar(8) NOT NULL DEFAULT 'PARENT',
  `cFilename` varchar(255) DEFAULT NULL,
  `cPointerID` int(10) unsigned NOT NULL DEFAULT '0',
  `cPointerExternalLink` longtext,
  `cPointerExternalLinkNewWindow` tinyint(1) NOT NULL DEFAULT '0',
  `cIsActive` tinyint(1) NOT NULL DEFAULT '1',
  `cChildren` int(10) unsigned NOT NULL DEFAULT '0',
  `cDisplayOrder` int(10) unsigned NOT NULL DEFAULT '0',
  `cParentID` int(10) unsigned NOT NULL DEFAULT '0',
  `pkgID` int(10) unsigned NOT NULL DEFAULT '0',
  `cCacheFullPageContent` int(4) NOT NULL DEFAULT '-1',
  `cCacheFullPageContentOverrideLifetime` varchar(32) NOT NULL DEFAULT '0',
  `cCacheFullPageContentLifetimeCustom` int(10) unsigned NOT NULL DEFAULT '0',
  `cIsSystemPage` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`cID`),
  KEY `cParentID` (`cParentID`),
  KEY `cIsActive` (`cIsActive`),
  KEY `cCheckedOutUID` (`cCheckedOutUID`),
  KEY `uID` (`uID`),
  KEY `cPointerID` (`cPointerID`),
  KEY `cIsTemplate` (`cIsTemplate`),
  KEY `cIsSystemPage` (`cIsSystemPage`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO Pages VALUES(1,0,1,0,NULL,NULL,NULL,1,1,'OVERRIDE',NULL,0,NULL,0,1,17,0,0,0,-1,'0',0,0)
 ,(2,0,1,0,NULL,NULL,NULL,1,2,'OVERRIDE','/dashboard/view.php',0,NULL,0,1,13,0,0,0,-1,'0',0,1)
 ,(3,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/composer/view.php',0,NULL,0,1,2,0,2,0,-1,'0',0,1)
 ,(4,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/composer/write.php',0,NULL,0,1,0,0,3,0,-1,'0',0,1)
 ,(5,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/composer/drafts.php',0,NULL,0,1,0,1,3,0,-1,'0',0,1)
 ,(6,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/sitemap/view.php',0,NULL,0,1,3,1,2,0,-1,'0',0,1)
 ,(7,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/sitemap/full.php',0,NULL,0,1,0,0,6,0,-1,'0',0,1)
 ,(8,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/sitemap/explore.php',0,NULL,0,1,0,1,6,0,-1,'0',0,1)
 ,(9,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/sitemap/search.php',0,NULL,0,1,0,2,6,0,-1,'0',0,1)
 ,(10,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/files/view.php',0,NULL,0,1,4,2,2,0,-1,'0',0,1)
 ,(11,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/files/search.php',0,NULL,0,1,0,0,10,0,-1,'0',0,1)
 ,(12,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/files/attributes.php',0,NULL,0,1,0,1,10,0,-1,'0',0,1)
 ,(13,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/files/sets.php',0,NULL,0,1,0,2,10,0,-1,'0',0,1)
 ,(14,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/files/add_set.php',0,NULL,0,1,0,3,10,0,-1,'0',0,1)
 ,(15,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/users/view.php',0,NULL,0,1,6,3,2,0,-1,'0',0,1)
 ,(16,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/users/search.php',0,NULL,0,1,0,0,15,0,-1,'0',0,1)
 ,(17,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/users/groups.php',0,NULL,0,1,0,1,15,0,-1,'0',0,1)
 ,(18,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/users/attributes.php',0,NULL,0,1,0,2,15,0,-1,'0',0,1)
 ,(19,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/users/add.php',0,NULL,0,1,0,3,15,0,-1,'0',0,1)
 ,(20,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/users/add_group.php',0,NULL,0,1,0,4,15,0,-1,'0',0,1)
 ,(21,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/users/group_sets.php',0,NULL,0,1,0,5,15,0,-1,'0',0,1)
 ,(22,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/reports.php',0,NULL,0,1,4,4,2,0,-1,'0',0,1)
 ,(23,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/reports/statistics.php',0,NULL,0,1,0,0,22,0,-1,'0',0,1)
 ,(24,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/reports/forms.php',0,NULL,0,1,0,1,22,0,-1,'0',0,1)
 ,(25,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/reports/surveys.php',0,NULL,0,1,0,2,22,0,-1,'0',0,1)
 ,(26,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/reports/logs.php',0,NULL,0,1,0,3,22,0,-1,'0',0,1)
 ,(27,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/pages/view.php',0,NULL,0,1,4,5,2,0,-1,'0',0,1)
 ,(28,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/pages/themes/view.php',0,NULL,0,1,3,0,27,0,-1,'0',0,1)
 ,(29,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/pages/themes/add.php',0,NULL,0,1,0,0,28,0,-1,'0',0,1)
 ,(30,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/pages/themes/inspect.php',0,NULL,0,1,0,1,28,0,-1,'0',0,1)
 ,(31,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/pages/themes/customize.php',0,NULL,0,1,0,2,28,0,-1,'0',0,1)
 ,(32,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/pages/types/view.php',0,NULL,0,1,2,1,27,0,-1,'0',0,1)
 ,(33,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/pages/types/add.php',0,NULL,0,1,0,0,32,0,-1,'0',0,1)
 ,(34,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/pages/attributes.php',0,NULL,0,1,0,2,27,0,-1,'0',0,1)
 ,(35,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/pages/single.php',0,NULL,0,1,0,3,27,0,-1,'0',0,1)
 ,(36,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/workflow/view.php',0,NULL,0,1,2,6,2,0,-1,'0',0,1)
 ,(37,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/workflow/list.php',0,NULL,0,1,0,0,36,0,-1,'0',0,1)
 ,(38,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/workflow/me.php',0,NULL,0,1,0,1,36,0,-1,'0',0,1)
 ,(39,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/blocks/view.php',0,NULL,0,1,3,7,2,0,-1,'0',0,1)
 ,(40,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/blocks/stacks/view.php',0,NULL,0,1,1,0,39,0,-1,'0',0,1)
 ,(41,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/blocks/permissions.php',0,NULL,0,1,0,1,39,0,-1,'0',0,1)
 ,(42,0,1,0,NULL,NULL,NULL,1,42,'OVERRIDE','/dashboard/blocks/stacks/list/view.php',0,NULL,0,1,0,0,40,0,-1,'0',0,1)
 ,(43,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/blocks/types/view.php',0,NULL,0,1,0,2,39,0,-1,'0',0,1)
 ,(44,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/extend/view.php',0,NULL,0,1,5,8,2,0,-1,'0',0,1)
 ,(45,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/news.php',0,NULL,0,1,0,9,2,0,-1,'0',0,1)
 ,(46,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/extend/install.php',0,NULL,0,1,0,0,44,0,-1,'0',0,1)
 ,(47,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/extend/update.php',0,NULL,0,1,0,1,44,0,-1,'0',0,1)
 ,(48,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/extend/connect.php',0,NULL,0,1,0,2,44,0,-1,'0',0,1)
 ,(49,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/extend/themes.php',0,NULL,0,1,0,3,44,0,-1,'0',0,1)
 ,(50,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/extend/add-ons.php',0,NULL,0,1,0,4,44,0,-1,'0',0,1)
 ,(51,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/system/view.php',0,NULL,0,1,9,10,2,0,-1,'0',0,1)
 ,(52,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/system/basics/view.php',0,NULL,0,1,6,0,51,0,-1,'0',0,1)
 ,(53,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/system/basics/site_name.php',0,NULL,0,1,0,0,52,0,-1,'0',0,1)
 ,(54,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/system/basics/icons.php',0,NULL,0,1,0,1,52,0,-1,'0',0,1)
 ,(55,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/system/basics/editor.php',0,NULL,0,1,0,2,52,0,-1,'0',0,1)
 ,(56,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/system/basics/multilingual/view.php',0,NULL,0,1,0,3,52,0,-1,'0',0,1)
 ,(57,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/system/basics/timezone.php',0,NULL,0,1,0,4,52,0,-1,'0',0,1)
 ,(58,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/system/basics/interface.php',0,NULL,0,1,0,5,52,0,-1,'0',0,1)
 ,(59,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/system/seo/view.php',0,NULL,0,1,6,1,51,0,-1,'0',0,1)
 ,(60,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/system/seo/urls.php',0,NULL,0,1,0,0,59,0,-1,'0',0,1)
 ,(61,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/system/seo/bulk_seo_tool.php',0,NULL,0,1,0,1,59,0,-1,'0',0,1)
 ,(62,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/system/seo/tracking_codes.php',0,NULL,0,1,0,2,59,0,-1,'0',0,1)
 ,(63,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/system/seo/excluded.php',0,NULL,0,1,0,3,59,0,-1,'0',0,1)
 ,(64,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/system/seo/statistics.php',0,NULL,0,1,0,4,59,0,-1,'0',0,1)
 ,(65,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/system/seo/search_index.php',0,NULL,0,1,0,5,59,0,-1,'0',0,1)
 ,(66,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/system/optimization/view.php',0,NULL,0,1,3,2,51,0,-1,'0',0,1)
 ,(67,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/system/optimization/cache.php',0,NULL,0,1,0,0,66,0,-1,'0',0,1)
 ,(68,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/system/optimization/clear_cache.php',0,NULL,0,1,0,1,66,0,-1,'0',0,1)
 ,(69,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/system/optimization/jobs.php',0,NULL,0,1,0,2,66,0,-1,'0',0,1)
 ,(70,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/system/permissions/view.php',0,NULL,0,1,10,3,51,0,-1,'0',0,1)
 ,(71,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/system/permissions/site.php',0,NULL,0,1,0,0,70,0,-1,'0',0,1)
 ,(72,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/system/permissions/files.php',0,NULL,0,1,0,1,70,0,-1,'0',0,1)
 ,(73,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/system/permissions/file_types.php',0,NULL,0,1,0,2,70,0,-1,'0',0,1)
 ,(74,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/system/permissions/tasks.php',0,NULL,0,1,0,3,70,0,-1,'0',0,1)
 ,(75,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/system/permissions/users.php',0,NULL,0,1,0,4,70,0,-1,'0',0,1)
 ,(76,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/system/permissions/advanced.php',0,NULL,0,1,0,5,70,0,-1,'0',0,1)
 ,(77,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/system/permissions/ip_blacklist.php',0,NULL,0,1,0,6,70,0,-1,'0',0,1)
 ,(78,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/system/permissions/captcha.php',0,NULL,0,1,0,7,70,0,-1,'0',0,1)
 ,(79,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/system/permissions/antispam.php',0,NULL,0,1,0,8,70,0,-1,'0',0,1)
 ,(80,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/system/permissions/maintenance_mode.php',0,NULL,0,1,0,9,70,0,-1,'0',0,1)
 ,(81,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/system/registration/view.php',0,NULL,0,1,3,4,51,0,-1,'0',0,1)
 ,(82,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/system/registration/postlogin.php',0,NULL,0,1,0,0,81,0,-1,'0',0,1)
 ,(83,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/system/registration/profiles.php',0,NULL,0,1,0,1,81,0,-1,'0',0,1)
 ,(84,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/system/registration/public_registration.php',0,NULL,0,1,0,2,81,0,-1,'0',0,1)
 ,(85,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/system/mail/view.php',0,NULL,0,1,2,5,51,0,-1,'0',0,1)
 ,(86,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/system/mail/method.php',0,NULL,0,1,1,0,85,0,-1,'0',0,1)
 ,(87,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/system/mail/method/test_settings.php',0,NULL,0,1,0,0,86,0,-1,'0',0,1)
 ,(88,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/system/mail/importers.php',0,NULL,0,1,0,1,85,0,-1,'0',0,1)
 ,(89,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/system/attributes/view.php',0,NULL,0,1,2,6,51,0,-1,'0',0,1)
 ,(90,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/system/attributes/sets.php',0,NULL,0,1,0,0,89,0,-1,'0',0,1)
 ,(91,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/system/attributes/types.php',0,NULL,0,1,0,1,89,0,-1,'0',0,1)
 ,(92,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/system/environment/view.php',0,NULL,0,1,5,7,51,0,-1,'0',0,1)
 ,(93,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/system/environment/info.php',0,NULL,0,1,0,0,92,0,-1,'0',0,1)
 ,(94,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/system/environment/debug.php',0,NULL,0,1,0,1,92,0,-1,'0',0,1)
 ,(95,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/system/environment/logging.php',0,NULL,0,1,0,2,92,0,-1,'0',0,1)
 ,(96,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/system/environment/file_storage_locations.php',0,NULL,0,1,0,3,92,0,-1,'0',0,1)
 ,(97,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/system/environment/proxy.php',0,NULL,0,1,0,4,92,0,-1,'0',0,1)
 ,(98,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/system/backup_restore/view.php',0,NULL,0,1,3,8,51,0,-1,'0',0,1)
 ,(99,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/system/backup_restore/backup.php',0,NULL,0,1,0,0,98,0,-1,'0',0,1)
 ,(100,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/system/backup_restore/update.php',0,NULL,0,1,0,1,98,0,-1,'0',0,1)
 ,(101,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/system/backup_restore/database.php',0,NULL,0,1,0,2,98,0,-1,'0',0,1)
 ,(102,0,1,0,NULL,NULL,NULL,1,2,'PARENT','/dashboard/pages/types/composer.php',0,NULL,0,1,0,1,32,0,-1,'0',0,1)
 ,(103,1,NULL,0,NULL,NULL,NULL,1,0,'PARENT',NULL,0,NULL,0,1,0,0,0,0,-1,'0',0,0)
 ,(104,1,NULL,0,NULL,NULL,NULL,1,0,'PARENT',NULL,0,NULL,0,1,0,0,0,0,-1,'0',0,0)
 ,(105,1,NULL,0,NULL,NULL,NULL,1,0,'PARENT',NULL,0,NULL,0,1,0,0,0,0,-1,'0',0,0)
 ,(106,0,1,0,NULL,NULL,NULL,1,2,'PARENT',NULL,0,NULL,0,1,0,11,2,0,-1,'0',0,1)
 ,(107,0,1,0,NULL,NULL,NULL,1,2,'PARENT',NULL,0,NULL,0,1,0,12,2,0,-1,'0',0,1)
 ,(108,0,1,0,NULL,NULL,NULL,1,1,'PARENT','/!drafts/view.php',0,NULL,0,1,0,0,0,0,-1,'0',0,1)
 ,(109,0,1,0,NULL,NULL,NULL,1,1,'PARENT','/!trash/view.php',0,NULL,0,1,0,0,0,0,-1,'0',0,1)
 ,(110,0,1,0,NULL,NULL,NULL,1,1,'PARENT','/!stacks/view.php',0,NULL,0,1,2,0,0,0,-1,'0',0,1)
 ,(111,0,1,0,NULL,NULL,NULL,1,111,'OVERRIDE','/login.php',0,NULL,0,1,0,0,0,0,-1,'0',0,1)
 ,(112,0,1,0,NULL,NULL,NULL,1,112,'OVERRIDE','/register.php',0,NULL,0,1,0,0,0,0,-1,'0',0,1)
 ,(113,0,1,0,NULL,NULL,NULL,1,1,'PARENT','/profile/view.php',0,NULL,0,1,4,0,1,0,-1,'0',0,1)
 ,(114,0,1,0,NULL,NULL,NULL,1,1,'PARENT','/profile/edit.php',0,NULL,0,1,0,0,113,0,-1,'0',0,1)
 ,(115,0,1,0,NULL,NULL,NULL,1,1,'PARENT','/profile/avatar.php',0,NULL,0,1,0,1,113,0,-1,'0',0,1)
 ,(116,0,1,0,NULL,NULL,NULL,1,1,'PARENT','/profile/messages.php',0,NULL,0,1,0,2,113,0,-1,'0',0,1)
 ,(117,0,1,0,NULL,NULL,NULL,1,1,'PARENT','/profile/friends.php',0,NULL,0,1,0,3,113,0,-1,'0',0,1)
 ,(118,0,1,0,NULL,NULL,NULL,1,1,'PARENT','/page_not_found.php',0,NULL,0,1,0,1,0,0,-1,'0',0,1)
 ,(119,0,1,0,NULL,NULL,NULL,1,1,'PARENT','/page_forbidden.php',0,NULL,0,1,0,1,0,0,-1,'0',0,1)
 ,(120,0,1,0,NULL,NULL,NULL,1,1,'PARENT','/download_file.php',0,NULL,0,1,0,1,1,0,-1,'0',0,1)
 ,(121,1,NULL,0,NULL,NULL,NULL,1,0,'PARENT',NULL,0,NULL,0,1,0,0,0,0,-1,'0',0,0)
 ,(122,0,1,0,NULL,NULL,NULL,1,1,'PARENT',NULL,0,NULL,0,1,0,0,110,0,-1,'0',0,1)
 ,(123,0,1,0,NULL,NULL,NULL,1,1,'PARENT',NULL,0,NULL,0,1,0,1,110,0,-1,'0',0,1)
 ,(124,0,1,0,NULL,NULL,NULL,1,1,'PARENT',NULL,0,NULL,0,1,0,2,1,0,-1,'0',0,0)
 ,(125,0,1,0,NULL,NULL,NULL,1,1,'PARENT',NULL,0,NULL,0,1,0,3,1,0,-1,'0',0,0)
 ,(126,0,1,0,NULL,NULL,NULL,1,1,'PARENT',NULL,0,NULL,0,1,0,4,1,0,-1,'0',0,0)
 ,(127,0,1,0,NULL,NULL,NULL,1,1,'PARENT',NULL,0,NULL,0,1,0,5,1,0,-1,'0',0,0)
 ,(128,0,1,0,NULL,NULL,NULL,1,1,'PARENT',NULL,0,NULL,0,1,0,6,1,0,-1,'0',0,0)
 ,(129,0,1,0,NULL,NULL,NULL,1,1,'PARENT',NULL,0,NULL,0,1,0,7,1,0,-1,'0',0,0)
 ,(130,0,1,0,NULL,NULL,NULL,1,1,'PARENT',NULL,0,NULL,0,1,0,8,1,0,-1,'0',0,0)
 ,(131,1,NULL,0,NULL,NULL,NULL,1,0,'PARENT',NULL,0,NULL,0,1,0,0,0,0,-1,'0',0,0)
 ,(132,1,NULL,0,NULL,NULL,NULL,1,0,'PARENT',NULL,0,NULL,0,1,0,0,0,0,-1,'0',0,0);

DROP TABLE IF EXISTS PermissionAccess;

CREATE TABLE IF NOT EXISTS `PermissionAccess` (
  `paID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `paIsInUse` int(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`paID`)
) ENGINE=InnoDB AUTO_INCREMENT=69 DEFAULT CHARSET=utf8;

INSERT INTO PermissionAccess VALUES(1,1)
 ,(2,1)
 ,(3,1)
 ,(4,1)
 ,(5,1)
 ,(6,1)
 ,(7,1)
 ,(8,1)
 ,(9,1)
 ,(10,1)
 ,(11,1)
 ,(12,1)
 ,(13,1)
 ,(14,1)
 ,(15,1)
 ,(16,1)
 ,(17,1)
 ,(18,1)
 ,(19,1)
 ,(20,1)
 ,(21,1)
 ,(22,1)
 ,(23,1)
 ,(24,1)
 ,(25,1)
 ,(26,1)
 ,(27,1)
 ,(28,1)
 ,(29,1)
 ,(30,1)
 ,(31,1)
 ,(32,1)
 ,(33,1)
 ,(34,1)
 ,(35,1)
 ,(36,1)
 ,(37,1)
 ,(38,1)
 ,(39,1)
 ,(40,1)
 ,(41,1)
 ,(42,1)
 ,(43,1)
 ,(44,1)
 ,(45,1)
 ,(46,1)
 ,(47,1)
 ,(48,1)
 ,(49,1)
 ,(50,1)
 ,(51,1)
 ,(52,1)
 ,(53,1)
 ,(54,1)
 ,(55,1)
 ,(56,1)
 ,(57,1)
 ,(58,1)
 ,(59,1)
 ,(60,1)
 ,(61,1)
 ,(62,1)
 ,(63,1)
 ,(64,1)
 ,(65,1)
 ,(66,1)
 ,(67,1)
 ,(68,1);

DROP TABLE IF EXISTS PermissionAccessEntities;

CREATE TABLE IF NOT EXISTS `PermissionAccessEntities` (
  `peID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `petID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`peID`),
  KEY `petID` (`petID`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO PermissionAccessEntities VALUES(1,1)
 ,(2,1)
 ,(3,1)
 ,(4,5)
 ,(5,6);

DROP TABLE IF EXISTS PermissionAccessEntityGroupSets;

CREATE TABLE IF NOT EXISTS `PermissionAccessEntityGroupSets` (
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `gsID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`peID`,`gsID`),
  KEY `gsID` (`gsID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS PermissionAccessEntityGroups;

CREATE TABLE IF NOT EXISTS `PermissionAccessEntityGroups` (
  `pegID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `gID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`pegID`),
  KEY `gID` (`gID`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO PermissionAccessEntityGroups VALUES(1,1,3)
 ,(2,2,1)
 ,(3,3,2);

DROP TABLE IF EXISTS PermissionAccessEntityTypeCategories;

CREATE TABLE IF NOT EXISTS `PermissionAccessEntityTypeCategories` (
  `petID` int(10) unsigned NOT NULL DEFAULT '0',
  `pkCategoryID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`petID`,`pkCategoryID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO PermissionAccessEntityTypeCategories VALUES(1,1)
 ,(1,5)
 ,(1,6)
 ,(1,7)
 ,(1,8)
 ,(1,9)
 ,(1,10)
 ,(1,11)
 ,(1,12)
 ,(1,13)
 ,(1,14)
 ,(2,1)
 ,(2,5)
 ,(2,6)
 ,(2,7)
 ,(2,8)
 ,(2,9)
 ,(2,10)
 ,(2,11)
 ,(2,12)
 ,(2,13)
 ,(2,14)
 ,(3,1)
 ,(3,5)
 ,(3,6)
 ,(3,7)
 ,(3,8)
 ,(3,9)
 ,(3,10)
 ,(3,11)
 ,(3,12)
 ,(3,13)
 ,(3,14)
 ,(4,1)
 ,(4,5)
 ,(4,6)
 ,(4,7)
 ,(4,8)
 ,(4,9)
 ,(4,10)
 ,(4,11)
 ,(4,12)
 ,(4,13)
 ,(4,14)
 ,(5,1)
 ,(6,6)
 ,(6,7);

DROP TABLE IF EXISTS PermissionAccessEntityTypes;

CREATE TABLE IF NOT EXISTS `PermissionAccessEntityTypes` (
  `petID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `petHandle` varchar(255) NOT NULL,
  `petName` varchar(255) NOT NULL,
  `pkgID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`petID`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

INSERT INTO PermissionAccessEntityTypes VALUES(1,'group','Group',0)
 ,(2,'user','User',0)
 ,(3,'group_set','Group Set',0)
 ,(4,'group_combination','Group Combination',0)
 ,(5,'page_owner','Page Owner',0)
 ,(6,'file_uploader','File Uploader',0);

DROP TABLE IF EXISTS PermissionAccessEntityUsers;

CREATE TABLE IF NOT EXISTS `PermissionAccessEntityUsers` (
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `uID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`peID`,`uID`),
  KEY `uID` (`uID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS PermissionAccessList;

CREATE TABLE IF NOT EXISTS `PermissionAccessList` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `pdID` int(10) unsigned NOT NULL DEFAULT '0',
  `accessType` int(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`paID`,`peID`),
  KEY `accessType` (`accessType`),
  KEY `peID` (`peID`),
  KEY `peID_accessType` (`peID`,`accessType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO PermissionAccessList VALUES(1,1,0,10)
 ,(2,1,0,10)
 ,(3,1,0,10)
 ,(4,1,0,10)
 ,(5,1,0,10)
 ,(6,1,0,10)
 ,(7,1,0,10)
 ,(8,1,0,10)
 ,(9,1,0,10)
 ,(10,1,0,10)
 ,(11,1,0,10)
 ,(12,1,0,10)
 ,(13,1,0,10)
 ,(14,1,0,10)
 ,(15,1,0,10)
 ,(16,1,0,10)
 ,(17,1,0,10)
 ,(18,1,0,10)
 ,(19,1,0,10)
 ,(20,1,0,10)
 ,(21,1,0,10)
 ,(22,1,0,10)
 ,(23,1,0,10)
 ,(24,1,0,10)
 ,(25,1,0,10)
 ,(26,1,0,10)
 ,(27,1,0,10)
 ,(28,1,0,10)
 ,(29,1,0,10)
 ,(30,1,0,10)
 ,(31,1,0,10)
 ,(32,1,0,10)
 ,(33,1,0,10)
 ,(34,1,0,10)
 ,(35,2,0,10)
 ,(36,2,0,10)
 ,(37,2,0,10)
 ,(38,2,0,10)
 ,(39,2,0,10)
 ,(39,3,0,10)
 ,(40,2,0,10)
 ,(40,3,0,10)
 ,(41,2,0,10)
 ,(42,2,0,10)
 ,(43,2,0,10)
 ,(44,1,0,10)
 ,(44,2,0,10)
 ,(45,1,0,10)
 ,(46,1,0,10)
 ,(47,1,0,10)
 ,(48,1,0,10)
 ,(49,1,0,10)
 ,(50,1,0,10)
 ,(51,1,0,10)
 ,(52,1,0,10)
 ,(53,2,0,10)
 ,(54,1,0,10)
 ,(55,1,0,10)
 ,(56,1,0,10)
 ,(57,1,0,10)
 ,(58,1,0,10)
 ,(59,1,0,10)
 ,(60,1,0,10)
 ,(61,1,0,10)
 ,(62,1,0,10)
 ,(63,1,0,10)
 ,(64,1,0,10)
 ,(65,1,0,10)
 ,(66,1,0,10)
 ,(67,1,0,10)
 ,(68,1,0,10);

DROP TABLE IF EXISTS PermissionAccessWorkflows;

CREATE TABLE IF NOT EXISTS `PermissionAccessWorkflows` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `wfID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`paID`,`wfID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS PermissionAssignments;

CREATE TABLE IF NOT EXISTS `PermissionAssignments` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `pkID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`paID`,`pkID`),
  KEY `pkID` (`pkID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO PermissionAssignments VALUES(1,17)
 ,(2,18)
 ,(3,55)
 ,(4,56)
 ,(5,57)
 ,(6,58)
 ,(7,60)
 ,(8,61)
 ,(9,62)
 ,(10,63)
 ,(11,64)
 ,(12,66)
 ,(13,67)
 ,(14,68)
 ,(15,69)
 ,(16,70)
 ,(17,71)
 ,(18,72);

DROP TABLE IF EXISTS PermissionDurationObjects;

CREATE TABLE IF NOT EXISTS `PermissionDurationObjects` (
  `pdID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pdObject` text,
  PRIMARY KEY (`pdID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS PermissionKeyCategories;

CREATE TABLE IF NOT EXISTS `PermissionKeyCategories` (
  `pkCategoryID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pkCategoryHandle` varchar(255) NOT NULL,
  `pkgID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`pkCategoryID`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8;

INSERT INTO PermissionKeyCategories VALUES(1,'page',NULL)
 ,(2,'single_page',NULL)
 ,(3,'stack',NULL)
 ,(4,'composer_page',NULL)
 ,(5,'user',NULL)
 ,(6,'file_set',NULL)
 ,(7,'file',NULL)
 ,(8,'area',NULL)
 ,(9,'block_type',NULL)
 ,(10,'block',NULL)
 ,(11,'admin',NULL)
 ,(12,'sitemap',NULL)
 ,(13,'marketplace_newsflow',NULL)
 ,(14,'basic_workflow',NULL);

DROP TABLE IF EXISTS PermissionKeys;

CREATE TABLE IF NOT EXISTS `PermissionKeys` (
  `pkID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pkHandle` varchar(255) NOT NULL,
  `pkName` varchar(255) NOT NULL,
  `pkCanTriggerWorkflow` int(1) NOT NULL DEFAULT '0',
  `pkHasCustomClass` int(1) NOT NULL DEFAULT '0',
  `pkDescription` varchar(255) DEFAULT NULL,
  `pkCategoryID` int(10) unsigned DEFAULT NULL,
  `pkgID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`pkID`),
  UNIQUE KEY `akHandle` (`pkHandle`)
) ENGINE=InnoDB AUTO_INCREMENT=73 DEFAULT CHARSET=utf8;

INSERT INTO PermissionKeys VALUES(1,'view_page','View',0,0,'Can see a page exists and read its content.',1,0)
 ,(2,'view_page_versions','View Versions',0,0,'Can view the page versions dialog and read past versions of a page.',1,0)
 ,(3,'view_page_in_sitemap','View Page in Sitemap',0,0,'Controls whether a user can see a page in the sitemap or intelligent search.',1,0)
 ,(4,'preview_page_as_user','Preview Page As User',0,0,'Ability to see what this page will look like at a specific time in the future as a specific user.',1,0)
 ,(5,'edit_page_properties','Edit Properties',0,1,'Ability to change anything in the Page Properties menu.',1,0)
 ,(6,'edit_page_contents','Edit Contents',0,0,'Ability to make edits to at least some of the content in the page. You can lock down different block areas and specific blocks by clicking Permissions on them as well. ',1,0)
 ,(7,'edit_page_speed_settings','Edit Speed Settings',0,0,'Ability to change caching settings.',1,0)
 ,(8,'edit_page_theme','Change Theme',0,1,'Ability to change just the theme for this page.',1,0)
 ,(9,'edit_page_type','Change Page Type',0,0,'Ability to change just the page type for this page, also check out Theme permissions.',1,0)
 ,(10,'edit_page_permissions','Edit Permissions',1,0,'Ability to change permissions for this page. Warning: by granting this a user could give themselves more access.',1,0)
 ,(11,'delete_page','Delete',1,0,'Ability to move this page to the site\'s Trash.',1,0)
 ,(12,'delete_page_versions','Delete Versions',1,0,'Ability to remove old versions of this page.',1,0)
 ,(13,'approve_page_versions','Approve Changes',1,0,'Can publish an unapproved version of the page.',1,0)
 ,(14,'add_subpage','Add Sub-Page',0,1,'Can add a page beneath the current page.',1,0)
 ,(15,'move_or_copy_page','Move or Copy Page',1,0,'Can move or copy this page to another location.',1,0)
 ,(16,'schedule_page_contents_guest_access','Schedule Guest Access',0,0,'Can control scheduled guest access to this page.',1,0)
 ,(17,'add_block','Add Block',0,1,'Can add a block to any area on the site. If someone is added here they can add blocks to any area (unless that area has permissions that override these global permissions.)',9,0)
 ,(18,'add_stack','Add Stack',0,0,'Can add a stack or block from a stack to any area on the site. If someone is added here they can add stacks to any area (unless that area has permissions that override these global permissions.)',9,0)
 ,(19,'view_area','View Area',0,0,'Can view the area and its contents.',8,0)
 ,(20,'edit_area_contents','Edit Area Contents',0,0,'Can edit blocks within this area.',8,0)
 ,(21,'add_block_to_area','Add Block to Area',0,1,'Can add blocks to this area. This setting overrides the global Add Block permission for this area.',8,0)
 ,(22,'add_stack_to_area','Add Stack to Area',0,0,'Can add stacks to this area. This setting overrides the global Add Stack permission for this area.',8,0)
 ,(23,'add_layout_to_area','Add Layouts to Area',0,0,'Controls whether users get the ability to add layouts to a particular area.',8,0)
 ,(24,'edit_area_design','Edit Area Design',0,0,'Controls whether users see design controls and can modify an area\'s custom CSS.',8,0)
 ,(25,'edit_area_permissions','Edit Area Permissions',0,0,'Controls whether users can access the permissions on an area. Custom area permissions could override those of the page.',8,0)
 ,(26,'delete_area_contents','Delete Area Contents',0,0,'Controls whether users can delete blocks from this area.',8,0)
 ,(27,'schedule_area_contents_guest_access','Schedule Guest Access',0,0,'Controls whether users can schedule guest access permissions on blocks in this area. Guest Access is a shortcut for granting permissions just to the Guest Group.',8,0)
 ,(28,'view_block','View Block',0,0,'Controls whether users can view this block in the page.',10,0)
 ,(29,'edit_block','Edit Block',0,0,'Controls whether users can edit this block. This overrides any area or page permissions.',10,0)
 ,(30,'edit_block_custom_template','Change Custom Template',0,0,'Controls whether users can change the custom template on this block. This overrides any area or page permissions.',10,0)
 ,(31,'delete_block','Delete Block',0,0,'Controls whether users can delete this block. This overrides any area or page permissions.',10,0)
 ,(32,'edit_block_design','Edit Design',0,0,'Controls whether users can set custom design properties or CSS on this block.',10,0)
 ,(33,'edit_block_permissions','Edit Permissions',0,0,'Controls whether users can change permissions on this block, potentially granting themselves or others greater access.',10,0)
 ,(34,'schedule_guest_access','Schedule Guest Access',0,0,'Controls whether users can schedule guest access permissions on this block. Guest Access is a shortcut for granting permissions just to the Guest Group.',10,0)
 ,(35,'view_file_set_file','View Files',0,0,'Can view and download files in the site.',6,0)
 ,(36,'search_file_set','Search Files in File Manager',0,0,'Can access the file manager',6,0)
 ,(37,'edit_file_set_file_properties','Edit File Properties',0,0,'Can edit a file\'s properties.',6,0)
 ,(38,'edit_file_set_file_contents','Edit File Contents',0,0,'Can edit or replace files in set.',6,0)
 ,(39,'copy_file_set_files','Copy File',0,0,'Can copy files in file set.',6,0)
 ,(40,'edit_file_set_permissions','Edit File Access',0,0,'Can edit access to file sets.',6,0)
 ,(41,'delete_file_set','Delete File Set',0,0,'Can delete file set.',6,0)
 ,(42,'delete_file_set_files','Delete File',0,0,'Can delete files in set.',6,0)
 ,(43,'add_file','Add File',0,1,'Can add files to set.',6,0)
 ,(44,'view_file','View Files',0,0,'Can view and download files.',7,0)
 ,(45,'view_file_in_file_manager','View File in File Manager',0,0,'Can access the File Manager.',7,0)
 ,(46,'edit_file_properties','Edit File Properties',0,0,'Can edit a file\'s properties.',7,0)
 ,(47,'edit_file_contents','Edit File Contents',0,0,'Can edit or replace files.',7,0)
 ,(48,'copy_file','Copy File',0,0,'Can copy file.',7,0)
 ,(49,'edit_file_permissions','Edit File Access',0,0,'Can edit access to file.',7,0)
 ,(50,'delete_file','Delete File',0,0,'Can delete file.',7,0)
 ,(51,'approve_basic_workflow_action','Approve or Deny',0,0,'Grant ability to approve workflow.',14,0)
 ,(52,'notify_on_basic_workflow_entry','Notify on Entry',0,0,'Notify approvers that a change has entered the workflow.',14,0)
 ,(53,'notify_on_basic_workflow_approve','Notify on Approve',0,0,'Notify approvers that a change has been approved.',14,0)
 ,(54,'notify_on_basic_workflow_deny','Notify on Deny',0,0,'Notify approvers that a change has been denied.',14,0)
 ,(55,'access_user_search','Access User Search',0,1,'',5,0)
 ,(56,'edit_user_properties','Edit User Details',0,1,NULL,5,0)
 ,(57,'view_user_attributes','View User Attributes',0,1,NULL,5,0)
 ,(58,'activate_user','Activate/Deactivate User',0,0,NULL,5,0)
 ,(59,'sudo','Sign in as User',0,0,NULL,5,0)
 ,(60,'delete_user','Delete User',0,0,NULL,5,0)
 ,(61,'access_group_search','Access Group Search',0,0,'',5,0)
 ,(62,'edit_groups','Edit Groups',0,0,'',5,0)
 ,(63,'assign_user_groups','Assign Groups to User',0,1,'',5,0)
 ,(64,'backup','Perform Backups',0,0,NULL,11,0)
 ,(65,'access_task_permissions','Access Task Permissions',0,0,NULL,11,0)
 ,(66,'access_sitemap','Access Sitemap',0,0,NULL,12,0)
 ,(67,'access_page_defaults','Access Page Type Defaults',0,0,NULL,11,0)
 ,(68,'empty_trash','Empty Trash',0,0,NULL,11,0)
 ,(69,'uninstall_packages','Uninstall Packages',0,0,NULL,13,0)
 ,(70,'install_packages','Install Packages',0,0,NULL,13,0)
 ,(71,'view_newsflow','View Newsflow',0,0,NULL,13,0)
 ,(72,'access_user_search_export','Export Site Users',0,0,'Controls whether a user can export site users or not',5,0);

DROP TABLE IF EXISTS PileContents;

CREATE TABLE IF NOT EXISTS `PileContents` (
  `pcID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pID` int(10) unsigned NOT NULL DEFAULT '0',
  `itemID` int(10) unsigned NOT NULL DEFAULT '0',
  `itemType` varchar(64) NOT NULL,
  `quantity` int(10) unsigned NOT NULL DEFAULT '1',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `displayOrder` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`pcID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS Piles;

CREATE TABLE IF NOT EXISTS `Piles` (
  `pID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uID` int(10) unsigned DEFAULT NULL,
  `isDefault` tinyint(1) NOT NULL DEFAULT '0',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `name` varchar(255) DEFAULT NULL,
  `state` varchar(64) NOT NULL,
  PRIMARY KEY (`pID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS QueueMessages;

CREATE TABLE IF NOT EXISTS `QueueMessages` (
  `message_id` int(20) unsigned NOT NULL AUTO_INCREMENT,
  `queue_id` int(10) unsigned NOT NULL,
  `handle` varchar(32) DEFAULT NULL,
  `body` longtext,
  `md5` varchar(32) NOT NULL,
  `timeout` decimal(14,0) unsigned DEFAULT NULL,
  `created` int(10) unsigned NOT NULL,
  PRIMARY KEY (`message_id`),
  UNIQUE KEY `message_handle` (`handle`),
  KEY `message_queueid` (`queue_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS QueuePageDuplicationRelations;

CREATE TABLE IF NOT EXISTS `QueuePageDuplicationRelations` (
  `queue_name` varchar(255) NOT NULL,
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `originalCID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cID`,`originalCID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS Queues;

CREATE TABLE IF NOT EXISTS `Queues` (
  `queue_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `queue_name` varchar(100) NOT NULL,
  `timeout` int(5) unsigned NOT NULL DEFAULT '30',
  PRIMARY KEY (`queue_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS SignupRequests;

CREATE TABLE IF NOT EXISTS `SignupRequests` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ipFrom` int(10) unsigned NOT NULL DEFAULT '0',
  `date_access` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_ipFrom` (`ipFrom`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS Stacks;

CREATE TABLE IF NOT EXISTS `Stacks` (
  `stID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `stName` varchar(255) NOT NULL,
  `stType` int(1) unsigned NOT NULL DEFAULT '0',
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`stID`),
  KEY `stType` (`stType`),
  KEY `stName` (`stName`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO Stacks VALUES(1,'Badges',20,122)
 ,(2,'Map',20,123);

DROP TABLE IF EXISTS SystemAntispamLibraries;

CREATE TABLE IF NOT EXISTS `SystemAntispamLibraries` (
  `saslHandle` varchar(64) NOT NULL,
  `saslName` varchar(255) DEFAULT NULL,
  `saslIsActive` int(1) NOT NULL DEFAULT '0',
  `pkgID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`saslHandle`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS SystemCaptchaLibraries;

CREATE TABLE IF NOT EXISTS `SystemCaptchaLibraries` (
  `sclHandle` varchar(64) NOT NULL,
  `sclName` varchar(255) DEFAULT NULL,
  `sclIsActive` int(1) NOT NULL DEFAULT '0',
  `pkgID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`sclHandle`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO SystemCaptchaLibraries VALUES('securimage','SecurImage (Default)',1,0);

DROP TABLE IF EXISTS SystemNotifications;

CREATE TABLE IF NOT EXISTS `SystemNotifications` (
  `snID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `snTypeID` int(3) unsigned NOT NULL DEFAULT '0',
  `snURL` text,
  `snURL2` text,
  `snDateTime` datetime NOT NULL,
  `snIsArchived` int(1) NOT NULL DEFAULT '0',
  `snIsNew` int(1) NOT NULL DEFAULT '0',
  `snTitle` varchar(255) DEFAULT NULL,
  `snDescription` text,
  `snBody` text,
  PRIMARY KEY (`snID`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO SystemNotifications VALUES(1,10,'/lowther-house/index.php/dashboard/system/backup_restore/update/',NULL,'2016-05-21 13:53:37',0,1,'A new version of concrete5 is now available.','','\n\n                <h2>5.6.3.4 Release Notes</h2>\n\n                <p>\n                    Version 5.6.3.4 is a maintenance release for concrete5 5.6. It fixes bugs.\n                    </p>	\n\n                <h3><a href=\"http://www.concrete5.org/documentation/background/version_history/5-6-3-4-release-notes/\" target=\"_blank\">Full 5.6.3.4 Release Notes</a></h3>\n\n\n                ')
 ,(2,10,'/lowther-house/index.php/dashboard/system/backup_restore/update/',NULL,'2016-05-29 15:07:45',0,1,'A new version of concrete5 is now available.','','\n\n                <h2>5.6.3.4 Release Notes</h2>\n\n                <p>\n                    Version 5.6.3.4 is a maintenance release for concrete5 5.6. It fixes bugs.\n                    </p>	\n\n                <h3><a href=\"http://www.concrete5.org/documentation/background/version_history/5-6-3-4-release-notes/\" target=\"_blank\">Full 5.6.3.4 Release Notes</a></h3>\n\n\n                ')
 ,(3,10,'/lowther-house/index.php/dashboard/system/backup_restore/update/',NULL,'2016-05-31 22:32:43',0,1,'A new version of concrete5 is now available.','','\n\n                <h2>5.6.3.4 Release Notes</h2>\n\n                <p>\n                    Version 5.6.3.4 is a maintenance release for concrete5 5.6. It fixes bugs.\n                    </p>	\n\n                <h3><a href=\"http://www.concrete5.org/documentation/background/version_history/5-6-3-4-release-notes/\" target=\"_blank\">Full 5.6.3.4 Release Notes</a></h3>\n\n\n                ')
 ,(4,10,'/lowther-house/index.php/dashboard/system/backup_restore/update/',NULL,'2016-06-04 14:56:54',0,1,'A new version of concrete5 is now available.','','\n\n                <h2>5.6.3.4 Release Notes</h2>\n\n                <p>\n                    Version 5.6.3.4 is a maintenance release for concrete5 5.6. It fixes bugs.\n                    </p>	\n\n                <h3><a href=\"http://www.concrete5.org/documentation/background/version_history/5-6-3-4-release-notes/\" target=\"_blank\">Full 5.6.3.4 Release Notes</a></h3>\n\n\n                ');

DROP TABLE IF EXISTS UserAttributeKeys;

CREATE TABLE IF NOT EXISTS `UserAttributeKeys` (
  `akID` int(10) unsigned NOT NULL,
  `uakProfileDisplay` tinyint(1) NOT NULL DEFAULT '0',
  `uakMemberListDisplay` tinyint(1) NOT NULL DEFAULT '0',
  `uakProfileEdit` tinyint(1) NOT NULL DEFAULT '1',
  `uakProfileEditRequired` tinyint(1) NOT NULL DEFAULT '0',
  `uakRegisterEdit` tinyint(1) NOT NULL DEFAULT '0',
  `uakRegisterEditRequired` tinyint(1) NOT NULL DEFAULT '0',
  `displayOrder` int(10) unsigned DEFAULT '0',
  `uakIsActive` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`akID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO UserAttributeKeys VALUES(10,0,0,1,0,1,0,1,1)
 ,(11,0,0,1,0,1,0,2,1);

DROP TABLE IF EXISTS UserAttributeValues;

CREATE TABLE IF NOT EXISTS `UserAttributeValues` (
  `uID` int(10) unsigned NOT NULL DEFAULT '0',
  `akID` int(10) unsigned NOT NULL DEFAULT '0',
  `avID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`uID`,`akID`,`avID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS UserBannedIPs;

CREATE TABLE IF NOT EXISTS `UserBannedIPs` (
  `ipFrom` int(10) unsigned NOT NULL DEFAULT '0',
  `ipTo` int(10) unsigned NOT NULL DEFAULT '0',
  `banCode` int(1) unsigned NOT NULL DEFAULT '1',
  `expires` int(10) unsigned NOT NULL DEFAULT '0',
  `isManual` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ipFrom`,`ipTo`),
  KEY `ipFrom` (`ipFrom`),
  KEY `ipTo` (`ipTo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS UserGroups;

CREATE TABLE IF NOT EXISTS `UserGroups` (
  `uID` int(10) unsigned NOT NULL DEFAULT '0',
  `gID` int(10) unsigned NOT NULL DEFAULT '0',
  `ugEntered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `type` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`uID`,`gID`),
  KEY `uID` (`uID`),
  KEY `gID` (`gID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS UserOpenIDs;

CREATE TABLE IF NOT EXISTS `UserOpenIDs` (
  `uID` int(10) unsigned NOT NULL,
  `uOpenID` varchar(255) NOT NULL,
  PRIMARY KEY (`uOpenID`),
  KEY `uID` (`uID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS UserPermissionAssignGroupAccessList;

CREATE TABLE IF NOT EXISTS `UserPermissionAssignGroupAccessList` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `permission` varchar(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`paID`,`peID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS UserPermissionAssignGroupAccessListCustom;

CREATE TABLE IF NOT EXISTS `UserPermissionAssignGroupAccessListCustom` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `gID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`paID`,`peID`,`gID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS UserPermissionEditPropertyAccessList;

CREATE TABLE IF NOT EXISTS `UserPermissionEditPropertyAccessList` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `uName` int(1) unsigned DEFAULT '0',
  `uEmail` int(1) unsigned DEFAULT '0',
  `uPassword` int(1) unsigned DEFAULT '0',
  `uAvatar` int(1) unsigned DEFAULT '0',
  `uTimezone` int(1) unsigned DEFAULT '0',
  `uDefaultLanguage` int(1) unsigned DEFAULT '0',
  `attributePermission` varchar(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`paID`,`peID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS UserPermissionEditPropertyAttributeAccessListCustom;

CREATE TABLE IF NOT EXISTS `UserPermissionEditPropertyAttributeAccessListCustom` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `akID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`paID`,`peID`,`akID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS UserPermissionUserSearchAccessList;

CREATE TABLE IF NOT EXISTS `UserPermissionUserSearchAccessList` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `permission` varchar(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`paID`,`peID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS UserPermissionUserSearchAccessListCustom;

CREATE TABLE IF NOT EXISTS `UserPermissionUserSearchAccessListCustom` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `gID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`paID`,`peID`,`gID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS UserPermissionViewAttributeAccessList;

CREATE TABLE IF NOT EXISTS `UserPermissionViewAttributeAccessList` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `permission` varchar(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`paID`,`peID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS UserPermissionViewAttributeAccessListCustom;

CREATE TABLE IF NOT EXISTS `UserPermissionViewAttributeAccessListCustom` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `akID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`paID`,`peID`,`akID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS UserPointHistory;

CREATE TABLE IF NOT EXISTS `UserPointHistory` (
  `upID` int(11) NOT NULL AUTO_INCREMENT,
  `upuID` int(11) NOT NULL DEFAULT '0',
  `upaID` int(11) DEFAULT '0',
  `upPoints` int(11) DEFAULT '0',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`upID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS UserPrivateMessages;

CREATE TABLE IF NOT EXISTS `UserPrivateMessages` (
  `msgID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uAuthorID` int(10) unsigned NOT NULL DEFAULT '0',
  `msgDateCreated` datetime NOT NULL,
  `msgSubject` varchar(255) NOT NULL,
  `msgBody` text,
  `uToID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`msgID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS UserPrivateMessagesTo;

CREATE TABLE IF NOT EXISTS `UserPrivateMessagesTo` (
  `msgID` int(10) unsigned NOT NULL DEFAULT '0',
  `uID` int(10) unsigned NOT NULL DEFAULT '0',
  `uAuthorID` int(10) unsigned NOT NULL DEFAULT '0',
  `msgMailboxID` int(11) NOT NULL,
  `msgIsNew` int(1) NOT NULL DEFAULT '0',
  `msgIsUnread` int(1) NOT NULL DEFAULT '0',
  `msgIsReplied` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`msgID`,`uID`,`uAuthorID`),
  KEY `uID` (`uID`),
  KEY `uAuthorID` (`uAuthorID`),
  KEY `msgFolderID` (`msgMailboxID`),
  KEY `msgIsNew` (`msgIsNew`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS UserSearchIndexAttributes;

CREATE TABLE IF NOT EXISTS `UserSearchIndexAttributes` (
  `uID` int(11) unsigned NOT NULL DEFAULT '0',
  `ak_profile_private_messages_enabled` tinyint(4) DEFAULT '0',
  `ak_profile_private_messages_notification_enabled` tinyint(4) DEFAULT '0',
  PRIMARY KEY (`uID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS UserValidationHashes;

CREATE TABLE IF NOT EXISTS `UserValidationHashes` (
  `uvhID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uID` int(10) unsigned DEFAULT NULL,
  `uHash` varchar(64) NOT NULL,
  `type` int(4) unsigned NOT NULL DEFAULT '0',
  `uDateGenerated` int(10) unsigned NOT NULL DEFAULT '0',
  `uDateRedeemed` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`uvhID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS Users;

CREATE TABLE IF NOT EXISTS `Users` (
  `uID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uName` varchar(64) NOT NULL,
  `uEmail` varchar(255) NOT NULL,
  `uPassword` varchar(255) NOT NULL,
  `uIsActive` varchar(1) NOT NULL DEFAULT '0',
  `uIsValidated` tinyint(4) NOT NULL DEFAULT '-1',
  `uIsFullRecord` tinyint(1) NOT NULL DEFAULT '1',
  `uDateAdded` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `uHasAvatar` tinyint(1) NOT NULL DEFAULT '0',
  `uLastOnline` int(10) unsigned NOT NULL DEFAULT '0',
  `uLastLogin` int(10) unsigned NOT NULL DEFAULT '0',
  `uLastIP` bigint(10) NOT NULL DEFAULT '0',
  `uPreviousLogin` int(10) unsigned NOT NULL DEFAULT '0',
  `uNumLogins` int(10) unsigned NOT NULL DEFAULT '0',
  `uTimezone` varchar(255) DEFAULT NULL,
  `uDefaultLanguage` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`uID`),
  UNIQUE KEY `uName` (`uName`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO Users VALUES(1,'admin','david@dn-creative.com','$2a$12$AsB4iFb00TkB.gD5orchi.H3nkatjgq.N0Do24Ia1gDtNKSDOtHUu','1',-1,1,'2016-05-21 13:53:24',0,1465053550,1463831604,2130706433,0,1,NULL,NULL);

DROP TABLE IF EXISTS UsersFriends;

CREATE TABLE IF NOT EXISTS `UsersFriends` (
  `ufID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uID` int(10) unsigned DEFAULT NULL,
  `status` varchar(64) NOT NULL,
  `friendUID` int(10) unsigned DEFAULT NULL,
  `uDateAdded` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`ufID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS WorkflowProgress;

CREATE TABLE IF NOT EXISTS `WorkflowProgress` (
  `wpID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `wpCategoryID` int(10) unsigned DEFAULT NULL,
  `wfID` int(10) unsigned NOT NULL DEFAULT '0',
  `wpApproved` tinyint(1) NOT NULL DEFAULT '0',
  `wpDateAdded` datetime DEFAULT NULL,
  `wpDateLastAction` datetime DEFAULT NULL,
  `wpCurrentStatus` int(10) NOT NULL DEFAULT '0',
  `wrID` int(1) NOT NULL DEFAULT '0',
  `wpIsCompleted` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`wpID`),
  KEY `wrID` (`wrID`),
  KEY `wpIsCompleted` (`wpIsCompleted`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS WorkflowProgressCategories;

CREATE TABLE IF NOT EXISTS `WorkflowProgressCategories` (
  `wpCategoryID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `wpCategoryHandle` varchar(255) NOT NULL,
  `pkgID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`wpCategoryID`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO WorkflowProgressCategories VALUES(1,'page',NULL)
 ,(2,'file',NULL)
 ,(3,'user',NULL);

DROP TABLE IF EXISTS WorkflowProgressHistory;

CREATE TABLE IF NOT EXISTS `WorkflowProgressHistory` (
  `wphID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `wpID` int(10) unsigned NOT NULL DEFAULT '0',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `object` text,
  PRIMARY KEY (`wphID`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8;

INSERT INTO WorkflowProgressHistory VALUES(1,1,'2016-05-29 17:46:08','O:30:\"ApprovePagePageWorkflowRequest\":8:{s:14:\"\0*\0wrStatusNum\";i:30;s:12:\"\0*\0currentWP\";N;s:6:\"\0*\0uID\";s:1:\"1\";s:5:\"error\";s:0:\"\";s:4:\"pkID\";s:2:\"13\";s:3:\"cID\";s:3:\"124\";s:4:\"cvID\";s:1:\"1\";s:4:\"wrID\";s:1:\"1\";}')
 ,(2,2,'2016-05-29 17:46:21','O:30:\"ApprovePagePageWorkflowRequest\":8:{s:14:\"\0*\0wrStatusNum\";i:30;s:12:\"\0*\0currentWP\";N;s:6:\"\0*\0uID\";s:1:\"1\";s:5:\"error\";s:0:\"\";s:4:\"pkID\";s:2:\"13\";s:3:\"cID\";s:3:\"125\";s:4:\"cvID\";s:1:\"1\";s:4:\"wrID\";s:1:\"2\";}')
 ,(3,3,'2016-05-29 17:46:38','O:30:\"ApprovePagePageWorkflowRequest\":8:{s:14:\"\0*\0wrStatusNum\";i:30;s:12:\"\0*\0currentWP\";N;s:6:\"\0*\0uID\";s:1:\"1\";s:5:\"error\";s:0:\"\";s:4:\"pkID\";s:2:\"13\";s:3:\"cID\";s:3:\"126\";s:4:\"cvID\";s:1:\"1\";s:4:\"wrID\";s:1:\"3\";}')
 ,(4,4,'2016-05-29 17:46:56','O:30:\"ApprovePagePageWorkflowRequest\":8:{s:14:\"\0*\0wrStatusNum\";i:30;s:12:\"\0*\0currentWP\";N;s:6:\"\0*\0uID\";s:1:\"1\";s:5:\"error\";s:0:\"\";s:4:\"pkID\";s:2:\"13\";s:3:\"cID\";s:3:\"126\";s:4:\"cvID\";s:1:\"2\";s:4:\"wrID\";s:1:\"4\";}')
 ,(5,5,'2016-05-29 17:47:12','O:30:\"ApprovePagePageWorkflowRequest\":8:{s:14:\"\0*\0wrStatusNum\";i:30;s:12:\"\0*\0currentWP\";N;s:6:\"\0*\0uID\";s:1:\"1\";s:5:\"error\";s:0:\"\";s:4:\"pkID\";s:2:\"13\";s:3:\"cID\";s:3:\"127\";s:4:\"cvID\";s:1:\"1\";s:4:\"wrID\";s:1:\"5\";}')
 ,(6,6,'2016-05-29 17:47:22','O:30:\"ApprovePagePageWorkflowRequest\":8:{s:14:\"\0*\0wrStatusNum\";i:30;s:12:\"\0*\0currentWP\";N;s:6:\"\0*\0uID\";s:1:\"1\";s:5:\"error\";s:0:\"\";s:4:\"pkID\";s:2:\"13\";s:3:\"cID\";s:3:\"128\";s:4:\"cvID\";s:1:\"1\";s:4:\"wrID\";s:1:\"6\";}')
 ,(7,7,'2016-05-29 17:47:30','O:30:\"ApprovePagePageWorkflowRequest\":8:{s:14:\"\0*\0wrStatusNum\";i:30;s:12:\"\0*\0currentWP\";N;s:6:\"\0*\0uID\";s:1:\"1\";s:5:\"error\";s:0:\"\";s:4:\"pkID\";s:2:\"13\";s:3:\"cID\";s:3:\"129\";s:4:\"cvID\";s:1:\"1\";s:4:\"wrID\";s:1:\"7\";}')
 ,(8,8,'2016-05-29 17:47:55','O:30:\"ApprovePagePageWorkflowRequest\":8:{s:14:\"\0*\0wrStatusNum\";i:30;s:12:\"\0*\0currentWP\";N;s:6:\"\0*\0uID\";s:1:\"1\";s:5:\"error\";s:0:\"\";s:4:\"pkID\";s:2:\"13\";s:3:\"cID\";s:3:\"130\";s:4:\"cvID\";s:1:\"1\";s:4:\"wrID\";s:1:\"8\";}')
 ,(9,9,'2016-05-30 13:00:23','O:30:\"ApprovePagePageWorkflowRequest\":8:{s:14:\"\0*\0wrStatusNum\";i:30;s:12:\"\0*\0currentWP\";N;s:6:\"\0*\0uID\";s:1:\"1\";s:5:\"error\";s:0:\"\";s:4:\"pkID\";s:2:\"13\";s:3:\"cID\";s:1:\"1\";s:4:\"cvID\";s:1:\"2\";s:4:\"wrID\";s:1:\"9\";}')
 ,(10,10,'2016-05-30 13:45:40','O:30:\"ApprovePagePageWorkflowRequest\":8:{s:14:\"\0*\0wrStatusNum\";i:30;s:12:\"\0*\0currentWP\";N;s:6:\"\0*\0uID\";s:1:\"1\";s:5:\"error\";s:0:\"\";s:4:\"pkID\";s:2:\"13\";s:3:\"cID\";s:1:\"1\";s:4:\"cvID\";s:1:\"3\";s:4:\"wrID\";s:2:\"10\";}')
 ,(11,11,'2016-05-30 16:17:25','O:30:\"ApprovePagePageWorkflowRequest\":8:{s:14:\"\0*\0wrStatusNum\";i:30;s:12:\"\0*\0currentWP\";N;s:6:\"\0*\0uID\";s:1:\"1\";s:5:\"error\";s:0:\"\";s:4:\"pkID\";s:2:\"13\";s:3:\"cID\";s:1:\"1\";s:4:\"cvID\";s:1:\"4\";s:4:\"wrID\";s:2:\"11\";}')
 ,(12,12,'2016-05-30 16:18:09','O:30:\"ApprovePagePageWorkflowRequest\":8:{s:14:\"\0*\0wrStatusNum\";i:30;s:12:\"\0*\0currentWP\";N;s:6:\"\0*\0uID\";s:1:\"1\";s:5:\"error\";s:0:\"\";s:4:\"pkID\";s:2:\"13\";s:3:\"cID\";s:1:\"1\";s:4:\"cvID\";s:1:\"5\";s:4:\"wrID\";s:2:\"12\";}')
 ,(13,13,'2016-05-30 16:45:36','O:30:\"ApprovePagePageWorkflowRequest\":8:{s:14:\"\0*\0wrStatusNum\";i:30;s:12:\"\0*\0currentWP\";N;s:6:\"\0*\0uID\";s:1:\"1\";s:5:\"error\";s:0:\"\";s:4:\"pkID\";s:2:\"13\";s:3:\"cID\";s:3:\"124\";s:4:\"cvID\";s:1:\"2\";s:4:\"wrID\";s:2:\"13\";}')
 ,(14,14,'2016-05-30 16:48:54','O:30:\"ApprovePagePageWorkflowRequest\":8:{s:14:\"\0*\0wrStatusNum\";i:30;s:12:\"\0*\0currentWP\";N;s:6:\"\0*\0uID\";s:1:\"1\";s:5:\"error\";s:0:\"\";s:4:\"pkID\";s:2:\"13\";s:3:\"cID\";s:3:\"125\";s:4:\"cvID\";s:1:\"2\";s:4:\"wrID\";s:2:\"14\";}')
 ,(15,15,'2016-05-30 17:03:12','O:30:\"ApprovePagePageWorkflowRequest\":8:{s:14:\"\0*\0wrStatusNum\";i:30;s:12:\"\0*\0currentWP\";N;s:6:\"\0*\0uID\";s:1:\"1\";s:5:\"error\";s:0:\"\";s:4:\"pkID\";s:2:\"13\";s:3:\"cID\";s:3:\"125\";s:4:\"cvID\";s:1:\"3\";s:4:\"wrID\";s:2:\"15\";}')
 ,(16,16,'2016-05-30 17:30:27','O:30:\"ApprovePagePageWorkflowRequest\":8:{s:14:\"\0*\0wrStatusNum\";i:30;s:12:\"\0*\0currentWP\";N;s:6:\"\0*\0uID\";s:1:\"1\";s:5:\"error\";s:0:\"\";s:4:\"pkID\";s:2:\"13\";s:3:\"cID\";s:3:\"125\";s:4:\"cvID\";s:1:\"4\";s:4:\"wrID\";s:2:\"16\";}')
 ,(17,17,'2016-06-01 21:18:59','O:30:\"ApprovePagePageWorkflowRequest\":8:{s:14:\"\0*\0wrStatusNum\";i:30;s:12:\"\0*\0currentWP\";N;s:6:\"\0*\0uID\";s:1:\"1\";s:5:\"error\";s:0:\"\";s:4:\"pkID\";s:2:\"13\";s:3:\"cID\";s:3:\"125\";s:4:\"cvID\";s:1:\"5\";s:4:\"wrID\";s:2:\"17\";}')
 ,(18,18,'2016-06-01 21:19:56','O:30:\"ApprovePagePageWorkflowRequest\":8:{s:14:\"\0*\0wrStatusNum\";i:30;s:12:\"\0*\0currentWP\";N;s:6:\"\0*\0uID\";s:1:\"1\";s:5:\"error\";s:0:\"\";s:4:\"pkID\";s:2:\"13\";s:3:\"cID\";s:3:\"125\";s:4:\"cvID\";s:1:\"6\";s:4:\"wrID\";s:2:\"18\";}')
 ,(19,19,'2016-06-02 20:38:42','O:30:\"ApprovePagePageWorkflowRequest\":8:{s:14:\"\0*\0wrStatusNum\";i:30;s:12:\"\0*\0currentWP\";N;s:6:\"\0*\0uID\";s:1:\"1\";s:5:\"error\";s:0:\"\";s:4:\"pkID\";s:2:\"13\";s:3:\"cID\";s:3:\"125\";s:4:\"cvID\";s:1:\"7\";s:4:\"wrID\";s:2:\"19\";}')
 ,(20,20,'2016-06-02 20:58:50','O:30:\"ApprovePagePageWorkflowRequest\":8:{s:14:\"\0*\0wrStatusNum\";i:30;s:12:\"\0*\0currentWP\";N;s:6:\"\0*\0uID\";s:1:\"1\";s:5:\"error\";s:0:\"\";s:4:\"pkID\";s:2:\"13\";s:3:\"cID\";s:3:\"125\";s:4:\"cvID\";s:1:\"8\";s:4:\"wrID\";s:2:\"20\";}')
 ,(21,21,'2016-06-04 13:57:39','O:30:\"ApprovePagePageWorkflowRequest\":8:{s:14:\"\0*\0wrStatusNum\";i:30;s:12:\"\0*\0currentWP\";N;s:6:\"\0*\0uID\";s:1:\"1\";s:5:\"error\";s:0:\"\";s:4:\"pkID\";s:2:\"13\";s:3:\"cID\";s:3:\"125\";s:4:\"cvID\";s:1:\"9\";s:4:\"wrID\";s:2:\"21\";}')
 ,(22,22,'2016-06-04 14:16:45','O:30:\"ApprovePagePageWorkflowRequest\":8:{s:14:\"\0*\0wrStatusNum\";i:30;s:12:\"\0*\0currentWP\";N;s:6:\"\0*\0uID\";s:1:\"1\";s:5:\"error\";s:0:\"\";s:4:\"pkID\";s:2:\"13\";s:3:\"cID\";s:3:\"126\";s:4:\"cvID\";s:1:\"3\";s:4:\"wrID\";s:2:\"22\";}')
 ,(23,23,'2016-06-04 14:27:43','O:30:\"ApprovePagePageWorkflowRequest\":8:{s:14:\"\0*\0wrStatusNum\";i:30;s:12:\"\0*\0currentWP\";N;s:6:\"\0*\0uID\";s:1:\"1\";s:5:\"error\";s:0:\"\";s:4:\"pkID\";s:2:\"13\";s:3:\"cID\";s:3:\"128\";s:4:\"cvID\";s:1:\"2\";s:4:\"wrID\";s:2:\"23\";}')
 ,(24,24,'2016-06-04 14:30:53','O:30:\"ApprovePagePageWorkflowRequest\":8:{s:14:\"\0*\0wrStatusNum\";i:30;s:12:\"\0*\0currentWP\";N;s:6:\"\0*\0uID\";s:1:\"1\";s:5:\"error\";s:0:\"\";s:4:\"pkID\";s:2:\"13\";s:3:\"cID\";s:3:\"129\";s:4:\"cvID\";s:1:\"2\";s:4:\"wrID\";s:2:\"24\";}')
 ,(25,25,'2016-06-04 14:34:11','O:30:\"ApprovePagePageWorkflowRequest\":8:{s:14:\"\0*\0wrStatusNum\";i:30;s:12:\"\0*\0currentWP\";N;s:6:\"\0*\0uID\";s:1:\"1\";s:5:\"error\";s:0:\"\";s:4:\"pkID\";s:2:\"13\";s:3:\"cID\";s:3:\"129\";s:4:\"cvID\";s:1:\"3\";s:4:\"wrID\";s:2:\"25\";}')
 ,(26,26,'2016-06-04 14:42:27','O:30:\"ApprovePagePageWorkflowRequest\":8:{s:14:\"\0*\0wrStatusNum\";i:30;s:12:\"\0*\0currentWP\";N;s:6:\"\0*\0uID\";s:1:\"1\";s:5:\"error\";s:0:\"\";s:4:\"pkID\";s:2:\"13\";s:3:\"cID\";s:3:\"130\";s:4:\"cvID\";s:1:\"2\";s:4:\"wrID\";s:2:\"26\";}')
 ,(27,27,'2016-06-04 14:43:17','O:30:\"ApprovePagePageWorkflowRequest\":8:{s:14:\"\0*\0wrStatusNum\";i:30;s:12:\"\0*\0currentWP\";N;s:6:\"\0*\0uID\";s:1:\"1\";s:5:\"error\";s:0:\"\";s:4:\"pkID\";s:2:\"13\";s:3:\"cID\";s:3:\"130\";s:4:\"cvID\";s:1:\"3\";s:4:\"wrID\";s:2:\"27\";}')
 ,(28,28,'2016-06-04 14:43:40','O:30:\"ApprovePagePageWorkflowRequest\":8:{s:14:\"\0*\0wrStatusNum\";i:30;s:12:\"\0*\0currentWP\";N;s:6:\"\0*\0uID\";s:1:\"1\";s:5:\"error\";s:0:\"\";s:4:\"pkID\";s:2:\"13\";s:3:\"cID\";s:3:\"130\";s:4:\"cvID\";s:1:\"4\";s:4:\"wrID\";s:2:\"28\";}')
 ,(29,29,'2016-06-04 14:48:21','O:30:\"ApprovePagePageWorkflowRequest\":8:{s:14:\"\0*\0wrStatusNum\";i:30;s:12:\"\0*\0currentWP\";N;s:6:\"\0*\0uID\";s:1:\"1\";s:5:\"error\";s:0:\"\";s:4:\"pkID\";s:2:\"13\";s:3:\"cID\";s:3:\"125\";s:4:\"cvID\";s:2:\"10\";s:4:\"wrID\";s:2:\"29\";}');

DROP TABLE IF EXISTS WorkflowRequestObjects;

CREATE TABLE IF NOT EXISTS `WorkflowRequestObjects` (
  `wrID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `wrObject` text,
  PRIMARY KEY (`wrID`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS WorkflowTypes;

CREATE TABLE IF NOT EXISTS `WorkflowTypes` (
  `wftID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `wftHandle` varchar(64) NOT NULL,
  `wftName` varchar(128) NOT NULL,
  `pkgID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`wftID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO WorkflowTypes VALUES(1,'basic','Basic Workflow',0);

DROP TABLE IF EXISTS Workflows;

CREATE TABLE IF NOT EXISTS `Workflows` (
  `wfID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `wfName` varchar(255) DEFAULT NULL,
  `wftID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`wfID`),
  UNIQUE KEY `wfName` (`wfName`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS atAddress;

CREATE TABLE IF NOT EXISTS `atAddress` (
  `avID` int(10) unsigned NOT NULL DEFAULT '0',
  `address1` varchar(255) DEFAULT NULL,
  `address2` varchar(255) DEFAULT NULL,
  `city` varchar(255) DEFAULT NULL,
  `state_province` varchar(255) DEFAULT NULL,
  `country` varchar(4) DEFAULT NULL,
  `postal_code` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`avID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS atAddressCustomCountries;

CREATE TABLE IF NOT EXISTS `atAddressCustomCountries` (
  `atAddressCustomCountryID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `akID` int(10) unsigned NOT NULL DEFAULT '0',
  `country` varchar(5) NOT NULL,
  PRIMARY KEY (`atAddressCustomCountryID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS atAddressSettings;

CREATE TABLE IF NOT EXISTS `atAddressSettings` (
  `akID` int(10) unsigned NOT NULL DEFAULT '0',
  `akHasCustomCountries` int(1) NOT NULL DEFAULT '0',
  `akDefaultCountry` varchar(12) DEFAULT NULL,
  PRIMARY KEY (`akID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS atBoolean;

CREATE TABLE IF NOT EXISTS `atBoolean` (
  `avID` int(10) unsigned NOT NULL,
  `value` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`avID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO atBoolean VALUES(20,1)
 ,(31,1)
 ,(34,1)
 ,(64,1)
 ,(65,1)
 ,(68,1)
 ,(69,1)
 ,(75,1)
 ,(109,1)
 ,(118,1)
 ,(119,1)
 ,(120,1);

DROP TABLE IF EXISTS atBooleanSettings;

CREATE TABLE IF NOT EXISTS `atBooleanSettings` (
  `akID` int(10) unsigned NOT NULL,
  `akCheckedByDefault` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`akID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO atBooleanSettings VALUES(5,0)
 ,(6,0)
 ,(8,0)
 ,(9,0)
 ,(10,1)
 ,(11,1);

DROP TABLE IF EXISTS atDateTime;

CREATE TABLE IF NOT EXISTS `atDateTime` (
  `avID` int(10) unsigned NOT NULL,
  `value` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`avID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS atDateTimeSettings;

CREATE TABLE IF NOT EXISTS `atDateTimeSettings` (
  `akID` int(10) unsigned NOT NULL,
  `akDateDisplayMode` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`akID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS atDefault;

CREATE TABLE IF NOT EXISTS `atDefault` (
  `avID` int(10) unsigned NOT NULL,
  `value` longtext,
  PRIMARY KEY (`avID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO atDefault VALUES(1,'blog, blogging')
 ,(2,'icon-book')
 ,(3,'new blog, write blog, blogging')
 ,(4,'icon-pencil')
 ,(5,'blog drafts, composer')
 ,(6,'icon-book')
 ,(7,'pages, add page, delete page, copy, move, alias')
 ,(8,'pages, add page, delete page, copy, move, alias')
 ,(9,'icon-home')
 ,(10,'pages, add page, delete page, copy, move, alias, bulk')
 ,(11,'icon-road')
 ,(12,'find page, search page, search, find, pages, sitemap')
 ,(13,'icon-search')
 ,(14,'add file, delete file, copy, move, alias, resize, crop, rename, images, title, attribute')
 ,(15,'icon-picture')
 ,(16,'file, file attributes, title, attribute, description, rename')
 ,(17,'icon-cog')
 ,(18,'files, category, categories')
 ,(19,'icon-list-alt')
 ,(21,'new file set')
 ,(22,'icon-plus-sign')
 ,(23,'users, groups, people, find, delete user, remove user, change password, password')
 ,(24,'find, search, people, delete user, remove user, change password, password')
 ,(25,'icon-user')
 ,(26,'user, group, people, permissions, access, expire')
 ,(27,'icon-globe')
 ,(28,'user attributes, user data, gather data, registration data')
 ,(29,'icon-cog')
 ,(30,'new user, create')
 ,(32,'icon-plus-sign')
 ,(33,'new user group, new group, group, create')
 ,(35,'icon-plus')
 ,(36,'group set')
 ,(37,'icon-list')
 ,(38,'forms, log, error, email, mysql, exception, survey')
 ,(39,'hits, pageviews, visitors, activity')
 ,(40,'icon-signal')
 ,(41,'forms, questions, response, data')
 ,(42,'icon-briefcase')
 ,(43,'questions, quiz, response')
 ,(44,'icon-tasks')
 ,(45,'forms, log, error, email, mysql, exception, survey, history')
 ,(46,'icon-time')
 ,(47,'new theme, theme, active theme, change theme, template, css')
 ,(48,'icon-font')
 ,(49,'theme')
 ,(50,'page types')
 ,(51,'custom theme, change theme, custom css, css')
 ,(52,'page type defaults, global block, global area, starter, template')
 ,(53,'icon-file')
 ,(54,'page attributes, custom')
 ,(55,'icon-cog')
 ,(56,'single, page, custom, application')
 ,(57,'icon-wrench')
 ,(58,'add workflow, remove workflow')
 ,(59,'icon-list')
 ,(60,'icon-user')
 ,(61,'stacks, reusable content, scrapbook, copy, paste, paste block, copy block, site name, logo')
 ,(62,'icon-th')
 ,(63,'icon-lock')
 ,(66,'block, refresh, custom')
 ,(67,'icon-wrench')
 ,(70,'add-on, addon, ecommerce, install, discussions, forums, themes, templates, blocks')
 ,(71,'update, upgrade')
 ,(72,'concrete5.org, my account, marketplace')
 ,(73,'buy theme, new theme, marketplace, template')
 ,(74,'buy addon, buy add on, buy add-on, purchase addon, purchase add on, purchase add-on, find addon, new addon, marketplace')
 ,(76,'website name, title')
 ,(77,'logo, favicon, iphone, icon, bookmark')
 ,(78,'tinymce, content block, fonts, editor, content, overlay')
 ,(79,'translate, translation, internationalization, multilingual')
 ,(80,'timezone, profile, locale')
 ,(81,'interface, quick nav, dashboard background, background image')
 ,(82,'vanity, pretty url, seo, pageview, view')
 ,(83,'bulk, seo, change keywords, engine, optimization, search')
 ,(84,'traffic, statistics, google analytics, quant, pageviews, hits')
 ,(85,'pretty, slug')
 ,(86,'turn off statistics, tracking, statistics, pageviews, hits')
 ,(87,'configure search, site search, search option')
 ,(88,'cache option, change cache, override, turn on cache, turn off cache, no cache, page cache, caching')
 ,(89,'cache option, turn off cache, no cache, page cache, caching')
 ,(90,'index search, reindex search, build sitemap, sitemap.xml, clear old versions, page versions, remove old')
 ,(91,'editors, hide site, offline, private, public, access')
 ,(92,'file options, file manager, upload, modify')
 ,(93,'security, files, media, extension, manager, upload')
 ,(94,'security, actions, administrator, admin, package, marketplace, search')
 ,(95,'security, lock ip, lock out, block ip, address, restrict, access')
 ,(96,'security, registration')
 ,(97,'antispam, block spam, security')
 ,(98,'lock site, under construction, hide, hidden')
 ,(99,'profile, login, redirect, specific, dashboard, administrators')
 ,(100,'member profile, member page, community, forums, social, avatar')
 ,(101,'signup, new user, community')
 ,(102,'smtp, mail settings')
 ,(103,'email server, mail settings, mail configuration, external, internal')
 ,(104,'test smtp, test mail')
 ,(105,'email server, mail settings, mail configuration, private message, message system, import, email, message')
 ,(106,'attribute configuration')
 ,(107,'attributes, sets')
 ,(108,'attributes, types')
 ,(110,'overrides, system info, debug, support, help')
 ,(111,'errors, exceptions, develop, support, help')
 ,(112,'email, logging, logs, smtp, pop, errors, mysql, log')
 ,(113,'security, alternate storage, hide files')
 ,(114,'network, proxy server')
 ,(115,'export, backup, database, sql, mysql, encryption, restore')
 ,(116,'upgrade, new version, update')
 ,(117,'export, database, xml, starting, points, schema, refresh, custom, tables')
 ,(127,'rooms');

DROP TABLE IF EXISTS atFile;

CREATE TABLE IF NOT EXISTS `atFile` (
  `avID` int(10) unsigned NOT NULL,
  `fID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`avID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS atNumber;

CREATE TABLE IF NOT EXISTS `atNumber` (
  `avID` int(10) unsigned NOT NULL,
  `value` decimal(14,4) DEFAULT '0.0000',
  PRIMARY KEY (`avID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO atNumber VALUES(121,630.0000)
 ,(122,460.0000)
 ,(123,630.0000)
 ,(124,460.0000)
 ,(125,630.0000)
 ,(126,460.0000)
 ,(128,80.0000)
 ,(129,80.0000)
 ,(130,83.0000)
 ,(131,118.0000)
 ,(132,82.0000)
 ,(133,118.0000)
 ,(134,82.0000)
 ,(135,118.0000)
 ,(136,80.0000)
 ,(137,80.0000);

DROP TABLE IF EXISTS atSelectOptions;

CREATE TABLE IF NOT EXISTS `atSelectOptions` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `akID` int(10) unsigned DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  `displayOrder` int(10) unsigned DEFAULT NULL,
  `isEndUserAdded` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS atSelectOptionsSelected;

CREATE TABLE IF NOT EXISTS `atSelectOptionsSelected` (
  `avID` int(10) unsigned NOT NULL,
  `atSelectOptionID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`avID`,`atSelectOptionID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS atSelectSettings;

CREATE TABLE IF NOT EXISTS `atSelectSettings` (
  `akID` int(10) unsigned NOT NULL,
  `akSelectAllowMultipleValues` tinyint(1) NOT NULL DEFAULT '0',
  `akSelectOptionDisplayOrder` varchar(255) NOT NULL DEFAULT 'display_asc',
  `akSelectAllowOtherValues` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`akID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS atTextareaSettings;

CREATE TABLE IF NOT EXISTS `atTextareaSettings` (
  `akID` int(10) unsigned NOT NULL DEFAULT '0',
  `akTextareaDisplayMode` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`akID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO atTextareaSettings VALUES(2,'')
 ,(3,'')
 ,(4,'')
 ,(7,'');

DROP TABLE IF EXISTS btContentFile;

CREATE TABLE IF NOT EXISTS `btContentFile` (
  `bID` int(10) unsigned NOT NULL,
  `fID` int(10) unsigned DEFAULT NULL,
  `fileLinkText` varchar(255) DEFAULT NULL,
  `filePassword` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS btContentImage;

CREATE TABLE IF NOT EXISTS `btContentImage` (
  `bID` int(10) unsigned NOT NULL,
  `fID` int(10) unsigned DEFAULT '0',
  `fOnstateID` int(10) unsigned DEFAULT '0',
  `maxWidth` int(10) unsigned DEFAULT '0',
  `maxHeight` int(10) unsigned DEFAULT '0',
  `externalLink` varchar(255) DEFAULT NULL,
  `internalLinkCID` int(10) unsigned DEFAULT '0',
  `forceImageToMatchDimensions` int(10) unsigned DEFAULT '0',
  `altText` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO btContentImage VALUES(62,7,0,0,0,'',0,1,'')
 ,(63,6,0,0,0,'',0,1,'')
 ,(64,5,0,0,0,'',0,1,'')
 ,(65,4,0,0,0,'',0,1,'')
 ,(66,8,0,0,0,'',0,1,'');

DROP TABLE IF EXISTS btContentLocal;

CREATE TABLE IF NOT EXISTS `btContentLocal` (
  `bID` int(10) unsigned NOT NULL,
  `content` longtext,
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO btContentLocal VALUES(1,'	<div id=\"newsflow-header-first-run\"><h1>Welcome to concrete5.</h1>\n						<h2>It\'s easy to edit content and add pages using in-context editing.</h2></div>\n						')
 ,(2,'<div class=\"newsflow-column-first-run\">\n							<h3>Building Your Own Site</h3>\n							<p>Editing with concrete5 is a breeze. Just point and click to make changes.</p>\n							<br/>\n							<p><a href=\"javascript:void(0)\" onclick=\"ccm_getNewsflowByPath(\'/welcome/editors\')\" class=\"btn primary\">Editor\'s Guide</a></p>\n							</div>')
 ,(3,'<div class=\"newsflow-column-first-run\">\n							<h3>Developing Applications</h3>\n							<p>If you’re comfortable in PHP concrete5 should be a breeze to learn. Take a few moments to understand the architecture.</p>\n							<p><a href=\"javascript:void(0)\" onclick=\"ccm_getNewsflowByPath(\'/welcome/developers\')\" class=\"btn primary\">Developer\'s Guide</a></p>\n							</div>')
 ,(4,'<div class=\"newsflow-column-first-run\">\n							<h3>Designing Websites</h3>\n							<p>Good with CSS and HTML? You can easily theme anything with concrete5.</p>\n							<br/>\n							<p><a href=\"javascript:void(0)\" onclick=\"ccm_getNewsflowByPath(\'/welcome/designers\')\" class=\"btn primary\">Designer\'s Guide</a></p>\n							</div>')
 ,(5,'\n						<div class=\"newsflow-column-first-run\">\n						<h3>Business Background</h3>\n						<p>Worried about license structures, white-labeling or why concrete5 is a good choice for your agency?</p>\n						<p><a href=\"javascript:void(0)\" onclick=\"ccm_getNewsflowByPath(\'/welcome/executives\')\" class=\"btn primary\">Executive\'s Guide</a></p>\n						</div>')
 ,(14,'<h1>Woodland Bed &amp; Breakfast with tea garden</h1>\r\n<p>Lowther House is set at the end of a tree lined drive in a clearing in Pickering Woods. It has a real country feel about it yet is just a ten minute walk down a tree-lined avenue into Pickering Town Centre.</p>\r\n<p>The house is bordered on two sides by Pickering Beck and is part of the Duchy of Lancaster Estate. The North York Moors Railway station is just five minutes away and the track runs past the garden. It’s a lovely sight to see when the steam trains go past – especially if you’re having cake and tea in the garden at the same time!!</p>\r\n<p>The house sits between the North York Moors National Park - which you can walk into from our gate - and the Yorkshire Wolds to the south, making it the perfect location for exploring some of the most spectacular scenery around. Excellent walks and cycle tracks are right outside our door,</p>\r\n<blockquote>“We moved into Lowther House in September 2015 after running a pub and bed and breakfast in the Yorkshire Dales. We knew the first time we saw Lowther House that we wanted to live here, the house are gardens are beautiful and have a real sense of calm about them. We hope you will enjoy the comfort, charm and warm welcome at Lowther House.”</blockquote>')
 ,(15,'<h1>Latest News &amp; Info</h1>\r\n<h4>Winter warmer<br />bed &amp; breakfast<br />special offer</h4>\r\n<p> </p>\r\n<p>Available Nov - Feb inclusive.</p>\r\n<p>Book one night and get (consecutive) night free.</p>\r\n<p>Subject to availabliity<br />Room price is £80.</p>')
 ,(16,'<h1>Latest News &amp; Info</h1>\r\n<h4>Winter warmer<br />bed &amp; breakfast<br />special offer</h4>\r\n<p>Available Nov - Feb inclusive.</p>\r\n<p>Book one night and get (consecutive) night free.</p>\r\n<p>Subject to availabliity<br />Room price is £80.</p>')
 ,(18,'<h1>Around Lowther House</h1>\r\n<p>The house is Georgian dating from around 1810, it was built for the Woodward of the time, the man overseeing the woods on the Pickering estate. The house is bordered on one side by a limestone outcropping and is built from this local stone – and we mean local! The quarrying remains for the stone can still be seen in the mesmeric grotto-in-the-trees adjacent to the house.</p>\r\n<p>It has undergone many changes and owners since then, the latest being Her Most Gracious Majesty through Her Duchy of Lancaster Estate, an ancient estate of the King (or Queen) dating back to 1399.</p>\r\n<p>Lowther house is a grade 11 building as defined by English Heritage and cannot be altered in its look, and is mostly original. Being over two hundred years old, she creaks and groans and is somewhat crooked in places, and some of the original windows (many with the original wonky hand-made glass panes too!) and doors have minds of their own! But as with any two hundred-year-old it’s part of her charm, and we hope you find it as endearing as we do!</p>\r\n<p>Fear not! Inside her sturdy 40cms thick walls the interior has modern central heating, unlimited hot water and other 21st century amenities!</p>\r\n<p>Bordered on two sides by the Beck, the house has a beautiful English Country Garden at the back of some half acre, the front garden is laid to grass looking over a sweeping swathe of river meadow running down to the road known as the \'Butts\' – but whether it was ever used for archery practice is not known.</p>')
 ,(19,'<h1>Our Gardens</h1>\r\n<p>Please feel free to wander in our lovely gardens - we can lend you a net so you can try fishing for Brown Trout, if you catch a big enough one we can cook it for you, but mostly they\'re tiny and you have to throw them back!</p>\r\n<p>The rear garden is also our tea garden, snacks and meals with an eclectic twist are available all day from 10 am. We cater for picnics on the lawn under the apple trees as well, a delightful way to spend an hour or two! We are also happy to cater for small private parties.</p>')
 ,(21,'<h1>Booking Enquiry Form</h1>')
 ,(22,'<h1>Bedrooms at Lowther House</h1>\r\n<p>We have two first floor rooms - so we can offer excellent service. Fresh flowers greet you, in hospitality corner there is a silent running fridge for your use for beverages, wine etc. - just ask for ice and glasses. Also, there are a selection of Twinings teas and Fresh Rombouts Coffees - yours for the making, plus biscuits to nibble, an insulated carafe of chilled filtered water is also provided. A radio-controlled alarm clock with a very useful weather feature is by the bed.</p>\r\n<p>There is a Freesat TV with DVD player a selection of DVD\'s/CD\'s is available on the landing. In the closet you\'ll find shower robes, hair dryer, shaver adaptor, fan, extra bedding etc.</p>')
 ,(23,'<h1>Beck Room</h1>')
 ,(24,'<h1>Orchard Room</h1>')
 ,(25,'<h1>Garden Room</h1>')
 ,(29,'<p>BECK ROOM Available as a twin-bedded room. Double aspect, with lovely views of the Beck and the garden across to the Butts river meadow. With the added fun of watching the steam trains of the North York\'s Moors Railway as they chug up the dale to Whitby!</p>\r\n<p>Drift off to sleep with the sounds of the beck trickling by your window, interrupted only by the hoots of owls on their night-time hunting trips.</p>\r\n<p>For a romantic treat we are happy to serve breakfast in the room - just let us know ahead of time! The private wet-room with key access for exclusive use is across the hall</p>')
 ,(30,'<p>ORCHARD ROOM A king-size bed (5\') with en-suite wet-room. Wake to gorgeous views over the garden orchard and Pickering Woods, maybe you\'ll see a deer or two as well!</p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam sodales vehicula risus, et facilisis massa lacinia eget. Pellentesque auctor bibendum urna sed tempus. Pellentesque elementum, tellus quis tristique maximus, eros arcu malesuada augue, nec consectetur purus sem quis velit.</p>')
 ,(31,'<p>GARDEN ROOM Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam sodales vehicula risus, et facilisis massa lacinia eget. Pellentesque auctor bibendum urna sed tempus. Pellentesque elementum, tellus quis tristique maximus, eros arcu malesuada augue, nec consectetur purus sem quis velit.</p>\r\n<p>Curabitur molestie nisl nisl, a eleifend tortor congue ut. Morbi eleifend sapien vel felis consequat, tincidunt convallis eros malesuada. Sed mollis aliquet nisi, lobortis aliquam nibh tristique vel. Nulla accumsan ipsum felis. Nunc eget diam nunc. Pvarius magna eget.</p>')
 ,(32,'<h1>Bed &amp; Breakfast tariff for 2016</h1>\r\n<table>\r\n<tbody>\r\n<tr><th>Rooms</th><th>1 Night</th><th>2-4 Nights</th><th>5+ Nights</th></tr>\r\n<tr>\r\n<td><strong>Orchard</strong><br />En-suite, King</td>\r\n<td>£75</td>\r\n<td>£70</td>\r\n<td>£65</td>\r\n</tr>\r\n<tr>\r\n<td><strong>Beckside</strong><br />Separate Bathroom Twin or Super King</td>\r\n<td>£70</td>\r\n<td>£65</td>\r\n<td>£60</td>\r\n</tr>\r\n<tr>\r\n<td><strong>Garden</strong><br />Separate Bathroom</td>\r\n<td>£70</td>\r\n<td>£65</td>\r\n<td>£60</td>\r\n</tr>\r\n</tbody>\r\n</table>')
 ,(33,'<h1>Bed &amp; Breakfast tariff for 2016</h1>\r\n<p>Lowther House Tariff below is for direct bookings only</p>\r\n<table>\r\n<tbody>\r\n<tr><th>Rooms</th><th>1 Night</th><th>2-4 Nights</th><th>5+ Nights</th></tr>\r\n<tr>\r\n<td><strong>Orchard</strong><br />En-suite, King</td>\r\n<td>£75</td>\r\n<td>£70</td>\r\n<td>£65</td>\r\n</tr>\r\n<tr>\r\n<td><strong>Beckside</strong><br />Separate Bathroom Twin or Super King</td>\r\n<td>£70</td>\r\n<td>£65</td>\r\n<td>£60</td>\r\n</tr>\r\n<tr>\r\n<td><strong>Garden</strong><br />Separate Bathroom</td>\r\n<td>£70</td>\r\n<td>£65</td>\r\n<td>£60</td>\r\n</tr>\r\n</tbody>\r\n</table>')
 ,(34,'<blockquote>“Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam sodales vehicula risus, et facilisis massa lacinia eget. Pellentesque auctor bibendum urna sed tempus. Pellentesque elementum, tellus quis tristique maximus, eros arcu malesuada augue, nec consectetur purus sem quis velit.”</blockquote>')
 ,(35,'<blockquote>Eu epicurei suscipiantur mea. Ius eu wisi suscipit, pri tollit vocibus id. Percipit tacimates id eum. Vel et alia nominavi laboramus, vel ex tritani prodesset, ut duo modo volutpat aliquando.</blockquote>')
 ,(36,'<blockquote>Mutat essent ut sea, est solum mucius te. Qui veniam consetetur definiebas an. Dicam intellegam definitiones vis ut, perfecto tincidunt incorrupte sit ex. Vis graece virtute inimicus no, nec ad efficiendi definitionem, at aeque abhorreant omittantur mei. Persius signiferumque eum ne.</blockquote>')
 ,(37,'<h1>Booking Information</h1>\r\n<p>Single occupancy rates are £10.00 less per room.</p>\r\n<p>Prices are inclusive of breakfast.</p>\r\n<p>We accept well behaved dogs at a one off charge of £10 per dog.</p>\r\n<p>Bookings through third parties may be charged at a higher tariff</p>\r\n<p>We accept most British and International Debit, Credit and Commercial Cards, for deposits and payments, except Diners and Amex. If you need further information please give us a call on 01751 477 568 or email <a href=\"mailto:info@lowtherhouse.co.uk\">info@lowtherhouse.co.uk</a></p>\r\n<h6>DOWNLOADS</h6>\r\n<p>Booking Terms &amp; Conditions <br />Accesibility Statement <br />B&amp;B Tariff</p>')
 ,(39,'<h1>Eating With Us</h1>\r\n<p>Lorem ipsum dolor sit amet, quo doctus ponderum eu. Ad doming molestiae conclusionemque cum. Assum mandamus ne eum, at nulla oratio his. Eam dolore vivendum ad. An impetus appareat tincidunt has, id sed option liberavisse.</p>\r\n<p>Eu epicurei suscipiantur mea. Ius eu wisi suscipit, pri tollit vocibus id. Percipit tacimates id eum. Vel et alia nominavi laboramus, vel ex tritani prodesset, ut duo modo volutpat aliquando.</p>')
 ,(40,'<h1>Meals</h1>\r\n<p>We pride ourselves on the freshness and quality of our food, all our fresh food is purchased from local butchers, bakers, greengrocers, fishmongers and grocery stores ensuring we know when and where it grew or was made. Meals can be served in the dining room or terrace, weather permitting.</p>\r\n<h6>SAMPLE MENU</h6>')
 ,(41,'<h1>Breakfast</h1>\r\n<h6>SAMPLE MENU</h6>\r\n<p>100% pure fresh fruit juice</p>\r\n<p>Choice of Teas and Cafetiere coffee, or our luxury Hot Frothy Chocolate</p>\r\n<p>Choice of Cereals and Porridge</p>\r\n<p>Traditional English ­ grilled not fried</p>\r\n<p>A choice of: Bacon, Sausages, Baked Beans, Yorkshire Black Pudding (yes there are other varieties!), Mushrooms, Hash Browns, Tomatoes, Eggs cooked a variety of ways.</p>\r\n<h6>CONTINENTAL</h6>\r\n<p>A variety of meats and cheeses, fresh fruit, yoghurt, croissants, etc.</p>\r\n<p>Granary or White Toast with local Jams, Jellies and Marmalade ­ even Marmite!</p>')
 ,(42,'<h1>Events Info</h1>\r\n<p>Lorem ipsum dolor sit amet, quo doctus ponderum eu. Ad doming molestiae conclusionemque cum. Assum mandamus ne eum, at nulla oratio his. Eam dolore vivendum ad. An impetus appareat tincidunt has, id sed option liberavisse.</p>\r\n<p>Eu epicurei suscipiantur mea. Ius eu wisi suscipit, pri tollit vocibus id. Percipit tacimates id eum. Vel et alia nominavi laboramus, vel ex tritani prodesset, ut duo modo volutpat aliquando.</p>')
 ,(44,'<h1>Local Events</h1>\r\n<p>Flying Scotsman visits NYMR - 12th, 13th, 15th, 16th, 17th, 19th, and 20th March</p>\r\n<p>NYMR Summer services begin Mon 21st March</p>\r\n<p>Tour de Yorkshire (Stage 3) Sunday 1st May</p>\r\n<p>NYMR Steam Gala 6th - 8th and 13th - 15th May, visiting engines LNWR 58926 and Standard 80072</p>\r\n<p>Malton Food Festival 28th - 29th May</p>\r\n<p>70\'s Weekend at NMR 17th - 19th June</p>\r\n<p>Forest Live - Dalby Forest music festival 23rd - 25th June</p>\r\n<p>60\'s Weekend at NYMR 2nd - 3rd July</p>\r\n<p>Classic Car and Vehicle Rally 9th - 10th July</p>\r\n<p>4th Rydale Jazz Festival 24th - 30th July</p>\r\n<p>Pickering Traction Rall 5th, 6th and 7th August</p>\r\n<p>Autumn Steam gala 30th Sept - 2nd Oct</p>\r\n<p>Pickering War Weekend 14th - 16th October</p>')
 ,(45,'<h1>2016 events a Lowther House</h1>\r\n<p>Valentines Weekend - Two night stay, £140, includes afternoon tea on arrival and a bottle of fizz in your room.</p>\r\n<p>Easter Weekend - Easter Afternoon Tea available all weekend, Easter Egg Hunt on Sunday 27th March 2pm.</p>\r\n<p>The derelict chicken hut and run are being repaired and we hope to have it for ready for the new hen residents by the end of April.</p>\r\n<p>Our new \'Herdy Hut\' will be available to hire from May, the renovated glamping pod will be newly fitted out and ready for guests.</p>\r\n<p>The \'Vintage Barn\' - new for this Summer, when you visit for an overnight stay or for a treat in the tea garden you\'ll be able to visit the vintage barn - \'upcyled furniture, vintage finds and handmade gifts\'.</p>\r\n<p>Jazz on the Lawn - share a Summers evening, a nice glass of fizz and live jazz with the Rydale Jazz Band - June date tbc Summer Gala - Sat 9th July - Great food, live music, children\'s games, gifts and produce for sale.</p>\r\n<p>Sausage and Cider Day - Sunday 31st July (Bank Holiday weekend)</p>\r\n<p>Afternoon Tea - afternoon tea with all the trimmings, vintage china, tablecloths and embroidered napkins. Available Weds - Sunday £9.95. Gift certificates for afternoon tea available to treat someone special.</p>\r\n<p>Hire our Vintage Barn for parties,small weddings,events or birthdays. Theme your event, cater yourselves or we\'ll cater for you. Use of the beautiful garden throughout your event.</p>')
 ,(47,'<h1>Out Location</h1>\r\n<p>The house is surrounded by the fabulously \'Tolkien\' Pickering Woods in which are secret meadows, unchanged for centuries, you could well believe you\'re in the Shire of Middle Earth! Ideal for those who like either an early morning or late evening stroll (best times to spot Hobbits!).</p>\r\n<p>We can lend you a couple of bikes if you\'d like to pedal around for the day!</p>')
 ,(48,'<h1>Cut &amp; About in the local area</h1>\r\n<p>Lorem ipsum dolor sit amet, quo doctus ponderum eu. Ad doming molestiae conclusionemque cum. Assum mandamus ne eum, at nulla oratio his. Eam dolore vivendum ad. An impetus appareat tincidunt has, id sed option liberavisse.</p>\r\n<p>Eu epicurei suscipiantur mea. Ius eu wisi suscipit, pri tollit vocibus id. Percipit tacimates id eum. Vel et alia nominavi laboramus, vel ex tritani prodesset, ut duo modo volutpat aliquando.</p>')
 ,(49,'<h1>Around the moors</h1>')
 ,(51,'<p>Available as a twin-bedded room. Double aspect, with lovely views of the Beck and the garden across to the Butts river meadow. With the added fun of watching the steam trains of the North York\'s Moors Railway as they chug up the dale to Whitby!</p>\r\n<p>Drift off to sleep with the sounds of the beck trickling by your window, interrupted only by the hoots of owls on their night-time hunting trips.</p>\r\n<p>For a romantic treat we are happy to serve breakfast in the room - just let us know ahead of time!</p>\r\n<p>The private wet-room with key access for exclusive use is across the hall.</p>')
 ,(52,'<h1>Along the coast</h1>')
 ,(54,'<p>A king-size bed (5\') with en-suite wet-room. Wake to gorgeous views over the garden orchard and Pickering Woods, maybe you\'ll see a deer or two as well!</p>')
 ,(55,'<h1>Eating &amp; Drinking</h1>')
 ,(57,'<p>Lorem ipsum dolor sit amet, quo doctus ponderum eu. Ad doming molestiae conclusionemque cum. Assum mandamus ne eum, at nulla oratio his. Eam dolore vivendum ad. An impetus appareat tincidunt has, id sed option liberavisse.</p>\r\n<p>Eu epicurei suscipiantur mea. Ius eu wisi suscipit, pri tollit vocibus id. Percipit tacimates id eum. Vel et alia nominavi laboramus, vel ex tritani prodesset, ut duo modo volutpat aliquando.</p>')
 ,(58,'<h1>How to find Lowther House</h1>\r\n<p>We have two first floor rooms - so we can offer excellent service. Fresh flowers greet you, in hospitality corner there is a silent running fridge for your use for beverages, wine etc. - just ask for ice and glasses. Also, there are a selection of Twinings teas and Fresh Rombouts Coffees - yours for the making, plus biscuits to nibble, an insulated carafe of chilled filtered water is also provided. A radio-controlled alarm clock with a very useful weather feature is by the bed.</p>\r\n<p>There is a Freesat TV with DVD player a selection of DVD\'s/CD\'s is available on the landing. In the closet you\'ll find shower robes, hair dryer, shaver adaptor, fan, extra bedding etc.</p>')
 ,(59,'<iframe src=\"https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d16045.60232683728!2d-0.7812352837625243!3d54.25955757072218!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x487f26281ae4319f%3A0x8462d61287f7f084!2sBridge+Row%2C+Newbridge%2C+Pickering%2C+North+Yorkshire+YO18+8JL!5e1!3m2!1sen!2suk!4v1465047689012\" width=\"100%\" height=\"500\" frameborder=\"0\" style=\"border:0\" allowfullscreen></iframe>')
 ,(60,'<h1>Booking Form</h1>')
 ,(61,'<h1>Booking Enquiry Form</h1>');

DROP TABLE IF EXISTS btContentResponsiveImage;

CREATE TABLE IF NOT EXISTS `btContentResponsiveImage` (
  `bID` int(10) unsigned NOT NULL,
  `fID` int(10) unsigned DEFAULT '0',
  `fOnstateID` int(10) unsigned DEFAULT '0',
  `maxWidth` int(10) unsigned DEFAULT '0',
  `maxHeight` int(10) unsigned DEFAULT '0',
  `externalLink` varchar(255) DEFAULT NULL,
  `internalLinkCID` int(10) unsigned DEFAULT '0',
  `forceImageToMatchDimensions` int(10) unsigned DEFAULT '0',
  `altText` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO btContentResponsiveImage VALUES(26,3,0,0,0,'',0,1,'')
 ,(27,3,0,0,0,'',0,1,'')
 ,(28,3,0,0,0,'',0,1,'')
 ,(50,3,0,0,0,'',0,1,'')
 ,(53,3,0,0,0,'',0,1,'')
 ,(56,3,0,0,0,'',0,1,'');

DROP TABLE IF EXISTS btCoreScrapbookDisplay;

CREATE TABLE IF NOT EXISTS `btCoreScrapbookDisplay` (
  `bID` int(10) unsigned NOT NULL,
  `bOriginalID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`bID`),
  KEY `bOriginalID` (`bOriginalID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS btCoreStackDisplay;

CREATE TABLE IF NOT EXISTS `btCoreStackDisplay` (
  `bID` int(10) unsigned NOT NULL,
  `stID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS btDashboardNewsflowLatest;

CREATE TABLE IF NOT EXISTS `btDashboardNewsflowLatest` (
  `bID` int(10) unsigned NOT NULL,
  `slot` varchar(1) NOT NULL,
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO btDashboardNewsflowLatest VALUES(8,'A')
 ,(9,'B')
 ,(12,'C');

DROP TABLE IF EXISTS btDateNav;

CREATE TABLE IF NOT EXISTS `btDateNav` (
  `bID` int(10) unsigned NOT NULL,
  `num` smallint(5) unsigned NOT NULL,
  `cParentID` int(10) unsigned NOT NULL DEFAULT '1',
  `cThis` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `ctID` smallint(5) unsigned DEFAULT NULL,
  `flatDisplay` int(11) DEFAULT '0',
  `defaultNode` varchar(64) DEFAULT 'current_page',
  `truncateTitles` int(11) DEFAULT '0',
  `truncateSummaries` int(11) DEFAULT '0',
  `displayFeaturedOnly` int(11) DEFAULT '0',
  `truncateChars` int(11) DEFAULT '128',
  `truncateTitleChars` int(11) DEFAULT '128',
  `showDescriptions` int(11) DEFAULT '0',
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS btExternalForm;

CREATE TABLE IF NOT EXISTS `btExternalForm` (
  `bID` int(10) unsigned NOT NULL,
  `filename` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS btFlashContent;

CREATE TABLE IF NOT EXISTS `btFlashContent` (
  `bID` int(10) unsigned NOT NULL,
  `fID` int(10) unsigned DEFAULT NULL,
  `quality` varchar(255) DEFAULT NULL,
  `minVersion` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS btFlexSlider;

CREATE TABLE IF NOT EXISTS `btFlexSlider` (
  `bID` int(10) unsigned NOT NULL,
  `fsID` int(10) unsigned DEFAULT NULL,
  `showDesc` varchar(16) DEFAULT NULL,
  `backgroundColor` varchar(16) DEFAULT NULL,
  `activeThumbColor` varchar(16) DEFAULT NULL,
  `inactiveThumbColor` varchar(16) DEFAULT NULL,
  `transition` varchar(16) DEFAULT NULL,
  `direction` varchar(16) DEFAULT NULL,
  `slidesControls` varchar(16) DEFAULT NULL,
  `transitionDelay` varchar(16) DEFAULT NULL,
  `transitionSpeed` varchar(16) DEFAULT NULL,
  `show_caption` varchar(16) DEFAULT NULL,
  `thumbnails` varchar(16) DEFAULT NULL,
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO btFlexSlider VALUES(13,1,'true',NULL,NULL,NULL,'fade','horizontal',NULL,'4000','500',NULL,'false')
 ,(17,1,'true',NULL,NULL,NULL,'fade','horizontal',NULL,'4000','500',NULL,'false')
 ,(20,1,'true',NULL,NULL,NULL,'fade','horizontal',NULL,'4000','500',NULL,'false')
 ,(38,1,'true',NULL,NULL,NULL,'fade','horizontal',NULL,'4000','500',NULL,'false')
 ,(43,1,'true',NULL,NULL,NULL,'fade','horizontal',NULL,'4000','500',NULL,'false')
 ,(46,1,'true',NULL,NULL,NULL,'fade','horizontal',NULL,'4000','500',NULL,'false');

DROP TABLE IF EXISTS btFlexSliderImg;

CREATE TABLE IF NOT EXISTS `btFlexSliderImg` (
  `GalleryImgId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bID` int(10) unsigned DEFAULT NULL,
  `fID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`GalleryImgId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS btForm;

CREATE TABLE IF NOT EXISTS `btForm` (
  `bID` int(10) unsigned NOT NULL,
  `questionSetId` int(10) unsigned DEFAULT '0',
  `surveyName` varchar(255) DEFAULT NULL,
  `thankyouMsg` text,
  `notifyMeOnSubmission` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `recipientEmail` varchar(255) DEFAULT NULL,
  `displayCaptcha` int(11) DEFAULT '1',
  `redirectCID` int(11) DEFAULT '0',
  `addFilesToSet` int(11) DEFAULT '0',
  PRIMARY KEY (`bID`),
  KEY `questionSetIdForeign` (`questionSetId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS btFormAnswerSet;

CREATE TABLE IF NOT EXISTS `btFormAnswerSet` (
  `asID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `questionSetId` int(10) unsigned DEFAULT '0',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `uID` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`asID`),
  KEY `questionSetId` (`questionSetId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS btFormAnswers;

CREATE TABLE IF NOT EXISTS `btFormAnswers` (
  `aID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `asID` int(10) unsigned DEFAULT '0',
  `msqID` int(10) unsigned DEFAULT '0',
  `answer` varchar(255) DEFAULT NULL,
  `answerLong` text,
  PRIMARY KEY (`aID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS btFormQuestions;

CREATE TABLE IF NOT EXISTS `btFormQuestions` (
  `qID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `msqID` int(10) unsigned DEFAULT '0',
  `bID` int(10) unsigned DEFAULT '0',
  `questionSetId` int(10) unsigned DEFAULT '0',
  `question` varchar(255) DEFAULT NULL,
  `inputType` varchar(255) DEFAULT NULL,
  `options` text,
  `position` int(10) unsigned DEFAULT '1000',
  `width` int(10) unsigned DEFAULT '50',
  `height` int(10) unsigned DEFAULT '3',
  `required` int(11) DEFAULT '0',
  PRIMARY KEY (`qID`),
  KEY `questionSetId` (`questionSetId`),
  KEY `msqID` (`msqID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS btGoogleMap;

CREATE TABLE IF NOT EXISTS `btGoogleMap` (
  `bID` int(10) unsigned NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `location` varchar(255) DEFAULT NULL,
  `latitude` double DEFAULT NULL,
  `longitude` double DEFAULT NULL,
  `zoom` int(8) DEFAULT NULL,
  `balloonShow` tinyint(4) DEFAULT NULL,
  `balloonContent` longtext,
  `balloonWithLinkToMaps` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS btGuestBook;

CREATE TABLE IF NOT EXISTS `btGuestBook` (
  `bID` int(10) unsigned NOT NULL,
  `requireApproval` int(11) DEFAULT '0',
  `title` varchar(100) DEFAULT 'Comments',
  `dateFormat` varchar(100) DEFAULT NULL,
  `displayGuestBookForm` int(11) DEFAULT '1',
  `displayCaptcha` int(11) DEFAULT '1',
  `authenticationRequired` int(11) DEFAULT '0',
  `notifyEmail` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS btGuestBookEntries;

CREATE TABLE IF NOT EXISTS `btGuestBookEntries` (
  `bID` int(11) DEFAULT NULL,
  `cID` int(11) DEFAULT '1',
  `entryID` int(11) NOT NULL AUTO_INCREMENT,
  `uID` int(11) DEFAULT '0',
  `commentText` longtext,
  `user_name` varchar(100) DEFAULT NULL,
  `user_email` varchar(100) DEFAULT NULL,
  `entryDate` datetime DEFAULT '0000-00-00 00:00:00',
  `approved` int(11) DEFAULT '1',
  PRIMARY KEY (`entryID`),
  KEY `cID` (`cID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS btNavigation;

CREATE TABLE IF NOT EXISTS `btNavigation` (
  `bID` int(10) unsigned NOT NULL,
  `orderBy` varchar(255) DEFAULT 'alpha_asc',
  `displayPages` varchar(255) DEFAULT 'top',
  `displayPagesCID` int(10) unsigned NOT NULL DEFAULT '1',
  `displayPagesIncludeSelf` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `displaySubPages` varchar(255) DEFAULT 'none',
  `displaySubPageLevels` varchar(255) DEFAULT 'none',
  `displaySubPageLevelsNum` smallint(5) unsigned NOT NULL DEFAULT '0',
  `displayUnavailablePages` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS btNextPrevious;

CREATE TABLE IF NOT EXISTS `btNextPrevious` (
  `bID` int(10) unsigned NOT NULL,
  `linkStyle` varchar(32) DEFAULT NULL,
  `nextLabel` varchar(128) DEFAULT NULL,
  `previousLabel` varchar(128) DEFAULT NULL,
  `parentLabel` varchar(128) DEFAULT NULL,
  `showArrows` int(11) DEFAULT '1',
  `loopSequence` int(11) DEFAULT '1',
  `excludeSystemPages` int(11) DEFAULT '1',
  `orderBy` varchar(20) DEFAULT 'display_asc',
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS btPageList;

CREATE TABLE IF NOT EXISTS `btPageList` (
  `bID` int(10) unsigned NOT NULL,
  `num` smallint(5) unsigned NOT NULL,
  `orderBy` varchar(32) DEFAULT NULL,
  `cParentID` int(10) unsigned NOT NULL DEFAULT '1',
  `cThis` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `includeAllDescendents` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `paginate` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `displayAliases` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `ctID` smallint(5) unsigned DEFAULT NULL,
  `rss` int(11) DEFAULT '0',
  `rssTitle` varchar(255) DEFAULT NULL,
  `rssDescription` longtext,
  `truncateSummaries` int(11) DEFAULT '0',
  `displayFeaturedOnly` int(11) DEFAULT '0',
  `truncateChars` int(11) DEFAULT '128',
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS btRssDisplay;

CREATE TABLE IF NOT EXISTS `btRssDisplay` (
  `bID` int(10) unsigned NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `dateFormat` varchar(100) DEFAULT NULL,
  `itemsToDisplay` int(10) unsigned DEFAULT '5',
  `showSummary` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `launchInNewWindow` tinyint(3) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS btSearch;

CREATE TABLE IF NOT EXISTS `btSearch` (
  `bID` int(10) unsigned NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `buttonText` varchar(128) DEFAULT NULL,
  `baseSearchPath` varchar(255) DEFAULT NULL,
  `postTo_cID` varchar(255) DEFAULT NULL,
  `resultsURL` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS btSlideshow;

CREATE TABLE IF NOT EXISTS `btSlideshow` (
  `bID` int(10) unsigned NOT NULL,
  `fsID` int(10) unsigned DEFAULT NULL,
  `playback` varchar(50) DEFAULT NULL,
  `duration` int(10) unsigned DEFAULT NULL,
  `fadeDuration` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS btSlideshowImg;

CREATE TABLE IF NOT EXISTS `btSlideshowImg` (
  `slideshowImgId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bID` int(10) unsigned DEFAULT NULL,
  `fID` int(10) unsigned DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `duration` int(10) unsigned DEFAULT NULL,
  `fadeDuration` int(10) unsigned DEFAULT NULL,
  `groupSet` int(10) unsigned DEFAULT NULL,
  `position` int(10) unsigned DEFAULT NULL,
  `imgHeight` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`slideshowImgId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS btSurvey;

CREATE TABLE IF NOT EXISTS `btSurvey` (
  `bID` int(10) unsigned NOT NULL,
  `question` varchar(255) DEFAULT '',
  `requiresRegistration` int(11) DEFAULT '0',
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS btSurveyOptions;

CREATE TABLE IF NOT EXISTS `btSurveyOptions` (
  `optionID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bID` int(11) DEFAULT NULL,
  `optionName` varchar(255) DEFAULT NULL,
  `displayOrder` int(11) DEFAULT '0',
  PRIMARY KEY (`optionID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS btSurveyResults;

CREATE TABLE IF NOT EXISTS `btSurveyResults` (
  `resultID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `optionID` int(10) unsigned DEFAULT '0',
  `uID` int(10) unsigned DEFAULT '0',
  `bID` int(11) DEFAULT NULL,
  `cID` int(11) DEFAULT NULL,
  `ipAddress` varchar(128) DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`resultID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS btTags;

CREATE TABLE IF NOT EXISTS `btTags` (
  `bID` int(10) unsigned NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `targetCID` int(11) DEFAULT NULL,
  `displayMode` varchar(20) DEFAULT 'page',
  `cloudCount` int(11) DEFAULT '10',
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS btVideo;

CREATE TABLE IF NOT EXISTS `btVideo` (
  `bID` int(10) unsigned NOT NULL,
  `fID` int(10) unsigned DEFAULT NULL,
  `width` int(10) unsigned DEFAULT NULL,
  `height` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS btYouTube;

CREATE TABLE IF NOT EXISTS `btYouTube` (
  `bID` int(10) unsigned NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `videoURL` varchar(255) DEFAULT NULL,
  `vHeight` varchar(255) DEFAULT NULL,
  `vWidth` varchar(255) DEFAULT NULL,
  `vPlayer` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



